/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.dog;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.imglib2.Interval;
import net.imglib2.Point;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.dog.DifferenceOfGaussian;
import net.imglib2.algorithm.localextrema.LocalExtrema;
import net.imglib2.algorithm.localextrema.RefinedPeak;
import net.imglib2.algorithm.localextrema.SubpixelLocalization;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

public class DogDetection<T extends RealType<T> & NativeType<T>> {
    private ExecutorService executorService;
    protected final RandomAccessible<T> input;
    protected final Interval interval;
    protected final double sigmaSmaller;
    protected final double sigmaLarger;
    protected final double[] pixelSize;
    protected final TypedDogDetection<?> typedDogDetection;
    protected double imageSigma;
    protected double minf;
    protected ExtremaType extremaType;
    protected double minPeakValue;
    protected boolean normalizeMinPeakValue;
    protected boolean keepDoGImg;
    protected int numThreads;

    public DogDetection(RandomAccessibleInterval<T> input, double[] calibration, double sigmaSmaller, double sigmaLarger, ExtremaType extremaType, double minPeakValue, boolean normalizeMinPeakValue) {
        this(Views.extendMirrorSingle(input), input, calibration, sigmaSmaller, sigmaLarger, extremaType, minPeakValue, normalizeMinPeakValue);
    }

    public DogDetection(RandomAccessible<T> input, Interval interval, double[] calibration, double sigmaSmaller, double sigmaLarger, ExtremaType extremaType, double minPeakValue, boolean normalizeMinPeakValue) {
        this(input, interval, calibration, sigmaSmaller, sigmaLarger, extremaType, minPeakValue, normalizeMinPeakValue, new DogComputationType(input, interval).getType());
    }

    public <F extends RealType<F> & NativeType<F>> DogDetection(RandomAccessible<T> input, Interval interval, double[] calibration, double sigmaSmaller, double sigmaLarger, ExtremaType extremaType, double minPeakValue, boolean normalizeMinPeakValue, F computationType) {
        this.input = input;
        this.interval = interval;
        this.sigmaSmaller = sigmaSmaller;
        this.sigmaLarger = sigmaLarger;
        this.pixelSize = calibration;
        this.typedDogDetection = new TypedDogDetection(this, computationType);
        this.imageSigma = 0.5;
        this.minf = 2.0;
        this.extremaType = extremaType;
        this.minPeakValue = minPeakValue;
        this.normalizeMinPeakValue = normalizeMinPeakValue;
        this.keepDoGImg = true;
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public ArrayList<Point> getPeaks() {
        return this.typedDogDetection.getPeaks();
    }

    public ArrayList<RefinedPeak<Point>> getSubpixelPeaks() {
        return this.typedDogDetection.getSubpixelPeaks();
    }

    public void setImageSigma(double imageSigma) {
        this.imageSigma = imageSigma;
    }

    public void setMinf(double minf) {
        this.minf = minf;
    }

    public void setMinPeakValue(double minPeakValue) {
        this.minPeakValue = minPeakValue;
    }

    public void setNormalizeMinPeakValue(boolean normalizeMinPeakValue) {
        this.normalizeMinPeakValue = normalizeMinPeakValue;
    }

    public void setKeepDoGImg(boolean keepDoGImg) {
        this.keepDoGImg = keepDoGImg;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public double getImageSigma() {
        return this.imageSigma;
    }

    public double getMinf() {
        return this.minf;
    }

    public double getMinPeakValue() {
        return this.minPeakValue;
    }

    public boolean getNormalizeMinPeakValue() {
        return this.normalizeMinPeakValue;
    }

    public boolean getKeepDoGImg() {
        return this.keepDoGImg;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setExecutorService(ExecutorService service) {
        this.executorService = service;
    }

    protected static class TypedDogDetection<F extends RealType<F> & NativeType<F>> {
        protected final F type;
        protected RandomAccessibleInterval<F> dogImg;
        final /* synthetic */ DogDetection this$0;

        public TypedDogDetection(F type) {
            this.this$0 = this$0;
            this.type = type;
        }

        public ArrayList<Point> getPeaks() {
            LocalExtrema.LocalNeighborhoodCheck localNeighborhoodCheck;
            ExecutorService service = this.this$0.executorService == null ? Executors.newFixedThreadPool(this.this$0.numThreads) : this.this$0.executorService;
            this.dogImg = Util.getArrayOrCellImgFactory(this.this$0.interval, (NativeType)this.type).create(this.this$0.interval);
            long[] translation = new long[this.this$0.interval.numDimensions()];
            this.this$0.interval.min(translation);
            this.dogImg = Views.translate(this.dogImg, translation);
            double[][] sigmas = DifferenceOfGaussian.computeSigmas(this.this$0.imageSigma, this.this$0.minf, this.this$0.pixelSize, this.this$0.sigmaSmaller, this.this$0.sigmaLarger);
            DifferenceOfGaussian.DoG(sigmas[0], sigmas[1], this.this$0.input, this.dogImg, service);
            RealType val = (RealType)this.type.createVariable();
            double minValueT = this.type.getMinValue();
            double maxValueT = this.type.getMaxValue();
            double normalization = this.this$0.normalizeMinPeakValue ? this.this$0.sigmaLarger / this.this$0.sigmaSmaller - 1.0 : 1.0;
            switch (this.this$0.extremaType) {
                case MINIMA: {
                    val.setReal(Math.max(Math.min(-this.this$0.minPeakValue * normalization, maxValueT), minValueT));
                    localNeighborhoodCheck = new LocalExtrema.MinimumCheck<RealType>(val);
                    break;
                }
                default: {
                    val.setReal(Math.max(Math.min(this.this$0.minPeakValue * normalization, maxValueT), minValueT));
                    localNeighborhoodCheck = new LocalExtrema.MaximumCheck<RealType>(val);
                }
            }
            ArrayList<Point> peaks = LocalExtrema.findLocalExtrema(this.dogImg, localNeighborhoodCheck, service);
            if (!this.this$0.keepDoGImg) {
                this.dogImg = null;
            }
            if (this.this$0.executorService == null) {
                service.shutdown();
            }
            return peaks;
        }

        public ArrayList<RefinedPeak<Point>> getSubpixelPeaks() {
            boolean savedKeepDoGImg = this.this$0.keepDoGImg;
            this.this$0.keepDoGImg = true;
            ArrayList<Point> peaks = this.getPeaks();
            SubpixelLocalization<Point, F> spl = new SubpixelLocalization<Point, F>(this.dogImg.numDimensions());
            spl.setAllowMaximaTolerance(true);
            spl.setMaxNumMoves(10);
            ArrayList<RefinedPeak<Point>> refined = spl.process(peaks, this.dogImg, this.dogImg);
            this.this$0.keepDoGImg = savedKeepDoGImg;
            if (!this.this$0.keepDoGImg) {
                this.dogImg = null;
            }
            return refined;
        }
    }

    private static class DogComputationType<F extends RealType<F> & NativeType<F>> {
        private final F type;

        public DogComputationType(RandomAccessible<?> input, Interval interval) {
            Object t = Util.getTypeFromInterval(Views.interval(input, interval));
            this.type = t instanceof DoubleType ? new DoubleType() : new FloatType();
        }

        public F getType() {
            return this.type;
        }
    }

    public static enum ExtremaType {
        MINIMA,
        MAXIMA;

    }
}

