/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gauss3;

import net.imglib2.RandomAccess;
import net.imglib2.algorithm.gauss3.ConvolverFactory;
import net.imglib2.type.numeric.RealType;

public final class FloatConvolverRealType<S extends RealType<S>, T extends RealType<T>>
implements Runnable {
    private final float[] kernel;
    private final RandomAccess<S> in;
    private final RandomAccess<T> out;
    private final int d;
    private final int k;
    private final int k1;
    private final int k1k1;
    private final int k1k;
    private final long fill2;
    private final boolean fillAdditional;
    private final float[] buf1;
    private final float[] buf2;

    public static <S extends RealType<S>, T extends RealType<T>> ConvolverFactory<S, T> factory() {
        return new ConvolverFactory<S, T>(){

            @Override
            public Runnable create(double[] halfkernel, RandomAccess<S> in, RandomAccess<T> out, int d, long lineLength) {
                return new FloatConvolverRealType(halfkernel, in, out, d, lineLength);
            }
        };
    }

    private FloatConvolverRealType(double[] kernel, RandomAccess<S> in, RandomAccess<T> out, int d, long lineLength) {
        this.kernel = new float[kernel.length];
        for (int i = 0; i < kernel.length; ++i) {
            this.kernel[i] = (float)kernel[i];
        }
        this.in = in;
        this.out = out;
        this.d = d;
        this.k = this.kernel.length;
        this.k1 = this.k - 1;
        this.k1k1 = this.k1 + this.k1;
        this.k1k = this.k1 + this.k;
        this.fill2 = lineLength / 2L;
        this.fillAdditional = lineLength % 2L == 1L;
        int l = 2 * this.k;
        this.buf1 = new float[l];
        this.buf2 = new float[l];
    }

    private void prefill1() {
        float w = ((RealType)this.in.get()).getRealFloat();
        this.buf1[this.k1] = w * this.kernel[0] + this.buf2[this.k];
        for (int i = 1; i < this.k1; ++i) {
            float wk = w * this.kernel[i];
            this.buf1[this.k1 + i] = wk + this.buf2[this.k + i];
            this.buf1[this.k1 - i] = wk + this.buf2[this.k - i];
        }
        this.buf1[this.k1k1] = w * this.kernel[this.k1] + this.buf2[this.k1k];
        this.in.fwd(this.d);
    }

    private void prefill2() {
        float w = ((RealType)this.in.get()).getRealFloat();
        this.buf2[this.k1] = w * this.kernel[0] + this.buf1[this.k];
        for (int i = 1; i < this.k1; ++i) {
            float wk = w * this.kernel[i];
            this.buf2[this.k1 + i] = wk + this.buf1[this.k + i];
            this.buf2[this.k1 - i] = wk + this.buf1[this.k - i];
        }
        this.buf2[this.k1k1] = w * this.kernel[this.k1] + this.buf1[this.k1k];
        this.in.fwd(this.d);
    }

    private void next2() {
        float w = ((RealType)this.in.get()).getRealFloat();
        this.buf2[this.k1] = w * this.kernel[0] + this.buf1[this.k];
        for (int i = 1; i < this.k1; ++i) {
            float wk = w * this.kernel[i];
            this.buf2[this.k1 + i] = wk + this.buf1[this.k + i];
            this.buf2[this.k1 - i] = wk + this.buf1[this.k - i];
        }
        float wk = w * this.kernel[this.k1];
        this.buf2[this.k1k1] = wk + this.buf1[this.k1k];
        ((RealType)this.out.get()).setReal(wk + this.buf1[1]);
        this.in.fwd(this.d);
        this.out.fwd(this.d);
    }

    private void next1() {
        float w = ((RealType)this.in.get()).getRealFloat();
        this.buf1[this.k1] = w * this.kernel[0] + this.buf2[this.k];
        for (int i = 1; i < this.k1; ++i) {
            float wk = w * this.kernel[i];
            this.buf1[this.k1 + i] = wk + this.buf2[this.k + i];
            this.buf1[this.k1 - i] = wk + this.buf2[this.k - i];
        }
        float wk = w * this.kernel[this.k1];
        this.buf1[this.k1k1] = wk + this.buf2[this.k1k];
        ((RealType)this.out.get()).setReal(wk + this.buf2[1]);
        this.in.fwd(this.d);
        this.out.fwd(this.d);
    }

    @Override
    public void run() {
        for (int i = 0; i < this.k1; ++i) {
            this.prefill1();
            this.prefill2();
        }
        for (long i = 0L; i < this.fill2; ++i) {
            this.next1();
            this.next2();
        }
        if (this.fillAdditional) {
            this.next1();
        }
    }
}

