/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.kdtree;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.util.LinAlgHelpers;

public class HyperPlane
extends AbstractEuclideanSpace {
    private final double[] normal;
    private final double distance;

    public HyperPlane(double[] normal, double distance) {
        super(normal.length);
        this.normal = (double[])normal.clone();
        this.distance = distance;
        LinAlgHelpers.normalize(this.normal);
    }

    public HyperPlane(double ... normalAndDistance) {
        super(normalAndDistance.length - 1);
        this.normal = new double[this.n];
        System.arraycopy(normalAndDistance, 0, this.normal, 0, this.n);
        this.distance = normalAndDistance[this.n];
        LinAlgHelpers.normalize(this.normal);
    }

    public double[] getNormal() {
        return this.normal;
    }

    public double getDistance() {
        return this.distance;
    }

    public static HyperPlane transform(HyperPlane plane, AffineGet transform) {
        assert (plane.numDimensions() == transform.numDimensions());
        int n = transform.numDimensions();
        double[] O = new double[n];
        double[] tO = new double[n];
        LinAlgHelpers.scale(plane.getNormal(), plane.getDistance(), O);
        transform.apply(O, tO);
        double[][] m = new double[n][n];
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c < n; ++c) {
                m[r][c] = transform.inverse().get(c, r);
            }
        }
        double[] tN = new double[n];
        LinAlgHelpers.mult(m, plane.getNormal(), tN);
        LinAlgHelpers.normalize(tN);
        double td = LinAlgHelpers.dot(tN, tO);
        return new HyperPlane(tN, td);
    }
}

