/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.morphology;

import java.util.List;
import java.util.Vector;
import net.imglib2.Cursor;
import net.imglib2.FinalDimensions;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.morphology.MorphologyUtils;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.multithreading.Chunk;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class Dilation {
    public static <T extends RealType<T>> Img<T> dilate(Img<T> source, List<Shape> strels, int numThreads) {
        Img<T> target = source;
        for (Shape strel : strels) {
            target = Dilation.dilateFull(target, strel, numThreads);
        }
        return MorphologyUtils.copyCropped(target, source, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> dilate(Img<T> source, List<Shape> strels, T minVal, int numThreads) {
        Img<T> target = source;
        for (Shape strel : strels) {
            target = Dilation.dilateFull(target, strel, minVal, numThreads);
        }
        return MorphologyUtils.copyCropped(target, source, numThreads);
    }

    public static <T extends RealType<T>> Img<T> dilate(Img<T> source, Shape strel, int numThreads) {
        Img<T> target = source.factory().create(source);
        RealType minVal = (RealType)((RealType)source.firstElement()).createVariable();
        minVal.setReal(minVal.getMinValue());
        ExtendedRandomAccessibleInterval<RealType, Img<T>> extended = Views.extendValue(source, minVal);
        Dilation.dilate(extended, target, strel, numThreads);
        return target;
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> dilate(Img<T> source, Shape strel, T minVal, int numThreads) {
        Img<T> target = source.factory().create(source);
        ExtendedRandomAccessibleInterval<T, Img<T>> extended = Views.extendValue(source, minVal);
        Dilation.dilate(extended, target, strel, minVal, numThreads);
        return target;
    }

    public static <T extends RealType<T>> void dilate(RandomAccessible<T> source, IterableInterval<T> target, List<Shape> strels, int numThreads) {
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, target);
        minVal.setReal(minVal.getMinValue());
        Dilation.dilate(source, target, strels, minVal, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void dilate(RandomAccessible<T> source, IterableInterval<T> target, List<Shape> strels, T minVal, int numThreads) {
        if (strels.isEmpty()) {
            return;
        }
        if (strels.size() == 1) {
            Dilation.dilate(source, target, strels.get(0), minVal, numThreads);
            return;
        }
        long[] targetDims = new long[target.numDimensions()];
        long[] translation = new long[target.numDimensions()];
        for (int d = 0; d < targetDims.length; ++d) {
            targetDims[d] = target.dimension(d);
            translation[d] = target.min(d);
        }
        for (Shape strel : strels) {
            Neighborhood<BitType> nh = MorphologyUtils.getNeighborhood(strel, target);
            for (int d = 0; d < translation.length; ++d) {
                int n = d;
                translation[n] = translation[n] - nh.dimension(d) / 2L;
                int n2 = d;
                targetDims[n2] = targetDims[n2] + (nh.dimension(d) - 1L);
            }
        }
        ImgFactory<T> factory = Util.getSuitableImgFactory(new FinalDimensions(targetDims), minVal);
        Img<T> temp = factory.create(targetDims);
        IntervalView<T> translated = Views.translate(temp, translation);
        Dilation.dilate(source, translated, strels.get(0), minVal, numThreads);
        for (int i = 1; i < strels.size(); ++i) {
            temp = Dilation.dilate(temp, strels.get(i), minVal, numThreads);
        }
        long[] offset = new long[target.numDimensions()];
        for (int d = 0; d < offset.length; ++d) {
            offset[d] = target.min(d) - (temp.dimension(d) - target.dimension(d)) / 2L;
        }
        MorphologyUtils.copy2(Views.translate(temp, offset), target, numThreads);
    }

    public static <T extends RealType<T>> void dilate(RandomAccessible<T> source, IterableInterval<T> target, Shape strel, int numThreads) {
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, target);
        minVal.setReal(minVal.getMinValue());
        Dilation.dilate(source, target, strel, minVal, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void dilate(final RandomAccessible<T> source, final IterableInterval<T> target, Shape strel, final T minVal, int numThreads) {
        numThreads = Math.max(1, numThreads);
        final RandomAccessible<Neighborhood<T>> accessible = strel.neighborhoodsRandomAccessible(source);
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(target.size(), numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        T tmp = minVal;
        if (tmp instanceof BitType) {
            for (int i = 0; i < threads.length; ++i) {
                final Chunk chunk = chunks.get(i);
                threads[i] = new Thread("Morphology dilate thread " + i){

                    @Override
                    public void run() {
                        RandomAccess randomAccess = accessible.randomAccess(target);
                        RealCursor tmp2 = target.cursor();
                        Cursor cursorDilated = (Cursor)tmp2;
                        cursorDilated.jumpFwd(chunk.getStartPosition());
                        block0: for (long steps = 0L; steps < chunk.getLoopSize(); ++steps) {
                            cursorDilated.fwd();
                            randomAccess.setPosition(cursorDilated);
                            Neighborhood neighborhood = (Neighborhood)randomAccess.get();
                            RealCursor tmp3 = neighborhood.cursor();
                            Cursor nc = (Cursor)tmp3;
                            while (nc.hasNext()) {
                                nc.fwd();
                                BitType val = (BitType)nc.get();
                                if (!val.get()) continue;
                                ((BitType)cursorDilated.get()).set(true);
                                continue block0;
                            }
                        }
                    }
                };
            }
        } else {
            for (int i = 0; i < threads.length; ++i) {
                final Chunk chunk = chunks.get(i);
                threads[i] = new Thread("Morphology dilate thread " + i){

                    @Override
                    public void run() {
                        RandomAccess randomAccess = accessible.randomAccess(target);
                        RealCursor cursorDilated = target.cursor();
                        cursorDilated.jumpFwd(chunk.getStartPosition());
                        Type max = MorphologyUtils.createVariable(source, target);
                        for (long steps = 0L; steps < chunk.getLoopSize(); ++steps) {
                            cursorDilated.fwd();
                            randomAccess.setPosition((Localizable)((Object)cursorDilated));
                            Neighborhood neighborhood = (Neighborhood)randomAccess.get();
                            RealCursor nc = neighborhood.cursor();
                            max.set((Type)minVal);
                            while (nc.hasNext()) {
                                nc.fwd();
                                Type val = (Type)nc.get();
                                if (((Comparable)((Object)val)).compareTo(max) <= 0) continue;
                                max.set((Type)val);
                            }
                            ((Type)cursorDilated.get()).set(max);
                        }
                    }
                };
            }
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    public static <T extends RealType<T>> Img<T> dilateFull(Img<T> source, List<Shape> strels, int numThreads) {
        Img<T> target = source;
        for (Shape strel : strels) {
            target = Dilation.dilateFull(target, strel, numThreads);
        }
        return target;
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> dilateFull(Img<T> source, List<Shape> strels, T minVal, int numThreads) {
        Img<T> target = source;
        for (Shape strel : strels) {
            target = Dilation.dilateFull(target, strel, minVal, numThreads);
        }
        return target;
    }

    public static <T extends RealType<T>> Img<T> dilateFull(Img<T> source, Shape strel, int numThreads) {
        long[][] dimensionsAndOffset = MorphologyUtils.computeTargetImageDimensionsAndOffset(source, strel);
        long[] targetDims = dimensionsAndOffset[0];
        long[] offset = dimensionsAndOffset[1];
        Img<T> target = source.factory().create(targetDims);
        IntervalView<T> offsetTarget = Views.offset(target, offset);
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, source);
        minVal.setReal(minVal.getMinValue());
        ExtendedRandomAccessibleInterval<RealType, Img<T>> extended = Views.extendValue(source, minVal);
        Dilation.dilate(extended, offsetTarget, strel, numThreads);
        return target;
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> dilateFull(Img<T> source, Shape strel, T minVal, int numThreads) {
        long[][] dimensionsAndOffset = MorphologyUtils.computeTargetImageDimensionsAndOffset(source, strel);
        long[] targetDims = dimensionsAndOffset[0];
        long[] offset = dimensionsAndOffset[1];
        Img<T> target = source.factory().create(targetDims);
        IntervalView<T> offsetTarget = Views.offset(target, offset);
        ExtendedRandomAccessibleInterval<T, Img<T>> extended = Views.extendValue(source, minVal);
        Dilation.dilate(extended, offsetTarget, strel, minVal, numThreads);
        return target;
    }

    public static <T extends RealType<T>> void dilateInPlace(RandomAccessibleInterval<T> source, Interval interval, List<Shape> strels, int numThreads) {
        for (Shape strel : strels) {
            Dilation.dilateInPlace(source, interval, strel, numThreads);
        }
    }

    public static <T extends Type<T> & Comparable<T>> void dilateInPlace(RandomAccessibleInterval<T> source, Interval interval, List<Shape> strels, T minVal, int numThreads) {
        for (Shape strel : strels) {
            Dilation.dilateInPlace(source, interval, strel, minVal, numThreads);
        }
    }

    public static <T extends RealType<T>> void dilateInPlace(RandomAccessibleInterval<T> source, Interval interval, Shape strel, int numThreads) {
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, interval);
        minVal.setReal(minVal.getMinValue());
        ExtendedRandomAccessibleInterval<RealType, RandomAccessibleInterval<T>> extended = Views.extendValue(source, minVal);
        ImgFactory<RealType> factory = Util.getSuitableImgFactory(interval, minVal);
        Img<RealType> img = factory.create(interval);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView<RealType> translated = Views.translate(img, min);
        Dilation.dilate(extended, translated, strel, numThreads);
        MorphologyUtils.copy(translated, extended, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void dilateInPlace(RandomAccessibleInterval<T> source, Interval interval, Shape strel, T minVal, int numThreads) {
        ExtendedRandomAccessibleInterval<T, RandomAccessibleInterval<T>> extended = Views.extendValue(source, minVal);
        ImgFactory<T> factory = Util.getSuitableImgFactory(interval, minVal);
        Img<T> img = factory.create(interval);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView<T> translated = Views.translate(img, min);
        Dilation.dilate(extended, translated, strel, minVal, numThreads);
        MorphologyUtils.copy(translated, extended, numThreads);
    }

    private Dilation() {
    }
}

