/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.pde;

import java.util.Vector;
import net.imglib2.FinalDimensions;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.MultiThreadedBenchmarkAlgorithm;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.multithreading.Chunk;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;

public class IsotropicDiffusionTensor<T extends RealType<T>>
extends MultiThreadedBenchmarkAlgorithm
implements OutputAlgorithm<Img<FloatType>> {
    private static final String BASE_ERROR_MESSAGE = "[" + IsotropicDiffusionTensor.class.getSimpleName() + "] ";
    private final float val;
    private final long[] dimensions;
    private final Img<FloatType> D;

    public IsotropicDiffusionTensor(long[] dimensions, float val) {
        this.dimensions = dimensions;
        this.val = val;
        long[] tensorDims = new long[dimensions.length + 1];
        for (int i = 0; i < dimensions.length; ++i) {
            tensorDims[i] = dimensions[i];
        }
        tensorDims[dimensions.length] = dimensions.length * (dimensions.length - 1);
        ImgFactory<FloatType> factory = Util.getSuitableImgFactory(new FinalDimensions(dimensions), new FloatType());
        this.D = factory.create(tensorDims);
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public boolean process() {
        long start = System.currentTimeMillis();
        final int tensorDim = this.dimensions.length;
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(this.D.size(), this.numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(this.numThreads);
        for (int i = 0; i < threads.length; ++i) {
            final Chunk chunk = chunks.get(i);
            threads[i] = new Thread("" + BASE_ERROR_MESSAGE + "thread " + i){

                @Override
                public void run() {
                    RealCursor cursor = IsotropicDiffusionTensor.this.D.localizingCursor();
                    cursor.jumpFwd(chunk.getStartPosition());
                    for (long step = 0L; step < chunk.getLoopSize(); ++step) {
                        cursor.fwd();
                        if (cursor.getIntPosition(tensorDim) < IsotropicDiffusionTensor.this.dimensions.length) {
                            ((FloatType)cursor.get()).set(IsotropicDiffusionTensor.this.val);
                            continue;
                        }
                        ((FloatType)cursor.get()).setZero();
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin(threads);
        this.processingTime = System.currentTimeMillis() - start;
        return true;
    }

    @Override
    public Img<FloatType> getResult() {
        return this.D;
    }
}

