/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealPositionable;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;

public abstract class AbstractNeighborhood<T>
implements Positionable,
IterableInterval<T> {
    protected final long[] center;
    protected final long[] span;
    protected ExtendedRandomAccessibleInterval<T, RandomAccessibleInterval<T>> extendedSource;
    protected RandomAccessibleInterval<T> source;
    protected OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds;
    protected int n;

    public AbstractNeighborhood(int numDims, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds) {
        this.n = numDims;
        this.outOfBounds = outOfBounds;
        this.center = new long[numDims];
        this.span = new long[numDims];
    }

    public void setSpan(long[] span) {
        for (int d = 0; d < span.length; ++d) {
            this.span[d] = span[d];
        }
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    @Override
    public void fwd(int d) {
        int n = d;
        this.center[n] = this.center[n] + 1L;
    }

    @Override
    public void bck(int d) {
        int n = d;
        this.center[n] = this.center[n] - 1L;
    }

    @Override
    public void move(int distance, int d) {
        this.center[d] = this.center[d] + (long)distance;
    }

    @Override
    public void move(long distance, int d) {
        this.center[d] = this.center[d] + distance;
    }

    @Override
    public void move(Localizable localizable) {
        for (int d = 0; d < this.center.length; ++d) {
            int n = d;
            this.center[n] = this.center[n] + localizable.getLongPosition(d);
        }
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.center.length; ++d) {
            int n = d;
            this.center[n] = this.center[n] + (long)distance[d];
        }
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.center.length; ++d) {
            int n = d;
            this.center[n] = this.center[n] + distance[d];
        }
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.center.length; ++d) {
            this.center[d] = localizable.getLongPosition(d);
        }
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < this.center.length; ++d) {
            this.center[d] = position[d];
        }
    }

    @Override
    public void setPosition(long[] position) {
        for (int d = 0; d < this.center.length; ++d) {
            this.center[d] = position[d];
        }
    }

    @Override
    public void setPosition(int position, int d) {
        this.center[d] = position;
    }

    @Override
    public void setPosition(long position, int d) {
        this.center[d] = position;
    }

    @Override
    public T firstElement() {
        RandomAccess ra = this.source.randomAccess();
        for (int d = 0; d < this.span.length; ++d) {
            ra.setPosition(this.center[d] - this.span[d], d);
        }
        return ra.get();
    }

    @Override
    public Object iterationOrder() {
        return this;
    }

    @Override
    public double realMin(int d) {
        return this.center[d] - this.span[d];
    }

    @Override
    public void realMin(double[] min) {
        for (int d = 0; d < this.center.length; ++d) {
            min[d] = this.center[d] - this.span[d];
        }
    }

    @Override
    public void realMin(RealPositionable min) {
        for (int d = 0; d < this.center.length; ++d) {
            min.setPosition(this.center[d] - this.span[d], d);
        }
    }

    @Override
    public double realMax(int d) {
        return this.center[d] + this.span[d];
    }

    @Override
    public void realMax(double[] max) {
        for (int d = 0; d < this.center.length; ++d) {
            max[d] = this.center[d] + this.span[d];
        }
    }

    @Override
    public void realMax(RealPositionable max) {
        for (int d = 0; d < this.center.length; ++d) {
            max.setPosition(this.center[d] + this.span[d], d);
        }
    }

    @Override
    public long min(int d) {
        return this.center[d] - this.span[d];
    }

    @Override
    public void min(long[] min) {
        for (int d = 0; d < this.center.length; ++d) {
            min[d] = this.center[d] - this.span[d];
        }
    }

    @Override
    public void min(Positionable min) {
        for (int d = 0; d < this.center.length; ++d) {
            min.setPosition(this.center[d] - this.span[d], d);
        }
    }

    @Override
    public long max(int d) {
        return this.center[d] + this.span[d];
    }

    @Override
    public void max(long[] max) {
        for (int d = 0; d < this.center.length; ++d) {
            max[d] = this.center[d] + this.span[d];
        }
    }

    @Override
    public void max(Positionable max) {
        for (int d = 0; d < this.center.length; ++d) {
            max.setPosition(this.center[d] + this.span[d], d);
        }
    }

    @Override
    public void dimensions(long[] dimensions) {
        for (int d = 0; d < this.span.length; ++d) {
            dimensions[d] = 2L * this.span[d] + 1L;
        }
    }

    @Override
    public long dimension(int d) {
        return 2L * this.span[d] + 1L;
    }

    public void updateSource(RandomAccessibleInterval<T> source) {
        this.source = source;
        this.extendedSource = Views.extend(source, this.outOfBounds);
    }

    public abstract AbstractNeighborhood<T> copy();
}

