/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.basictypeaccess;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.imglib2.Dirty;
import net.imglib2.img.basictypeaccess.volatiles.VolatileAccess;

public enum AccessFlags {
    DIRTY,
    VOLATILE;

    private static final Set<AccessFlags> flags_DIRTY_VOLATILE;
    private static final Set<AccessFlags> flags_DIRTY;
    private static final Set<AccessFlags> flags_VOLATILE;
    private static final Set<AccessFlags> flags_NONE;

    public static Set<AccessFlags> ofAccess(Object access) {
        boolean dirtyAccesses = access instanceof Dirty;
        boolean volatileAccesses = access instanceof VolatileAccess;
        return AccessFlags.fromBooleansDirtyVolatile(dirtyAccesses, volatileAccesses);
    }

    public static Set<AccessFlags> setOf() {
        return flags_NONE;
    }

    public static Set<AccessFlags> setOf(AccessFlags f1) {
        return f1 == DIRTY ? flags_DIRTY : flags_VOLATILE;
    }

    public static Set<AccessFlags> setOf(AccessFlags f1, AccessFlags f2) {
        return f1 == DIRTY ? (f2 == DIRTY ? flags_DIRTY : flags_DIRTY_VOLATILE) : (f2 == DIRTY ? flags_DIRTY_VOLATILE : flags_VOLATILE);
    }

    public static Set<AccessFlags> setOf(AccessFlags ... flags) {
        boolean dirtyAccesses = false;
        boolean volatileAccesses = false;
        for (AccessFlags flag : flags) {
            if (flag == DIRTY) {
                dirtyAccesses = true;
                continue;
            }
            if (flag != VOLATILE) continue;
            volatileAccesses = true;
        }
        return AccessFlags.fromBooleansDirtyVolatile(dirtyAccesses, volatileAccesses);
    }

    public static Set<AccessFlags> fromBooleansDirtyVolatile(boolean dirtyAccesses, boolean volatileAccesses) {
        return dirtyAccesses ? (volatileAccesses ? flags_DIRTY_VOLATILE : flags_DIRTY) : (volatileAccesses ? flags_VOLATILE : flags_NONE);
    }

    static {
        flags_DIRTY_VOLATILE = Collections.unmodifiableSet(EnumSet.of(DIRTY, VOLATILE));
        flags_DIRTY = Collections.unmodifiableSet(EnumSet.of(DIRTY));
        flags_VOLATILE = Collections.unmodifiableSet(EnumSet.of(VOLATILE));
        flags_NONE = Collections.unmodifiableSet(EnumSet.noneOf(AccessFlags.class));
    }
}

