/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.basictypeaccess.nio;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import net.imglib2.img.basictypeaccess.array.AbstractLongArray;
import net.imglib2.img.basictypeaccess.nio.AbstractBufferAccess;
import net.imglib2.img.basictypeaccess.volatiles.VolatileLongAccess;

public class LongBufferAccess
extends AbstractBufferAccess<LongBufferAccess, LongBuffer>
implements VolatileLongAccess {
    private static final long serialVersionUID = -7265085228179236189L;
    private static final int NUM_BYTES_PER_ENTITY = 8;

    public LongBufferAccess(LongBuffer buffer, boolean isValid) {
        super(buffer, isValid);
    }

    public LongBufferAccess(int numEntities, boolean isValid) {
        super(LongBuffer.allocate(numEntities), isValid);
    }

    public LongBufferAccess(ByteBuffer buffer, boolean isValid) {
        super(buffer.asLongBuffer(), isValid);
    }

    public LongBufferAccess(LongBuffer buffer) {
        this(buffer, true);
    }

    public LongBufferAccess(int numEntities) {
        this(numEntities, true);
    }

    public LongBufferAccess(ByteBuffer buffer) {
        this(buffer, true);
    }

    public LongBufferAccess() {
        this((LongBuffer)null, false);
    }

    @Override
    public long getValue(int index) {
        return ((LongBuffer)this.buffer).get(index);
    }

    @Override
    public void setValue(int index, long value) {
        ((LongBuffer)this.buffer).put(index, value);
    }

    @Override
    public int getNumBytesPerEntity() {
        return 8;
    }

    @Override
    public LongBufferAccess newInstance(ByteBuffer buffer, boolean isValid) {
        return LongBufferAccess.fromByteBuffer(buffer, isValid);
    }

    @Override
    public LongBufferAccess newInstance(LongBuffer buffer, boolean isValid) {
        return new LongBufferAccess(buffer, isValid);
    }

    @Override
    LongBuffer duplicateBuffer(LongBuffer buffer) {
        return buffer.duplicate();
    }

    @Override
    LongBufferAccess allocate(int numEntities, boolean isDirect, boolean isValid) {
        if (isDirect) {
            return (LongBufferAccess)super.allocate(numEntities, isDirect, isValid);
        }
        return new LongBufferAccess(numEntities, isValid);
    }

    public static LongBufferAccess fromByteBuffer(ByteBuffer buffer, boolean isValid) {
        return new LongBufferAccess(buffer, isValid);
    }

    public LongBuffer getValues(AbstractLongArray<?> array) {
        return ((LongBuffer)this.buffer).duplicate().get(array.getCurrentStorageArray());
    }

    public LongBuffer getValues(AbstractLongArray<?> array, int offset, int length) {
        return ((LongBuffer)this.buffer).duplicate().get(array.getCurrentStorageArray(), offset, length);
    }

    public LongBuffer setValues(AbstractLongArray<?> array) {
        return ((LongBuffer)this.buffer).duplicate().put(array.getCurrentStorageArray());
    }

    public LongBuffer setValues(AbstractLongArray<?> array, int offset, int length) {
        return ((LongBuffer)this.buffer).duplicate().put(array.getCurrentStorageArray(), offset, length);
    }

    public LongBuffer setValues(LongBufferAccess access) {
        return ((LongBuffer)this.buffer).duplicate().put((LongBuffer)access.getCurrentStorageArray());
    }
}

