/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.basictypeaccess.nio;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import net.imglib2.img.basictypeaccess.array.AbstractShortArray;
import net.imglib2.img.basictypeaccess.nio.AbstractBufferAccess;
import net.imglib2.img.basictypeaccess.volatiles.VolatileShortAccess;

public class ShortBufferAccess
extends AbstractBufferAccess<ShortBufferAccess, ShortBuffer>
implements VolatileShortAccess {
    private static final long serialVersionUID = -7265085228179236189L;
    private static final int NUM_BYTES_PER_ENTITY = 2;

    public ShortBufferAccess(ShortBuffer buffer, boolean isValid) {
        super(buffer, isValid);
    }

    public ShortBufferAccess(int numEntities, boolean isValid) {
        super(ShortBuffer.allocate(numEntities), isValid);
    }

    public ShortBufferAccess(ByteBuffer buffer, boolean isValid) {
        super(buffer.asShortBuffer(), isValid);
    }

    public ShortBufferAccess(ShortBuffer buffer) {
        this(buffer, true);
    }

    public ShortBufferAccess(int numEntities) {
        this(numEntities, true);
    }

    public ShortBufferAccess(ByteBuffer buffer) {
        this(buffer, true);
    }

    public ShortBufferAccess() {
        this((ShortBuffer)null, false);
    }

    @Override
    public short getValue(int index) {
        return ((ShortBuffer)this.buffer).get(index);
    }

    @Override
    public void setValue(int index, short value) {
        ((ShortBuffer)this.buffer).put(index, value);
    }

    @Override
    public int getNumBytesPerEntity() {
        return 2;
    }

    @Override
    public ShortBufferAccess newInstance(ByteBuffer buffer, boolean isValid) {
        return ShortBufferAccess.fromByteBuffer(buffer, isValid);
    }

    @Override
    public ShortBufferAccess newInstance(ShortBuffer buffer, boolean isValid) {
        return new ShortBufferAccess(buffer, isValid);
    }

    @Override
    ShortBuffer duplicateBuffer(ShortBuffer buffer) {
        return buffer.duplicate();
    }

    @Override
    ShortBufferAccess allocate(int numEntities, boolean isDirect, boolean isValid) {
        if (isDirect) {
            return (ShortBufferAccess)super.allocate(numEntities, isDirect, isValid);
        }
        return new ShortBufferAccess(numEntities, isValid);
    }

    public static ShortBufferAccess fromByteBuffer(ByteBuffer buffer, boolean isValid) {
        return new ShortBufferAccess(buffer, isValid);
    }

    public ShortBuffer getValues(AbstractShortArray<?> array) {
        return ((ShortBuffer)this.buffer).duplicate().get(array.getCurrentStorageArray());
    }

    public ShortBuffer getValues(AbstractShortArray<?> array, int offset, int length) {
        return ((ShortBuffer)this.buffer).duplicate().get(array.getCurrentStorageArray(), offset, length);
    }

    public ShortBuffer setValues(AbstractShortArray<?> array) {
        return ((ShortBuffer)this.buffer).duplicate().put(array.getCurrentStorageArray());
    }

    public ShortBuffer setValues(AbstractShortArray<?> array, int offset, int length) {
        return ((ShortBuffer)this.buffer).duplicate().put(array.getCurrentStorageArray(), offset, length);
    }

    public ShortBuffer setValues(ShortBufferAccess access) {
        return ((ShortBuffer)this.buffer).duplicate().put((ShortBuffer)access.getCurrentStorageArray());
    }
}

