/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labeling;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.imglib2.RandomAccess;
import net.imglib2.RealCursor;
import net.imglib2.labeling.BoundingBox;
import net.imglib2.labeling.Labeling;
import net.imglib2.labeling.LabelingOutOfBoundsRandomAccess;
import net.imglib2.labeling.LabelingROIStrategy;
import net.imglib2.labeling.LabelingType;
import net.imglib2.roi.AbstractIterableRegionOfInterest;
import net.imglib2.roi.IterableRegionOfInterest;
import net.imglib2.roi.RegionOfInterest;
import net.imglib2.type.logic.BitType;

@Deprecated
public class DefaultROIStrategy<T extends Comparable<T>, L extends Labeling<T>>
implements LabelingROIStrategy<T, L> {
    protected final L labeling;
    protected long generation;
    protected Map<T, LabelStatistics> statistics;

    public DefaultROIStrategy(L labeling) {
        this.labeling = labeling;
        this.generation = Long.MIN_VALUE;
    }

    protected synchronized void computeStatistics() {
        LabelingType type = (LabelingType)this.labeling.firstElement();
        if (type == null || type.getGeneration() != this.generation) {
            this.statistics = new HashMap<T, LabelStatistics>();
            long[] position = new long[this.labeling.numDimensions()];
            LabelStatistics last = null;
            Comparable lastLabel = null;
            RealCursor c = this.labeling.localizingCursor();
            while (c.hasNext()) {
                type = (LabelingType)c.next();
                c.localize(position);
                for (Comparable label : type.getLabeling()) {
                    if (last == null || !label.equals(lastLabel)) {
                        lastLabel = label;
                        last = this.statistics.get(label);
                        if (last == null) {
                            last = new LabelStatistics(this.labeling.numDimensions());
                            this.statistics.put(label, last);
                        }
                    }
                    last.update(position);
                }
            }
            this.generation = type.getGeneration();
        }
    }

    @Override
    public boolean getExtents(T label, long[] minExtents, long[] maxExtents) {
        this.computeStatistics();
        LabelStatistics stats = this.statistics.get(label);
        if (stats == null) {
            if (minExtents != null) {
                Arrays.fill(minExtents, 0L);
            }
            if (maxExtents != null) {
                Arrays.fill(maxExtents, 0L);
            }
            return false;
        }
        stats.getExtents(minExtents, maxExtents);
        return true;
    }

    @Override
    public boolean getRasterStart(T label, long[] start) {
        this.computeStatistics();
        LabelStatistics stats = this.statistics.get(label);
        if (stats == null) {
            Arrays.fill(start, 0L);
            return false;
        }
        stats.getRasterStart(start);
        return true;
    }

    @Override
    public long getArea(T label) {
        this.computeStatistics();
        LabelStatistics stats = this.statistics.get(label);
        if (stats == null) {
            return 0L;
        }
        return stats.getArea();
    }

    @Override
    public Collection<T> getLabels() {
        this.computeStatistics();
        return this.statistics.keySet();
    }

    @Override
    public RegionOfInterest createRegionOfInterest(T label) {
        return new DefaultRegionOfInterest(this, label);
    }

    @Override
    public IterableRegionOfInterest createIterableRegionOfInterest(T label) {
        return new DefaultRegionOfInterest(this, label);
    }

    static class DefaultRegionOfInterest
    extends AbstractIterableRegionOfInterest {
        T label;
        final RandomAccess<LabelingType<T>> randomAccess;
        final LabelStatistics labelStats;
        final long[] min;
        final long[] max;
        final long[] firstRaster;
        final double[] real_min;
        final double[] real_max;
        final /* synthetic */ DefaultROIStrategy this$0;

        DefaultRegionOfInterest(T label) {
            this.this$0 = this$0;
            super(this$0.labeling.numDimensions());
            this.label = label;
            this.randomAccess = new LabelingOutOfBoundsRandomAccess(this$0.labeling);
            this$0.computeStatistics();
            this.labelStats = this$0.statistics.get(label);
            this.min = new long[this$0.labeling.numDimensions()];
            this.max = new long[this$0.labeling.numDimensions()];
            this.firstRaster = new long[this$0.labeling.numDimensions()];
            this.labelStats.getExtents(this.min, this.max);
            this.labelStats.getRasterStart(this.firstRaster);
            this.real_min = new double[this$0.labeling.numDimensions()];
            this.real_max = new double[this$0.labeling.numDimensions()];
            this.labelStats.getExtents(this.min, this.max);
            for (int i = 0; i < this$0.labeling.numDimensions(); ++i) {
                this.real_min[i] = this.min[i];
                this.real_max[i] = this.max[i];
            }
        }

        @Override
        protected long size() {
            return this.labelStats.getArea();
        }

        @Override
        public boolean contains(double[] position) {
            for (int i = 0; i < position.length; ++i) {
                this.randomAccess.setPosition((int)position[i], i);
            }
            return ((LabelingType)this.randomAccess.get()).getLabeling().contains(this.label);
        }

        @Override
        protected void getExtrema(long[] minima, long[] maxima) {
            System.arraycopy(this.min, 0, minima, 0, this.numDimensions());
            System.arraycopy(this.max, 0, maxima, 0, this.numDimensions());
        }

        @Override
        protected boolean nextRaster(long[] position, long[] end) {
            int i;
            for (i = this.numDimensions() - 1; i >= 0; --i) {
                if (position[i] >= this.min[i]) continue;
                System.arraycopy(this.min, 0, position, 0, i + 1);
                position[0] = position[0] - 1L;
                break;
            }
            do {
                for (i = 0; i < this.numDimensions(); ++i) {
                    if (position[i] < this.max[i]) {
                        int n = i;
                        position[n] = position[n] + 1L;
                        break;
                    }
                    position[i] = this.min[i];
                }
                if (i == this.numDimensions()) {
                    return false;
                }
                this.randomAccess.setPosition(position);
            } while (!((LabelingType)this.randomAccess.get()).getLabeling().contains(this.label));
            System.arraycopy(position, 0, end, 0, this.numDimensions());
            do {
                end[0] = end[0] + 1L;
                this.randomAccess.setPosition(end);
            } while (end[0] <= this.max[0] && ((LabelingType)this.randomAccess.get()).getLabeling().contains(this.label));
            return true;
        }

        @Override
        public void move(double displacement, int d) {
            throw new UnsupportedOperationException("yet to be implemented");
        }

        @Override
        public void move(double[] displacement) {
            throw new UnsupportedOperationException("yet to be implemented");
        }

        @Override
        public BitType getType() {
            return new BitType();
        }
    }

    private class LabelStatistics
    extends BoundingBox {
        private final long[] rasterStart;
        private long area;

        public LabelStatistics(int dimensions) {
            super(dimensions);
            this.area = 0L;
            this.rasterStart = new long[dimensions];
            Arrays.fill(this.rasterStart, Integer.MAX_VALUE);
        }

        public void getRasterStart(long[] start) {
            System.arraycopy(this.rasterStart, 0, start, 0, this.rasterStart.length);
        }

        public long getArea() {
            return this.area;
        }

        @Override
        public void update(long[] position) {
            super.update(position);
            ++this.area;
            for (int i = 0; i < this.rasterStart.length; ++i) {
                if (this.rasterStart[i] > position[i]) {
                    System.arraycopy(position, 0, this.rasterStart, 0, this.rasterStart.length);
                    return;
                }
                if (this.rasterStart[i] >= position[i]) continue;
                return;
            }
        }
    }
}

