/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.loops;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RealCursor;
import net.imglib2.loops.FastCursorRandomAccessLoops;
import net.imglib2.loops.IntervalChunks;
import net.imglib2.loops.ListUtils;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.parallel.Parallelization;
import net.imglib2.parallel.TaskExecutor;
import net.imglib2.parallel.TaskExecutors;

public class IterableLoopBuilder<T> {
    private TaskExecutor taskExecutor = TaskExecutors.singleThreaded();
    private final IterableInterval<?> firstImage;
    private final List<RandomAccessible<?>> otherImages;

    private IterableLoopBuilder(IterableInterval<?> firstImage, RandomAccessible<?> ... otherImages) {
        this.firstImage = firstImage;
        this.otherImages = Arrays.asList(otherImages);
    }

    public static <A> IterableLoopBuilder<Consumer<A>> setImages(IterableInterval<A> a) {
        return new IterableLoopBuilder<Consumer<A>>(a, new RandomAccessible[0]);
    }

    public static <A, B> IterableLoopBuilder<BiConsumer<A, B>> setImages(IterableInterval<A> a, RandomAccessible<B> b) {
        return new IterableLoopBuilder<BiConsumer<A, B>>(a, b);
    }

    public static <A, B, C> IterableLoopBuilder<LoopBuilder.TriConsumer<A, B, C>> setImages(IterableInterval<A> a, RandomAccessible<B> b, RandomAccessible<C> c) {
        return new IterableLoopBuilder<LoopBuilder.TriConsumer<A, B, C>>(a, b, c);
    }

    public void forEachPixel(T action) {
        this.forEachChunk(chunk -> {
            chunk.forEachPixel(action);
            return null;
        });
    }

    public <R> List<R> forEachChunk(Function<LoopBuilder.Chunk<T>, R> chunkAction) {
        List<Interval> intervals = IntervalChunks.chunkInterval(new FinalInterval(this.firstImage.size()), this.taskExecutor.suggestNumberOfTasks());
        List<Chunk> chunks = ListUtils.map(interval -> new Chunk(this.firstImage, this.otherImages, (Interval)interval), intervals);
        return this.taskExecutor.forEachApply(chunks, chunkAction);
    }

    public IterableLoopBuilder<T> multithreaded() {
        return this.multithreaded(Parallelization.getTaskExecutor());
    }

    public IterableLoopBuilder<T> multithreaded(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
        return this;
    }

    private static class Chunk<T>
    implements LoopBuilder.Chunk<T> {
        private final IterableInterval<?> firstImage;
        private final List<RandomAccessible<?>> otherImages;
        private final Interval interval;

        private Chunk(IterableInterval<?> firstImage, List<RandomAccessible<?>> otherImages, Interval interval) {
            this.firstImage = firstImage;
            this.otherImages = otherImages;
            this.interval = interval;
        }

        @Override
        public void forEachPixel(T action) {
            RealCursor cursor = this.firstImage.localizingCursor();
            List randomAccesses = this.otherImages.stream().map(RandomAccessible::randomAccess).collect(Collectors.toList());
            cursor.jumpFwd(this.interval.min(0));
            long size = this.interval.dimension(0);
            FastCursorRandomAccessLoops.loop(action, size, cursor, randomAccesses);
        }
    }
}

