/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.inverse.AbstractDifferentiableRealTransform;

public class ThinplateSplineTransform
extends AbstractDifferentiableRealTransform
implements RealTransform {
    private final ThinPlateR2LogRSplineKernelTransform tps;
    private final double[] a;
    private final double[] b;
    private final double[] tmp;
    private final RealPoint rpa;
    double[] estimateXfm;
    private AffineTransform jacobian;

    private static final ThinPlateR2LogRSplineKernelTransform init(double[][] p, double[][] q) {
        assert (p.length == q.length);
        ThinPlateR2LogRSplineKernelTransform tps = new ThinPlateR2LogRSplineKernelTransform(p.length, p, q);
        return tps;
    }

    public ThinplateSplineTransform(ThinPlateR2LogRSplineKernelTransform tps) {
        this.tps = tps;
        this.a = new double[tps.getNumDims()];
        this.b = new double[this.a.length];
        this.tmp = new double[this.a.length];
        this.rpa = RealPoint.wrap(this.a);
        this.estimateXfm = new double[tps.getNumDims()];
    }

    public ThinplateSplineTransform(double[][] p, double[][] q) {
        this(ThinplateSplineTransform.init(p, q));
    }

    @Override
    public void apply(double[] source, double[] target) {
        if (source == target) {
            System.arraycopy(source, 0, this.tmp, 0, source.length);
            this.tps.apply(this.tmp, target);
        } else {
            this.tps.apply(source, target);
        }
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        this.rpa.setPosition(source);
        this.tps.apply(this.a, this.b);
        for (int d = 0; d < this.a.length; ++d) {
            target.setPosition(this.b[d], d);
        }
    }

    @Override
    public ThinplateSplineTransform copy() {
        return new ThinplateSplineTransform(this.tps);
    }

    @Override
    public int numSourceDimensions() {
        return this.tps.getNumDims();
    }

    @Override
    public int numTargetDimensions() {
        return this.tps.getNumDims();
    }

    @Override
    public AffineTransform jacobian(double[] x) {
        double[][] jac = this.tps.jacobian(x);
        double[] jflat = new double[x.length * (x.length + 1)];
        int k = 0;
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x.length + 1; ++j) {
                if (j < x.length) {
                    jflat[k++] = jac[i][j];
                    continue;
                }
                ++k;
            }
        }
        this.jacobian = new AffineTransform(x.length);
        this.jacobian.set(jflat);
        return this.jacobian;
    }

    public ThinPlateR2LogRSplineKernelTransform getKernelTransform() {
        return this.tps;
    }
}

