/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.composite;

import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.BoundaryType;
import net.imglib2.roi.KnownConstant;
import net.imglib2.roi.Operators;
import net.imglib2.roi.RealMask;
import net.imglib2.roi.composite.BinaryCompositeMaskPredicate;

public class DefaultBinaryCompositeRealMask
extends AbstractEuclideanSpace
implements BinaryCompositeMaskPredicate<RealLocalizable>,
RealMask {
    private final Operators.BinaryMaskOperator operator;
    private final Predicate<? super RealLocalizable> arg0;
    private final Predicate<? super RealLocalizable> arg1;
    private final BoundaryType boundaryType;
    private final Predicate<? super RealLocalizable> predicate;
    private final BinaryOperator<KnownConstant> knownConstantOp;

    public DefaultBinaryCompositeRealMask(Operators.BinaryMaskOperator operator, Predicate<? super RealLocalizable> arg0, Predicate<? super RealLocalizable> arg1, int numDimensions, BoundaryType boundaryType, BinaryOperator<KnownConstant> knownConstantOp) {
        super(numDimensions);
        this.operator = operator;
        this.arg0 = arg0;
        this.arg1 = arg1;
        this.boundaryType = boundaryType;
        this.predicate = operator.predicate(arg0, arg1);
        this.knownConstantOp = knownConstantOp;
    }

    @Override
    public BoundaryType boundaryType() {
        return this.boundaryType;
    }

    @Override
    public KnownConstant knownConstant() {
        return (KnownConstant)((Object)this.knownConstantOp.apply(KnownConstant.of(this.arg0), KnownConstant.of(this.arg1)));
    }

    @Override
    public boolean test(RealLocalizable localizable) {
        return this.predicate.test(localizable);
    }

    @Override
    public Operators.BinaryMaskOperator operator() {
        return this.operator;
    }

    @Override
    public Predicate<? super RealLocalizable> arg0() {
        return this.arg0;
    }

    @Override
    public Predicate<? super RealLocalizable> arg1() {
        return this.arg1;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BinaryCompositeMaskPredicate) || !(obj instanceof RealMask)) {
            return false;
        }
        BinaryCompositeMaskPredicate b = (BinaryCompositeMaskPredicate)obj;
        return b.operator() == this.operator && this.arg0.equals(b.arg0()) && this.arg1.equals(b.arg1());
    }

    public int hashCode() {
        return (this.arg0.hashCode() + this.arg1.hashCode() * this.arg1.hashCode() + this.operator.hashCode()) * 87;
    }
}

