/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.composite;

import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.BoundaryType;
import net.imglib2.roi.KnownConstant;
import net.imglib2.roi.Operators;
import net.imglib2.roi.RealMask;
import net.imglib2.roi.composite.UnaryCompositeMaskPredicate;

public class DefaultUnaryCompositeRealMask
extends AbstractEuclideanSpace
implements UnaryCompositeMaskPredicate<RealLocalizable>,
RealMask {
    private final Operators.UnaryMaskOperator operator;
    private final Predicate<? super RealLocalizable> arg0;
    private final BoundaryType boundaryType;
    private final Predicate<? super RealLocalizable> predicate;
    private final UnaryOperator<KnownConstant> knownConstantOp;

    public DefaultUnaryCompositeRealMask(Operators.UnaryMaskOperator operator, Predicate<? super RealLocalizable> arg0, int numDimensions, BoundaryType boundaryType, UnaryOperator<KnownConstant> knownConstantOp) {
        super(numDimensions);
        this.operator = operator;
        this.arg0 = arg0;
        this.boundaryType = boundaryType;
        this.predicate = operator.predicate(arg0);
        this.knownConstantOp = knownConstantOp;
    }

    @Override
    public BoundaryType boundaryType() {
        return this.boundaryType;
    }

    @Override
    public KnownConstant knownConstant() {
        return (KnownConstant)((Object)this.knownConstantOp.apply(KnownConstant.of(this.arg0)));
    }

    @Override
    public boolean test(RealLocalizable localizable) {
        return this.predicate.test(localizable);
    }

    @Override
    public Operators.UnaryMaskOperator operator() {
        return this.operator;
    }

    @Override
    public Predicate<? super RealLocalizable> arg0() {
        return this.arg0;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UnaryCompositeMaskPredicate) || !(obj instanceof RealMask)) {
            return false;
        }
        UnaryCompositeMaskPredicate u = (UnaryCompositeMaskPredicate)obj;
        return u.operator().equals(this.operator) && this.arg0.equals(u.arg0());
    }

    public int hashCode() {
        return this.arg0.hashCode() + this.operator.hashCode() * 21;
    }
}

