/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.labeling;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.imglib2.AbstractWrappedInterval;
import net.imglib2.Cursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.converter.AbstractConvertedCursor;
import net.imglib2.converter.AbstractConvertedRandomAccess;
import net.imglib2.roi.labeling.LabelingMapping;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.view.Views;
import net.imglib2.view.iteration.SubIntervalIterable;

public class ImgLabeling<T, I extends IntegerType<I>>
extends AbstractWrappedInterval<RandomAccessibleInterval<I>>
implements RandomAccessibleInterval<LabelingType<T>>,
IterableInterval<LabelingType<T>>,
SubIntervalIterable<LabelingType<T>> {
    private final RandomAccessibleInterval<I> indexAccessible;
    private final IterableInterval<I> indexIterable;
    private final boolean subIterable;
    private final LabelingType.ModCount generation;
    private final LabelingMapping<T> mapping;

    public ImgLabeling(RandomAccessibleInterval<I> img) {
        super(img);
        this.indexAccessible = img;
        this.indexIterable = Views.iterable(img);
        this.subIterable = this.indexIterable instanceof SubIntervalIterable;
        this.generation = new LabelingType.ModCount();
        this.mapping = new LabelingMapping((IntegerType)this.indexIterable.firstElement());
    }

    public static <T, I extends IntegerType<I>> ImgLabeling<T, I> fromImageAndLabelSets(RandomAccessibleInterval<I> img, List<Set<T>> labelSets) {
        ImgLabeling<T, I> result = new ImgLabeling<T, I>(img);
        result.getMapping().setLabelSets(labelSets);
        return result;
    }

    public static <T, I extends IntegerType<I>> ImgLabeling<T, I> fromImageAndLabels(RandomAccessibleInterval<I> img, List<T> labels) {
        List<Set<T>> labelSets = Stream.concat(Stream.of(Collections.emptySet()), labels.stream().map(Collections::singleton)).collect(Collectors.toList());
        return ImgLabeling.fromImageAndLabelSets(img, labelSets);
    }

    public LabelingMapping<T> getMapping() {
        return this.mapping;
    }

    @Override
    public RandomAccess<LabelingType<T>> randomAccess() {
        return new LabelingConvertedRandomAccess(this.indexAccessible.randomAccess());
    }

    @Override
    public RandomAccess<LabelingType<T>> randomAccess(Interval interval) {
        return new LabelingConvertedRandomAccess(this.indexAccessible.randomAccess(interval));
    }

    @Override
    public Cursor<LabelingType<T>> cursor() {
        return new LabelingConvertedCursor(this.indexIterable.cursor());
    }

    @Override
    public Cursor<LabelingType<T>> localizingCursor() {
        return new LabelingConvertedCursor(this.indexIterable.localizingCursor());
    }

    @Override
    public LabelingType<T> firstElement() {
        return (LabelingType)this.cursor().next();
    }

    @Override
    public LabelingType<T> getType() {
        return new LabelingType<T>((IntegerType)this.indexAccessible.getType(), this.mapping, this.generation);
    }

    @Override
    public Iterator<LabelingType<T>> iterator() {
        return this.cursor();
    }

    @Override
    public long size() {
        return this.indexIterable.size();
    }

    @Override
    public Object iterationOrder() {
        return this.indexIterable.iterationOrder();
    }

    @Override
    public boolean supportsOptimizedCursor(Interval interval) {
        if (this.subIterable) {
            return ((SubIntervalIterable)this.indexIterable).supportsOptimizedCursor(interval);
        }
        return false;
    }

    @Override
    public Object subIntervalIterationOrder(Interval interval) {
        if (this.subIterable) {
            return ((SubIntervalIterable)this.indexIterable).subIntervalIterationOrder(interval);
        }
        return new FlatIterationOrder(interval);
    }

    @Override
    public Cursor<LabelingType<T>> cursor(Interval interval) {
        RealCursor c = this.subIterable ? ((SubIntervalIterable)this.indexIterable).cursor(interval) : Views.interval(this.indexAccessible, interval).cursor();
        return new LabelingConvertedCursor(c);
    }

    @Override
    public Cursor<LabelingType<T>> localizingCursor(Interval interval) {
        RealCursor c = this.subIterable ? ((SubIntervalIterable)this.indexIterable).localizingCursor(interval) : Views.interval(this.indexAccessible, interval).localizingCursor();
        return new LabelingConvertedCursor(c);
    }

    public RandomAccessibleInterval<I> getIndexImg() {
        return this.indexAccessible;
    }

    class LabelingConvertedCursor
    extends AbstractConvertedCursor<I, LabelingType<T>> {
        private final LabelingType<T> type;

        public LabelingConvertedCursor(Cursor<I> source) {
            super(source);
            this.type = new LabelingType(null, ImgLabeling.this.mapping, ImgLabeling.this.generation);
        }

        @Override
        public LabelingType<T> get() {
            this.type.setType((IntegerType)this.source.get());
            return this.type;
        }

        @Override
        public LabelingType<T> getType() {
            return this.type;
        }

        @Override
        public LabelingConvertedCursor copy() {
            return new LabelingConvertedCursor(this.source.copyCursor());
        }
    }

    class LabelingConvertedRandomAccess
    extends AbstractConvertedRandomAccess<I, LabelingType<T>> {
        private final LabelingType<T> type;

        public LabelingConvertedRandomAccess(RandomAccess<I> source) {
            super(source);
            this.type = new LabelingType(null, ImgLabeling.this.mapping, ImgLabeling.this.generation);
        }

        @Override
        public LabelingType<T> get() {
            this.type.setType((IntegerType)this.source.get());
            return this.type;
        }

        @Override
        public LabelingType<T> getType() {
            return this.type;
        }

        @Override
        public LabelingConvertedRandomAccess copy() {
            return new LabelingConvertedRandomAccess(this.source.copyRandomAccess());
        }
    }
}

