/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.labeling;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.roi.labeling.LabelRegion;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.logic.BoolType;

public class LabelRegionRandomAccess<T>
extends AbstractEuclideanSpace
implements RandomAccess<BoolType> {
    private final T label;
    private final BoolType type;
    private final RandomAccess<LabelingType<T>> source;
    private final long[] offset;
    private final long[] tmp;

    public LabelRegionRandomAccess(LabelRegion<T> region, long[] offset) {
        super(region.numDimensions());
        this.source = region.regions.labeling.randomAccess(region);
        this.label = region.getLabel();
        this.type = new BoolType();
        this.offset = offset;
        this.tmp = new long[this.n];
    }

    public LabelRegionRandomAccess(LabelRegion<T> region, Interval interval, long[] offset) {
        super(region.numDimensions());
        this.source = region.regions.labeling.randomAccess(interval);
        this.label = region.getLabel();
        this.type = new BoolType();
        this.offset = offset;
        this.tmp = new long[this.n];
    }

    protected LabelRegionRandomAccess(LabelRegionRandomAccess<T> a) {
        super(a.numDimensions());
        this.source = a.source.copyRandomAccess();
        this.type = a.type.copy();
        this.label = a.label;
        this.offset = a.offset;
        this.tmp = new long[this.n];
    }

    @Override
    public BoolType get() {
        this.type.set(((LabelingType)this.source.get()).contains(this.label));
        return this.type;
    }

    @Override
    public BoolType getType() {
        return this.type;
    }

    @Override
    public LabelRegionRandomAccess<T> copy() {
        return new LabelRegionRandomAccess<T>(this);
    }

    @Override
    public LabelRegionRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }

    @Override
    public void localize(int[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.source.getIntPosition(d) + (int)this.offset[d];
        }
    }

    @Override
    public void localize(long[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.source.getLongPosition(d) + (long)((int)this.offset[d]);
        }
    }

    @Override
    public int getIntPosition(int d) {
        assert (d <= this.n);
        return this.source.getIntPosition(d) + (int)this.offset[d];
    }

    @Override
    public long getLongPosition(int d) {
        assert (d <= this.n);
        return this.source.getLongPosition(d) + (long)((int)this.offset[d]);
    }

    @Override
    public void localize(float[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.source.getFloatPosition(d) + (float)this.offset[d];
        }
    }

    @Override
    public void localize(double[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.source.getDoublePosition(d) + (double)this.offset[d];
        }
    }

    @Override
    public float getFloatPosition(int d) {
        assert (d <= this.n);
        return this.source.getFloatPosition(d) + (float)this.offset[d];
    }

    @Override
    public double getDoublePosition(int d) {
        assert (d <= this.n);
        return this.source.getDoublePosition(d) + (double)this.offset[d];
    }

    @Override
    public void fwd(int d) {
        this.source.fwd(d);
    }

    @Override
    public void bck(int d) {
        this.source.bck(d);
    }

    @Override
    public void move(int distance, int d) {
        this.source.move(distance, d);
    }

    @Override
    public void move(long distance, int d) {
        this.source.move(distance, d);
    }

    @Override
    public void move(Localizable localizable) {
        this.source.move(localizable);
    }

    @Override
    public void move(int[] distance) {
        this.source.move(distance);
    }

    @Override
    public void move(long[] distance) {
        this.source.move(distance);
    }

    @Override
    public void setPosition(Localizable localizable) {
        assert (localizable.numDimensions() == this.n);
        localizable.localize(this.tmp);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.tmp[n] = this.tmp[n] - this.offset[d];
        }
        this.source.setPosition(this.tmp);
    }

    @Override
    public void setPosition(int[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            this.tmp[d] = (long)position[d] - this.offset[d];
        }
        this.source.setPosition(this.tmp);
    }

    @Override
    public void setPosition(long[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            this.tmp[d] = position[d] - this.offset[d];
        }
        this.source.setPosition(this.tmp);
    }

    @Override
    public void setPosition(int position, int d) {
        assert (d <= this.n);
        this.source.setPosition((long)position - this.offset[d], d);
    }

    @Override
    public void setPosition(long position, int d) {
        assert (d <= this.n);
        this.source.setPosition(position - this.offset[d], d);
    }
}

