/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.util.iterationcode;

import gnu.trove.list.array.TIntArrayList;
import java.util.List;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Iterator;
import net.imglib2.Localizable;
import net.imglib2.Positionable;

public class IterationCodeListIterator<P extends Positionable & Localizable>
extends AbstractEuclideanSpace
implements Iterator {
    private final List<TIntArrayList> itcodesList;
    private final long[] offset;
    private final P position;
    private int itcodesListIndex;
    private TIntArrayList itcode;
    private int itcodeIndex;
    private int itcodeOffsetX;
    private long maxX;
    private boolean hasNextRaster;

    public IterationCodeListIterator(List<TIntArrayList> itcodesList, long[] offset, P position) {
        super(position.numDimensions());
        this.position = position;
        this.itcodesList = itcodesList;
        this.offset = offset;
        this.reset();
    }

    public IterationCodeListIterator(IterationCodeListIterator<?> copyFrom, P position) {
        super(position.numDimensions());
        this.itcodesList = copyFrom.itcodesList;
        this.offset = copyFrom.offset;
        this.position = position;
        this.position.setPosition((Localizable)copyFrom.position);
        this.itcodesListIndex = copyFrom.itcodesListIndex;
        this.itcode = copyFrom.itcode;
        this.itcodeIndex = copyFrom.itcodeIndex;
        this.itcodeOffsetX = copyFrom.itcodeOffsetX;
        this.maxX = copyFrom.maxX;
        this.hasNextRaster = copyFrom.hasNextRaster;
    }

    private boolean probeNextItcode() {
        while (this.itcodesListIndex < this.itcodesList.size()) {
            if (this.itcodesList.get(this.itcodesListIndex).isEmpty()) {
                ++this.itcodesListIndex;
                continue;
            }
            return true;
        }
        return false;
    }

    private void initNextItcode() {
        this.itcode = this.itcodesList.get(this.itcodesListIndex++);
        this.itcodeIndex = 0;
        this.itcodeOffsetX = this.itcode.get(this.itcodeIndex++);
        for (int d = 1; d < this.n; ++d) {
            this.position.setPosition((long)this.itcode.get(this.itcodeIndex++) + this.offset[d], d);
        }
        this.nextRasterStretch();
    }

    private void nextRasterStretch() {
        if (this.itcodeIndex >= this.itcode.size()) {
            this.initNextItcode();
        } else {
            int minItcodeX;
            if ((minItcodeX = this.itcode.get(this.itcodeIndex++)) < 0) {
                for (int d = 1; d <= -minItcodeX; ++d) {
                    this.position.setPosition((long)this.itcode.get(this.itcodeIndex++) + this.offset[d], d);
                }
                minItcodeX = this.itcode.get(this.itcodeIndex++);
            }
            this.position.setPosition((long)(minItcodeX + this.itcodeOffsetX) + this.offset[0], 0);
            this.maxX = (long)(this.itcode.get(this.itcodeIndex++) + this.itcodeOffsetX) + this.offset[0];
            this.hasNextRaster = this.itcodeIndex < this.itcode.size() || this.probeNextItcode();
        }
    }

    @Override
    public void jumpFwd(long steps) {
        for (long j = 0L; j < steps; ++j) {
            this.fwd();
        }
    }

    @Override
    public void fwd() {
        this.position.fwd(0);
        if (((Localizable)this.position).getLongPosition(0) > this.maxX) {
            this.nextRasterStretch();
        }
    }

    @Override
    public void reset() {
        this.itcodesListIndex = 0;
        if (this.probeNextItcode()) {
            this.initNextItcode();
            this.position.bck(0);
        } else {
            this.hasNextRaster = false;
            this.position.setPosition(0, 0);
            this.maxX = 0L;
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNextRaster || ((Localizable)this.position).getLongPosition(0) < this.maxX;
    }
}

