/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui;

import net.imglib2.RandomAccessible;
import net.imglib2.RealRandomAccessible;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.display.screenimage.awt.ARGBScreenImage;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineSet;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.ui.AbstractMultiResolutionRenderer;
import net.imglib2.ui.AbstractRenderer;
import net.imglib2.ui.AffineTransformType;
import net.imglib2.ui.PainterThread;
import net.imglib2.ui.RenderSource;
import net.imglib2.ui.RenderTarget;
import net.imglib2.ui.RendererFactory;
import net.imglib2.ui.SimpleInterruptibleProjector;

public class MultiResolutionRenderer<A extends AffineSet & AffineGet>
extends AbstractMultiResolutionRenderer<A> {
    protected final RenderSource<?, A> source;

    public MultiResolutionRenderer(AffineTransformType<A> transformType, RenderSource<?, A> source, RenderTarget display, PainterThread painterThread, double[] screenScales, long targetRenderNanos, boolean doubleBuffered, int numRenderingThreads) {
        super(transformType, display, painterThread, screenScales, targetRenderNanos, doubleBuffered, numRenderingThreads);
        this.source = source;
    }

    @Override
    protected SimpleInterruptibleProjector<?, ARGBType> createProjector(A viewerTransform, A screenScaleTransform, ARGBScreenImage target) {
        return MultiResolutionRenderer.createProjector(this.transformType, this.source, (AffineGet)viewerTransform, (AffineGet)screenScaleTransform, target, this.numRenderingThreads);
    }

    protected static <T, A extends AffineGet & Concatenable<AffineGet>> SimpleInterruptibleProjector<T, ARGBType> createProjector(AffineTransformType<A> transformType, RenderSource<T, A> source, A viewerTransform, A screenScaleTransform, ARGBScreenImage screenImage, int numRenderingThreads) {
        return new SimpleInterruptibleProjector<T, ARGBType>(MultiResolutionRenderer.getTransformedSource(transformType, source, viewerTransform, screenScaleTransform), source.getConverter(), screenImage, numRenderingThreads);
    }

    protected static <T, A extends AffineGet & Concatenable<AffineGet>> RandomAccessible<T> getTransformedSource(AffineTransformType<A> transformType, RenderSource<T, A> source, A viewerTransform, A screenScaleTransform) {
        RealRandomAccessible<T> img = source.getInterpolatedSource();
        AffineGet sourceToScreen = (AffineGet)transformType.createTransform();
        transformType.set(sourceToScreen, screenScaleTransform);
        ((Concatenable)((Object)sourceToScreen)).concatenate(viewerTransform);
        ((Concatenable)((Object)sourceToScreen)).concatenate(source.getSourceTransform());
        return RealViews.affine(img, sourceToScreen);
    }

    public static class Factory<A extends AffineSet & AffineGet>
    implements RendererFactory<A> {
        protected final AffineTransformType<A> transformType;
        protected final RenderSource<?, A> source;
        protected final double[] screenScales;
        protected final long targetRenderNanos;
        protected final boolean doubleBuffered;
        protected final int numRenderingThreads;

        public Factory(AffineTransformType<A> transformType, RenderSource<?, A> source, double[] screenScales, long targetRenderNanos, boolean doubleBuffered, int numRenderingThreads) {
            this.transformType = transformType;
            this.source = source;
            this.screenScales = screenScales;
            this.targetRenderNanos = targetRenderNanos;
            this.doubleBuffered = doubleBuffered;
            this.numRenderingThreads = numRenderingThreads;
        }

        @Override
        public AbstractRenderer<A> create(RenderTarget display, PainterThread painterThread) {
            return new MultiResolutionRenderer<A>(this.transformType, this.source, display, painterThread, this.screenScales, this.targetRenderNanos, this.doubleBuffered, this.numRenderingThreads);
        }
    }
}

