/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.ui.TransformEventHandler;
import net.imglib2.ui.TransformEventHandlerFactory;
import net.imglib2.ui.TransformListener;

public class TransformEventHandler2D
extends MouseAdapter
implements KeyListener,
TransformEventHandler<AffineTransform2D> {
    private static final TransformEventHandlerFactory<AffineTransform2D> factory = new TransformEventHandlerFactory<AffineTransform2D>(){

        @Override
        public TransformEventHandler<AffineTransform2D> create(TransformListener<AffineTransform2D> transformListener) {
            return new TransformEventHandler2D(transformListener);
        }
    };
    protected final AffineTransform2D affine = new AffineTransform2D();
    protected TransformListener<AffineTransform2D> listener;
    protected final AffineTransform2D affineDragStart = new AffineTransform2D();
    protected double oX;
    protected double oY;
    protected int canvasW = 1;
    protected int canvasH = 1;
    protected int centerX = 0;
    protected int centerY = 0;
    private static final double step = Math.PI / 180;
    private static final String NL = System.getProperty("line.separator");
    private static final String helpString = "Mouse control:" + NL + " " + NL + "rotate the image by left-click and dragging the image in the canvas, " + NL + "move the image by middle-or-right-click and dragging the image in the canvas, " + NL + "zoom in and out using the mouse-wheel." + NL + " " + NL + "Key control:" + NL + " " + NL + "CURSOR LEFT - Rotate clockwise." + NL + "CURSOR RIGHT - Rotate counter-clockwise." + NL + "CURSOR UP - Zoom in." + NL + "CURSOR DOWN - Zoom out." + NL + "SHIFT - Rotate and zoom 10x faster." + NL + "CTRL - Rotate and zoom 10x slower.";

    public static TransformEventHandlerFactory<AffineTransform2D> factory() {
        return factory;
    }

    public TransformEventHandler2D(TransformListener<AffineTransform2D> listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AffineTransform2D getTransform() {
        AffineTransform2D affineTransform2D = this.affine;
        synchronized (affineTransform2D) {
            return this.affine.copy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransform(AffineTransform2D transform) {
        AffineTransform2D affineTransform2D = this.affine;
        synchronized (affineTransform2D) {
            this.affine.set(transform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCanvasSize(int width, int height, boolean updateTransform) {
        if (updateTransform) {
            AffineTransform2D affineTransform2D = this.affine;
            synchronized (affineTransform2D) {
                this.affine.set(this.affine.get(0, 2) - (double)(this.canvasW / 2), 0, 2);
                this.affine.set(this.affine.get(1, 2) - (double)(this.canvasH / 2), 1, 2);
                this.affine.scale((double)width / (double)this.canvasW);
                this.affine.set(this.affine.get(0, 2) + (double)(width / 2), 0, 2);
                this.affine.set(this.affine.get(1, 2) + (double)(height / 2), 1, 2);
                this.update();
            }
        }
        this.canvasW = width;
        this.canvasH = height;
        this.centerX = width / 2;
        this.centerY = height / 2;
    }

    @Override
    public void setTransformListener(TransformListener<AffineTransform2D> transformListener) {
        this.listener = transformListener;
    }

    @Override
    public String getHelpString() {
        return helpString;
    }

    protected void update() {
        if (this.listener != null) {
            this.listener.transformChanged(this.affine);
        }
    }

    private static double keyModfiedSpeed(int modifiers) {
        if ((modifiers & 0x40) != 0) {
            return 10.0;
        }
        if ((modifiers & 0x80) != 0) {
            return 0.1;
        }
        return 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent e) {
        AffineTransform2D affineTransform2D = this.affine;
        synchronized (affineTransform2D) {
            this.oX = e.getX();
            this.oY = e.getY();
            this.affineDragStart.set(this.affine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        AffineTransform2D affineTransform2D = this.affine;
        synchronized (affineTransform2D) {
            int modifiers = e.getModifiersEx();
            if ((modifiers & 0x400) != 0) {
                this.affine.set(this.affineDragStart);
                double dX = e.getX() - this.centerX;
                double dY = e.getY() - this.centerY;
                double odX = this.oX - (double)this.centerX;
                double odY = this.oY - (double)this.centerY;
                double theta = Math.atan2(dY, dX) - Math.atan2(odY, odX);
                this.rotate(theta);
            } else if ((modifiers & 0x1800) != 0) {
                this.affine.set(this.affineDragStart);
                double dX = this.oX - (double)e.getX();
                double dY = this.oY - (double)e.getY();
                this.affine.set(this.affine.get(0, 2) - dX, 0, 2);
                this.affine.set(this.affine.get(1, 2) - dY, 1, 2);
            }
            this.update();
        }
    }

    private void scale(double s, double x, double y) {
        this.affine.set(this.affine.get(0, 2) - x, 0, 2);
        this.affine.set(this.affine.get(1, 2) - y, 1, 2);
        this.affine.scale(s);
        this.affine.set(this.affine.get(0, 2) + x, 0, 2);
        this.affine.set(this.affine.get(1, 2) + y, 1, 2);
    }

    private void rotate(double d) {
        this.affine.set(this.affine.get(0, 2) - (double)this.centerX, 0, 2);
        this.affine.set(this.affine.get(1, 2) - (double)this.centerY, 1, 2);
        this.affine.rotate(d);
        this.affine.set(this.affine.get(0, 2) + (double)this.centerX, 0, 2);
        this.affine.set(this.affine.get(1, 2) + (double)this.centerY, 1, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        AffineTransform2D affineTransform2D = this.affine;
        synchronized (affineTransform2D) {
            int modifiers = e.getModifiersEx();
            double v = TransformEventHandler2D.keyModfiedSpeed(modifiers);
            int s = e.getWheelRotation();
            double dScale = 1.0 + 0.05 * v;
            if (s > 0) {
                this.scale(1.0 / dScale, e.getX(), e.getY());
            } else {
                this.scale(dScale, e.getX(), e.getY());
            }
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        AffineTransform2D affineTransform2D = this.affine;
        synchronized (affineTransform2D) {
            double v = TransformEventHandler2D.keyModfiedSpeed(e.getModifiersEx());
            if (e.getKeyCode() == 37) {
                this.rotate(Math.PI / 180 * v);
                this.update();
            } else if (e.getKeyCode() == 39) {
                this.rotate(Math.PI / 180 * -v);
                this.update();
            }
            if (e.getKeyCode() == 38) {
                double dScale = 1.0 + 0.1 * v;
                this.scale(dScale, this.centerX, this.centerY);
                this.update();
            } else if (e.getKeyCode() == 40) {
                double dScale = 1.0 + 0.1 * v;
                this.scale(1.0 / dScale, this.centerX, this.centerY);
                this.update();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

