/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui.overlay;

import java.awt.Graphics;
import java.awt.Graphics2D;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.ui.OverlayRenderer;
import net.imglib2.ui.TransformListener;
import net.imglib2.ui.overlay.BoxOverlay;
import net.imglib2.util.Intervals;

public class BoxOverlayRenderer
implements OverlayRenderer,
TransformListener<AffineTransform3D> {
    protected final BoxOverlay box = new BoxOverlay();
    protected Interval boxInterval = Intervals.createMinSize(10L, 10L, 80L, 60L);
    protected Interval virtualScreenInterval;
    protected final AffineTransform3D viewerTransform;
    protected final AffineTransform3D sourceTransform;
    protected final AffineTransform3D sourceToScreen;
    protected Interval sourceInterval;

    public BoxOverlayRenderer() {
        this(800, 600);
    }

    public BoxOverlayRenderer(int screenWidth, int screenHeight) {
        this.virtualScreenInterval = Intervals.createMinSize(0L, 0L, screenWidth, screenHeight);
        this.viewerTransform = new AffineTransform3D();
        this.sourceTransform = new AffineTransform3D();
        this.sourceToScreen = new AffineTransform3D();
        this.sourceInterval = Intervals.createMinSize(0L, 0L, 0L, 1L, 1L, 1L);
    }

    public synchronized void setBoxInterval(Interval interval) {
        this.boxInterval = interval;
    }

    public synchronized void setSource(Interval sourceInterval, AffineTransform3D sourceTransform) {
        this.sourceInterval = new FinalInterval(sourceInterval);
        this.sourceTransform.set(sourceTransform);
    }

    @Override
    public synchronized void transformChanged(AffineTransform3D transform) {
        this.viewerTransform.set(transform);
    }

    @Override
    public synchronized void drawOverlays(Graphics g) {
        this.sourceToScreen.set(this.viewerTransform);
        this.sourceToScreen.concatenate(this.sourceTransform);
        this.box.paint((Graphics2D)g, this.sourceToScreen, this.sourceInterval, this.virtualScreenInterval, this.boxInterval);
    }

    @Override
    public synchronized void setCanvasSize(int width, int height) {
        this.virtualScreenInterval = Intervals.createMinSize(0L, 0L, width, height);
    }
}

