/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui.util;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import net.imglib2.display.screenimage.awt.ARGBScreenImage;

public class GuiUtil {
    public static final ColorModel ARGB_COLOR_MODEL = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    public static final ColorModel RGB_COLOR_MODEL = new DirectColorModel(24, 0xFF0000, 65280, 255);

    public static final GraphicsConfiguration getSuitableGraphicsConfiguration(ColorModel colorModel) {
        int transparency;
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsConfiguration defaultGc = device.getDefaultConfiguration();
        if (defaultGc.getColorModel(transparency = colorModel.getTransparency()).equals(colorModel)) {
            return defaultGc;
        }
        for (GraphicsConfiguration gc : device.getConfigurations()) {
            if (!gc.getColorModel(transparency).equals(colorModel)) continue;
            return gc;
        }
        return defaultGc;
    }

    public static final BufferedImage getBufferedImage(ARGBScreenImage screenImage, boolean discardAlpha) {
        BufferedImage si = screenImage.image();
        if (discardAlpha && si.getTransparency() != 1) {
            SampleModel sampleModel = RGB_COLOR_MODEL.createCompatibleWritableRaster(1, 1).getSampleModel().createCompatibleSampleModel(si.getWidth(), si.getHeight());
            DataBuffer dataBuffer = si.getRaster().getDataBuffer();
            WritableRaster rgbRaster = Raster.createWritableRaster(sampleModel, dataBuffer, null);
            return new BufferedImage(RGB_COLOR_MODEL, rgbRaster, false, null);
        }
        return si;
    }

    public static final BufferedImage getBufferedImage(ARGBScreenImage screenImage) {
        return GuiUtil.getBufferedImage(screenImage, true);
    }
}

