/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.imglib2icy;

import icy.gui.dialog.MessageDialog;
import icy.sequence.Sequence;
import java.util.List;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.tinevez.imglib2icy.ImgLib2IcyFunctions;
import plugins.tinevez.imglib2icy.ImgLib2IcySplitSequenceAdapter;
import plugins.tinevez.imglib2icy.VirtualSequence;

public class ImgLib2SequenceSplitter
extends EzPlug {
    private final EzVarBoolean splitC = new EzVarBoolean("Split C", true);
    private final EzVarBoolean splitZ = new EzVarBoolean("Split Z", false);
    private final EzVarBoolean splitT = new EzVarBoolean("Split T", false);

    protected void initialize() {
        this.addEzComponent((EzComponent)this.splitC);
        this.addEzComponent((EzComponent)this.splitZ);
        this.addEzComponent((EzComponent)this.splitT);
    }

    protected void execute() {
        Sequence sequence = this.getActiveSequence();
        if (null == sequence) {
            MessageDialog.showDialog((String)"Please open a sequence first.", (int)0);
            return;
        }
        List<Img<UnsignedByteType>> imgs = ImgLib2IcySplitSequenceAdapter.wrapUnsignedByte(sequence, (Boolean)this.splitC.getValue(true), (Boolean)this.splitZ.getValue(true), (Boolean)this.splitT.getValue(true));
        VirtualSequence.DimensionArrangement dim = ImgLib2IcySplitSequenceAdapter.getDimensionArrangement(sequence, (Boolean)this.splitC.getValue(true), (Boolean)this.splitZ.getValue(true), (Boolean)this.splitT.getValue(true));
        for (Img<UnsignedByteType> img : imgs) {
            Sequence seq = ImgLib2IcyFunctions.wrap(img, dim);
            this.addSequence(seq);
        }
    }

    public void clean() {
    }
}

