/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.linalg.eigen;

import net.imglib2.algorithm.linalg.eigen.EigenValues;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.composite.Composite;

public class EigenValues2DSymmetric<T extends RealType<T>, U extends ComplexType<U>>
implements EigenValues<T, U> {
    @Override
    public void compute(Composite<T> tensor, Composite<U> evs) {
        double x11 = ((RealType)tensor.get(0L)).getRealDouble();
        double x12 = ((RealType)tensor.get(1L)).getRealDouble();
        double x22 = ((RealType)tensor.get(2L)).getRealDouble();
        double sum = x11 + x22;
        double diff = x11 - x22;
        double sqrt = Math.sqrt(4.0 * x12 * x12 + diff * diff);
        ((ComplexType)evs.get(0L)).setReal(0.5 * (sum + sqrt));
        ((ComplexType)evs.get(1L)).setReal(0.5 * (sum - sqrt));
    }
}

