/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import net.imglib2.Cursor;
import net.imglib2.algorithm.region.localneighborhood.AbstractNeighborhood;
import net.imglib2.outofbounds.Bounded;
import net.imglib2.outofbounds.OutOfBounds;

public abstract class AbstractNeighborhoodCursor<T>
implements Cursor<T>,
Bounded {
    protected AbstractNeighborhood<T> neighborhood;
    protected final OutOfBounds<T> ra;

    public AbstractNeighborhoodCursor(AbstractNeighborhood<T> neighborhood) {
        this.neighborhood = neighborhood;
        this.ra = neighborhood.extendedSource.randomAccess();
    }

    @Override
    public void localize(float[] position) {
        this.ra.localize(position);
    }

    @Override
    public void localize(double[] position) {
        this.ra.localize(position);
    }

    @Override
    public float getFloatPosition(int d) {
        return this.ra.getFloatPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.ra.getDoublePosition(d);
    }

    @Override
    public int numDimensions() {
        return this.ra.numDimensions();
    }

    @Override
    public T get() {
        return this.ra.get();
    }

    @Override
    public void jumpFwd(long steps) {
        int i = 0;
        while ((long)i < steps) {
            this.fwd();
            ++i;
        }
    }

    @Override
    public T next() {
        this.fwd();
        return this.ra.get();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not implemented for " + this.getClass().getCanonicalName());
    }

    @Override
    public void localize(int[] position) {
        this.ra.localize(position);
    }

    @Override
    public void localize(long[] position) {
        this.ra.localize(position);
    }

    @Override
    public int getIntPosition(int d) {
        return this.ra.getIntPosition(d);
    }

    @Override
    public long getLongPosition(int d) {
        return this.ra.getLongPosition(d);
    }

    @Override
    public boolean isOutOfBounds() {
        return this.ra.isOutOfBounds();
    }
}

