/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.CacheRemover;
import net.imglib2.cache.PausableQueue;

public class IoSync<K, V, D>
implements CacheLoader<K, V>,
CacheRemover<K, V, D> {
    final CacheLoader<K, V> loader;
    final CacheRemover<K, V, D> saver;
    final ConcurrentHashMap<K, Entry> map;
    final PausableQueue<Runnable> queue;
    private final List<Writer> writers = new ArrayList<Writer>();
    private final Lock invalidateLock = new ReentrantLock();
    static final AtomicInteger ioSyncNumber = new AtomicInteger(1);

    public <T extends CacheLoader<K, V> & CacheRemover<K, V, D>> IoSync(T io) {
        this(io, io, 1, 10);
    }

    public <T extends CacheLoader<K, V> & CacheRemover<K, V, D>> IoSync(T io, int numThreads, int maxQueueSize) {
        this(io, io, numThreads, maxQueueSize);
    }

    public IoSync(CacheLoader<K, V> loader, CacheRemover<K, V, D> saver, int numThreads, int maxQueueSize) {
        this.saver = saver;
        this.loader = loader;
        this.map = new ConcurrentHashMap();
        this.queue = new PausableQueue(maxQueueSize, numThreads, false);
        String[] names = IoSync.createThreadNames(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            Writer t = new Writer(names[i]);
            t.setDaemon(true);
            t.start();
            this.writers.add(t);
        }
    }

    public void shutdown() {
        for (Writer w : this.writers) {
            w.shutdown();
        }
    }

    @Override
    public void onRemoval(K key, D valueData) {
        this.map.compute(key, (k, oldEntry) -> {
            if (oldEntry == null) {
                return new Entry(valueData, 0);
            }
            assert (oldEntry.valueData == valueData);
            oldEntry.generation.incrementAndGet();
            return oldEntry;
        });
        try {
            this.queue.put(new OnRemovalTask(key));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CompletableFuture<Void> persist(K key, D valueData) {
        CompletableFuture trigger = new CompletableFuture();
        CompletionStage result = trigger.thenCompose(nul -> this.saver.persist(key, valueData));
        try {
            this.queue.put(() -> trigger.complete(null));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    @Override
    public D extract(V value) {
        return this.saver.extract(value);
    }

    @Override
    public V reconstruct(K key, D valueData) {
        return this.saver.reconstruct(key, valueData);
    }

    @Override
    public V get(K key) throws Exception {
        Entry entry = this.map.get(key);
        if (entry != null) {
            return this.reconstruct(key, entry.valueData);
        }
        return this.loader.get(key);
    }

    @Override
    public void invalidate(K key) {
        this.invalidateLock.lock();
        try {
            this.queue.pause();
            this.queue.removeIf(r -> ((OnRemovalTask)r).key.equals(key));
            this.map.remove(key);
            this.saver.invalidate(key);
            this.queue.resume();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.invalidateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateIf(long parallelismThreshold, Predicate<K> condition) {
        this.invalidateLock.lock();
        try {
            this.queue.pause();
            this.queue.removeIf(r -> condition.test(((OnRemovalTask)r).key));
            this.map.keySet().removeIf(condition);
            this.saver.invalidateIf(parallelismThreshold, condition);
            this.queue.resume();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.invalidateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAll(long parallelismThreshold) {
        this.invalidateLock.lock();
        try {
            this.queue.pause();
            this.queue.clear();
            this.map.clear();
            this.saver.invalidateAll(parallelismThreshold);
            this.queue.resume();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.invalidateLock.unlock();
        }
    }

    static String[] createThreadNames(int numThreads) {
        String threadNameFormat = String.format("io-sync-%d-writer-%%d", ioSyncNumber.getAndIncrement());
        String[] names = new String[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            names[i] = String.format(threadNameFormat, i + 1);
        }
        return names;
    }

    class Writer
    extends Thread {
        private volatile boolean shutdown;

        public Writer(String name) {
            super(name);
            this.shutdown = false;
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                try {
                    Runnable r = IoSync.this.queue.take();
                    if (this.shutdown) continue;
                    r.run();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class OnRemovalTask
    implements Runnable {
        private final K key;

        OnRemovalTask(K key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Entry entry = IoSync.this.map.get(this.key);
            if (entry != null) {
                Entry entry2 = entry;
                synchronized (entry2) {
                    int writeGeneration = entry.generation.get();
                    Object valueData = entry.valueData;
                    IoSync.this.saver.onRemoval(this.key, valueData);
                    IoSync.this.map.remove(this.key, new Entry(valueData, writeGeneration));
                }
            }
        }
    }

    class Entry {
        final D valueData;
        final AtomicInteger generation;

        Entry(D valueData, int generation) {
            this.valueData = valueData;
            this.generation = new AtomicInteger(generation);
        }

        public int hashCode() {
            return this.valueData.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                Entry other = (Entry)obj;
                return other.valueData.equals(this.valueData) && other.generation.get() == this.generation.get();
            }
            return false;
        }
    }
}

