/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.RealTransform;

public class InterpolatedRealTransform
implements RealTransform {
    private final RealTransform a;
    private final RealTransform b;
    private double lambda;
    private final double[] targetPositionA;
    private final double[] targetPositionB;
    private final RealPoint targetPositionableA;
    private final RealPoint targetPositionableB;

    public InterpolatedRealTransform(RealTransform a, RealTransform b, double lambda) {
        assert (a.numSourceDimensions() == b.numSourceDimensions() && a.numTargetDimensions() == b.numTargetDimensions()) : "Number of dimensions do not match.";
        this.a = a;
        this.b = b;
        this.lambda = lambda;
        this.targetPositionA = new double[a.numTargetDimensions()];
        this.targetPositionB = new double[b.numTargetDimensions()];
        this.targetPositionableA = RealPoint.wrap(this.targetPositionA);
        this.targetPositionableB = RealPoint.wrap(this.targetPositionB);
    }

    @Override
    public int numSourceDimensions() {
        return this.a.numSourceDimensions();
    }

    @Override
    public int numTargetDimensions() {
        return this.targetPositionA.length;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
    }

    @Override
    public void apply(double[] source, double[] target) {
        this.a.apply(source, this.targetPositionA);
        this.b.apply(source, this.targetPositionB);
        for (int d = 0; d < this.targetPositionA.length; ++d) {
            target[d] = (this.targetPositionA[d] - this.targetPositionB[d]) * this.lambda + this.targetPositionB[d];
        }
    }

    @Override
    public void apply(float[] source, float[] target) {
        int d;
        for (d = 0; d < this.targetPositionA.length; ++d) {
            this.targetPositionA[d] = source[d];
            this.targetPositionB[d] = source[d];
        }
        this.a.apply(this.targetPositionA, this.targetPositionA);
        this.b.apply(this.targetPositionB, this.targetPositionB);
        for (d = 0; d < this.targetPositionA.length; ++d) {
            target[d] = (float)((this.targetPositionA[d] - this.targetPositionB[d]) * this.lambda + this.targetPositionB[d]);
        }
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        this.a.apply(source, this.targetPositionableA);
        this.b.apply(source, this.targetPositionableB);
        for (int d = 0; d < this.numTargetDimensions(); ++d) {
            target.setPosition((this.targetPositionA[d] - this.targetPositionB[d]) * this.lambda + this.targetPositionB[d], d);
        }
    }

    @Override
    public InterpolatedRealTransform copy() {
        return new InterpolatedRealTransform(this.a.copy(), this.b.copy(), this.lambda);
    }
}

