/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.labeling;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.imglib2.roi.labeling.LabelingMapping;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.IntegerType;

public class LabelingType<T>
implements Type<LabelingType<T>>,
Set<T> {
    protected final ModCount generation;
    protected final LabelingMapping<T> mapping;
    private final LabelingMapping.AddRemoveCacheMap addRemoveCache;
    protected IntegerType<?> type;

    protected LabelingType(IntegerType<?> type, LabelingMapping<T> mapping, ModCount modCount) {
        this.type = type;
        this.mapping = mapping;
        this.addRemoveCache = mapping.createAddRemoveCacheMap();
        this.generation = modCount;
    }

    void setType(IntegerType<?> type) {
        this.type = type;
    }

    @Override
    public void set(LabelingType<T> c) {
        if (c.mapping == this.mapping) {
            this.type.setInteger(c.type.getInteger());
        } else {
            this.type.setInteger(this.mapping.intern(c).index);
        }
        this.generation.modCount++;
    }

    @Override
    public LabelingType<T> createVariable() {
        IntegerType newtype = (IntegerType)this.type.createVariable();
        LabelingMapping<T> newmapping = this.mapping.newInstance();
        LabelingType<T> t = new LabelingType<T>(newtype, newmapping, new ModCount());
        return t;
    }

    @Override
    public LabelingType<T> copy() {
        IntegerType newtype = (IntegerType)this.type.copy();
        LabelingType<T> t = new LabelingType<T>(newtype, this.mapping, new ModCount());
        return t;
    }

    public String toString() {
        return this.mapping.setAtIndex(this.type.getInteger()).toString();
    }

    public int getGeneration() {
        return this.generation.modCount;
    }

    public LabelingMapping<T> getMapping() {
        return this.mapping;
    }

    public IntegerType<?> getIndex() {
        return this.type;
    }

    @Override
    public boolean add(T label) {
        int index = this.type.getInteger();
        int newindex = this.addRemoveCache.addLabelToSetAtIndex(label, index);
        if (newindex == index) {
            return false;
        }
        this.type.setInteger(newindex);
        this.generation.modCount++;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int index;
        int newindex = index = this.type.getInteger();
        for (T label : c) {
            newindex = this.addRemoveCache.addLabelToSetAtIndex(label, newindex);
        }
        if (newindex == index) {
            return false;
        }
        this.type.setInteger(newindex);
        this.generation.modCount++;
        return true;
    }

    @Override
    public void clear() {
        int newindex = this.mapping.emptySet().index;
        int index = this.type.getInteger();
        if (newindex != index) {
            this.type.setInteger(newindex);
            this.generation.modCount++;
        }
    }

    @Override
    public boolean contains(Object label) {
        return this.mapping.setAtIndex(this.type.getInteger()).contains(label);
    }

    @Override
    public boolean containsAll(Collection<?> labels) {
        return this.mapping.setAtIndex(this.type.getInteger()).containsAll(labels);
    }

    @Override
    public boolean isEmpty() {
        return this.mapping.setAtIndex(this.type.getInteger()).isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.mapping.setAtIndex(this.type.getInteger()).iterator();
    }

    @Override
    public boolean remove(Object label) {
        int index = this.type.getInteger();
        int newindex = this.addRemoveCache.removeLabelFromSetAtIndex(label, index);
        if (newindex == index) {
            return false;
        }
        this.type.setInteger(newindex);
        this.generation.modCount++;
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int index;
        int newindex = index = this.type.getInteger();
        for (Object label : c) {
            newindex = this.addRemoveCache.removeLabelFromSetAtIndex(label, newindex);
        }
        if (newindex == index) {
            return false;
        }
        this.type.setInteger(newindex);
        this.generation.modCount++;
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.mapping.setAtIndex(this.type.getInteger()).size();
    }

    @Override
    public Object[] toArray() {
        return this.mapping.setAtIndex(this.type.getInteger()).toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.mapping.setAtIndex(this.type.getInteger()).toArray(a);
    }

    @Override
    public int hashCode() {
        return this.mapping.setAtIndex(this.type.getInteger()).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LabelingType) {
            LabelingType c = (LabelingType)obj;
            if (c.mapping == this.mapping) {
                return c.type.getInteger() == this.type.getInteger();
            }
        }
        return this.mapping.setAtIndex(this.type.getInteger()).equals(obj);
    }

    public <L> LabelingType<L> createVariable(Class<? extends L> newType) {
        return new LabelingType((IntegerType)this.type.createVariable(), new LabelingMapping(this.type), new ModCount());
    }

    @Override
    public boolean valueEquals(LabelingType<T> t) {
        return this.equals(t);
    }

    protected static class ModCount {
        private int modCount = 0;

        protected ModCount() {
        }
    }
}

