/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import net.imglib2.ui.InteractiveDisplayCanvas;
import net.imglib2.ui.OverlayRenderer;
import net.imglib2.ui.TransformEventHandler;
import net.imglib2.ui.TransformEventHandlerFactory;
import net.imglib2.ui.TransformListener;

public class InteractiveDisplayCanvasComponent<A>
extends JComponent
implements InteractiveDisplayCanvas<A> {
    private static final long serialVersionUID = -5546719724928785878L;
    protected TransformEventHandler<A> handler;
    protected final CopyOnWriteArrayList<TransformListener<A>> transformListeners;
    protected final CopyOnWriteArrayList<OverlayRenderer> overlayRenderers;

    public InteractiveDisplayCanvasComponent(int width, int height, TransformEventHandlerFactory<A> transformEventHandlerFactory) {
        this.setPreferredSize(new Dimension(width, height));
        this.setFocusable(true);
        this.overlayRenderers = new CopyOnWriteArrayList();
        this.transformListeners = new CopyOnWriteArrayList();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = InteractiveDisplayCanvasComponent.this.getWidth();
                int h = InteractiveDisplayCanvasComponent.this.getHeight();
                if (InteractiveDisplayCanvasComponent.this.handler != null) {
                    InteractiveDisplayCanvasComponent.this.handler.setCanvasSize(w, h, true);
                }
                for (OverlayRenderer or : InteractiveDisplayCanvasComponent.this.overlayRenderers) {
                    or.setCanvasSize(w, h);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                InteractiveDisplayCanvasComponent.this.requestFocusInWindow();
            }
        });
        this.handler = transformEventHandlerFactory.create(this);
        this.handler.setCanvasSize(width, height, false);
        this.addHandler(this.handler);
    }

    @Override
    public void addOverlayRenderer(OverlayRenderer renderer) {
        this.overlayRenderers.add(renderer);
        renderer.setCanvasSize(this.getWidth(), this.getHeight());
    }

    @Override
    public void removeOverlayRenderer(OverlayRenderer renderer) {
        this.overlayRenderers.remove(renderer);
    }

    @Override
    public void addTransformListener(TransformListener<A> listener) {
        this.transformListeners.add(listener);
    }

    @Override
    public void removeTransformListener(TransformListener<A> listener) {
        this.transformListeners.remove(listener);
    }

    @Override
    public void addHandler(Object h) {
        if (KeyListener.class.isInstance(h)) {
            this.addKeyListener((KeyListener)h);
        }
        if (MouseMotionListener.class.isInstance(h)) {
            this.addMouseMotionListener((MouseMotionListener)h);
        }
        if (MouseListener.class.isInstance(h)) {
            this.addMouseListener((MouseListener)h);
        }
        if (MouseWheelListener.class.isInstance(h)) {
            this.addMouseWheelListener((MouseWheelListener)h);
        }
        if (FocusListener.class.isInstance(h)) {
            this.addFocusListener((FocusListener)h);
        }
    }

    @Override
    public void removeHandler(Object h) {
        if (KeyListener.class.isInstance(h)) {
            this.removeKeyListener((KeyListener)h);
        }
        if (MouseMotionListener.class.isInstance(h)) {
            this.removeMouseMotionListener((MouseMotionListener)h);
        }
        if (MouseListener.class.isInstance(h)) {
            this.removeMouseListener((MouseListener)h);
        }
        if (MouseWheelListener.class.isInstance(h)) {
            this.removeMouseWheelListener((MouseWheelListener)h);
        }
        if (FocusListener.class.isInstance(h)) {
            this.removeFocusListener((FocusListener)h);
        }
    }

    @Override
    public TransformEventHandler<A> getTransformEventHandler() {
        return this.handler;
    }

    @Override
    public synchronized void setTransformEventHandler(TransformEventHandler<A> transformEventHandler) {
        this.removeHandler(this.handler);
        this.handler = transformEventHandler;
        this.handler.setCanvasSize(this.getWidth(), this.getHeight(), false);
        this.addHandler(this.handler);
    }

    @Override
    public void paintComponent(Graphics g) {
        for (OverlayRenderer or : this.overlayRenderers) {
            or.drawOverlays(g);
        }
    }

    @Override
    public void transformChanged(A transform) {
        for (TransformListener<A> l : this.transformListeners) {
            l.transformChanged(transform);
        }
    }
}

