/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui.util;

import net.imglib2.RandomAccessible;
import net.imglib2.RealRandomAccessible;
import net.imglib2.converter.Converter;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorARGBFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.ui.RenderSource;
import net.imglib2.view.Views;

public class InterpolatingSource<T extends NumericType<T>, A>
implements RenderSource<T, A> {
    protected final A sourceTransform;
    protected final Converter<? super T, ARGBType> converter;
    protected final RealRandomAccessible<T>[] sourceInterpolants;
    private int interpolation;

    public InterpolatingSource(RandomAccessible<T> source, A sourceTransform, Converter<? super T, ARGBType> converter) {
        InterpolatorFactory<ARGBType, RandomAccessible<ARGBType>> nLinearInterpolatorFactory = ARGBType.class.isInstance(source.randomAccess().get()) ? new NLinearInterpolatorARGBFactory() : new NLinearInterpolatorFactory();
        this.sourceTransform = sourceTransform;
        this.converter = converter;
        this.sourceInterpolants = new RealRandomAccessible[]{Views.interpolate(source, new NearestNeighborInterpolatorFactory()), Views.interpolate(source, nLinearInterpolatorFactory)};
        this.interpolation = 0;
    }

    @Override
    public RealRandomAccessible<T> getInterpolatedSource() {
        return this.sourceInterpolants[this.interpolation];
    }

    @Override
    public A getSourceTransform() {
        return this.sourceTransform;
    }

    @Override
    public Converter<? super T, ARGBType> getConverter() {
        return this.converter;
    }

    public void switchInterpolation() {
        this.interpolation = (this.interpolation + 1) % this.sourceInterpolants.length;
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(int interpolation) {
        this.interpolation = interpolation % this.sourceInterpolants.length;
    }
}

