/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.util;

public class LinAlgHelpers {
    public static int rows(double[] a) {
        return a.length;
    }

    public static int rows(double[][] A) {
        return A.length;
    }

    public static int cols(double[][] A) {
        return A[0].length;
    }

    public static double squareLength(double[] a) {
        int rows = LinAlgHelpers.rows(a);
        double squ_len = 0.0;
        for (int i = 0; i < rows; ++i) {
            squ_len += a[i] * a[i];
        }
        return squ_len;
    }

    public static double length(double[] a) {
        return Math.sqrt(LinAlgHelpers.squareLength(a));
    }

    public static double squareDistance(double[] a, double[] b) {
        assert (LinAlgHelpers.rows(a) == LinAlgHelpers.rows(b));
        int rows = LinAlgHelpers.rows(a);
        double squ_len = 0.0;
        for (int i = 0; i < rows; ++i) {
            squ_len += (a[i] - b[i]) * (a[i] - b[i]);
        }
        return squ_len;
    }

    public static double distance(double[] a, double[] b) {
        return Math.sqrt(LinAlgHelpers.squareDistance(a, b));
    }

    public static void lerp(double[] a, double[] b, double t, double[] c) {
        assert (LinAlgHelpers.rows(a) == LinAlgHelpers.rows(b));
        assert (LinAlgHelpers.rows(a) == LinAlgHelpers.rows(c));
        int rows = LinAlgHelpers.rows(a);
        for (int i = 0; i < rows; ++i) {
            c[i] = (1.0 - t) * a[i] + t * b[i];
        }
    }

    public static void scale(double[] a, double b, double[] c) {
        assert (LinAlgHelpers.rows(a) == LinAlgHelpers.rows(c));
        int rows = LinAlgHelpers.rows(a);
        for (int i = 0; i < rows; ++i) {
            c[i] = a[i] * b;
        }
    }

    public static void scale(double[][] A, double b, double[][] C2) {
        assert (LinAlgHelpers.rows(A) == LinAlgHelpers.rows(C2) && LinAlgHelpers.cols(A) == LinAlgHelpers.cols(C2));
        int rows = LinAlgHelpers.rows(A);
        int cols = LinAlgHelpers.cols(A);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                C2[i][j] = A[i][j] * b;
            }
        }
    }

    public static void copy(double[][] A, double[][] C2) {
        assert (LinAlgHelpers.rows(A) == LinAlgHelpers.rows(C2) && LinAlgHelpers.cols(A) == LinAlgHelpers.cols(C2));
        int rows = LinAlgHelpers.rows(A);
        int cols = LinAlgHelpers.cols(A);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                C2[i][j] = A[i][j];
            }
        }
    }

    public static void subtract(double[] a, double[] b, double[] c) {
        assert (LinAlgHelpers.rows(a) == LinAlgHelpers.rows(b) && LinAlgHelpers.rows(a) == LinAlgHelpers.rows(c));
        int rows = LinAlgHelpers.rows(a);
        for (int i = 0; i < rows; ++i) {
            c[i] = a[i] - b[i];
        }
    }

    public static void add(double[] a, double[] b, double[] c) {
        assert (LinAlgHelpers.rows(a) == LinAlgHelpers.rows(b) && LinAlgHelpers.rows(a) == LinAlgHelpers.rows(c));
        int rows = LinAlgHelpers.rows(a);
        for (int i = 0; i < rows; ++i) {
            c[i] = a[i] + b[i];
        }
    }

    public static void mult(double[][] A, double[] b, double[] c) {
        assert (LinAlgHelpers.cols(A) == LinAlgHelpers.rows(b));
        assert (LinAlgHelpers.rows(c) == LinAlgHelpers.rows(A));
        int rows = LinAlgHelpers.rows(c);
        int Acols = LinAlgHelpers.cols(A);
        for (int i = 0; i < rows; ++i) {
            double sum = 0.0;
            for (int k = 0; k < Acols; ++k) {
                sum += A[i][k] * b[k];
            }
            c[i] = sum;
        }
    }

    public static void multT(double[][] A, double[] b, double[] c) {
        assert (LinAlgHelpers.rows(A) == LinAlgHelpers.rows(b));
        assert (LinAlgHelpers.rows(c) == LinAlgHelpers.cols(A));
        int rows = LinAlgHelpers.rows(c);
        int Arows = LinAlgHelpers.rows(A);
        for (int i = 0; i < rows; ++i) {
            double sum = 0.0;
            for (int k = 0; k < Arows; ++k) {
                sum += A[k][i] * b[k];
            }
            c[i] = sum;
        }
    }

    public static void mult(double[][] A, double[][] B, double[][] C2) {
        assert (LinAlgHelpers.cols(A) == LinAlgHelpers.rows(B));
        assert (LinAlgHelpers.rows(C2) == LinAlgHelpers.rows(A) && LinAlgHelpers.cols(C2) == LinAlgHelpers.cols(B));
        int cols = LinAlgHelpers.cols(C2);
        int rows = LinAlgHelpers.rows(C2);
        int Acols = LinAlgHelpers.cols(A);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                double sum = 0.0;
                for (int k = 0; k < Acols; ++k) {
                    sum += A[i][k] * B[k][j];
                }
                C2[i][j] = sum;
            }
        }
    }

    public static void multABT(double[][] A, double[][] B, double[][] C2) {
        assert (LinAlgHelpers.cols(A) == LinAlgHelpers.cols(B));
        assert (LinAlgHelpers.rows(C2) == LinAlgHelpers.rows(A) && LinAlgHelpers.cols(C2) == LinAlgHelpers.rows(B));
        int cols = LinAlgHelpers.cols(C2);
        int rows = LinAlgHelpers.rows(C2);
        int Acols = LinAlgHelpers.cols(A);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                double sum = 0.0;
                for (int k = 0; k < Acols; ++k) {
                    sum += A[i][k] * B[j][k];
                }
                C2[i][j] = sum;
            }
        }
    }

    public static void multATB(double[][] A, double[][] B, double[][] C2) {
        assert (LinAlgHelpers.rows(A) == LinAlgHelpers.rows(B));
        assert (LinAlgHelpers.rows(C2) == LinAlgHelpers.cols(A) && LinAlgHelpers.cols(C2) == LinAlgHelpers.cols(B));
        int cols = LinAlgHelpers.cols(C2);
        int rows = LinAlgHelpers.rows(C2);
        int Arows = LinAlgHelpers.rows(A);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                double sum = 0.0;
                for (int k = 0; k < Arows; ++k) {
                    sum += A[k][i] * B[k][j];
                }
                C2[i][j] = sum;
            }
        }
    }

    public static void add(double[][] A, double[][] B, double[][] C2) {
        assert (LinAlgHelpers.rows(A) == LinAlgHelpers.rows(B) && LinAlgHelpers.rows(A) == LinAlgHelpers.rows(C2));
        assert (LinAlgHelpers.cols(A) == LinAlgHelpers.cols(B) && LinAlgHelpers.cols(A) == LinAlgHelpers.cols(C2));
        int rows = LinAlgHelpers.rows(A);
        int cols = LinAlgHelpers.cols(A);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                C2[i][j] = A[i][j] + B[i][j];
            }
        }
    }

    public static void getCol(int c, double[][] A, double[] b) {
        assert (LinAlgHelpers.rows(A) == LinAlgHelpers.rows(b));
        assert (LinAlgHelpers.cols(A) > c && c >= 0);
        int rows = LinAlgHelpers.rows(A);
        for (int i = 0; i < rows; ++i) {
            b[i] = A[i][c];
        }
    }

    public static void setCol(int c, double[] a, double[][] B) {
        assert (LinAlgHelpers.rows(B) == LinAlgHelpers.rows(a));
        assert (LinAlgHelpers.cols(B) > c && c >= 0);
        int rows = LinAlgHelpers.rows(B);
        for (int i = 0; i < rows; ++i) {
            B[i][c] = a[i];
        }
    }

    public static void getRow(int r, double[][] A, double[] b) {
        assert (LinAlgHelpers.cols(A) == LinAlgHelpers.rows(b));
        assert (LinAlgHelpers.rows(A) > r && r >= 0);
        int cols = LinAlgHelpers.cols(A);
        for (int i = 0; i < cols; ++i) {
            b[i] = A[r][i];
        }
    }

    public static void setRow(int r, double[] a, double[][] B) {
        assert (LinAlgHelpers.cols(B) == LinAlgHelpers.rows(a));
        assert (LinAlgHelpers.rows(B) > r && r >= 0);
        int cols = LinAlgHelpers.cols(B);
        for (int i = 0; i < cols; ++i) {
            B[r][i] = a[i];
        }
    }

    public static void normalize(double[] a) {
        int rows = LinAlgHelpers.rows(a);
        double len = LinAlgHelpers.length(a);
        int i = 0;
        while (i < rows) {
            int n = i++;
            a[n] = a[n] / len;
        }
    }

    public static double dot(double[] a, double[] b) {
        assert (LinAlgHelpers.rows(a) == LinAlgHelpers.rows(b));
        int rows = LinAlgHelpers.rows(a);
        double sum = 0.0;
        for (int i = 0; i < rows; ++i) {
            sum += a[i] * b[i];
        }
        return sum;
    }

    public static void cross(double[] a, double[] b, double[] c) {
        c[0] = a[1] * b[2] - a[2] * b[1];
        c[1] = a[2] * b[0] - a[0] * b[2];
        c[2] = a[0] * b[1] - a[1] * b[0];
    }

    public static void outer(double[] a, double[] b, double[][] C2) {
        assert (LinAlgHelpers.rows(a) == LinAlgHelpers.rows(C2) && LinAlgHelpers.rows(b) == LinAlgHelpers.cols(C2));
        int rows = LinAlgHelpers.rows(a);
        int cols = LinAlgHelpers.rows(b);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                C2[i][j] = a[i] * b[j];
            }
        }
    }

    public static double angleFromR(double[][] R) {
        assert (LinAlgHelpers.cols(R) >= 3);
        assert (LinAlgHelpers.rows(R) >= 3);
        double tr = R[0][0] + R[1][1] + R[2][2];
        double theta = Math.acos((tr - 1.0) / 2.0);
        return theta;
    }

    public static void axisFromR(double[][] R, double[] a) {
        assert (LinAlgHelpers.cols(R) >= 3);
        assert (LinAlgHelpers.rows(R) >= 3);
        assert (LinAlgHelpers.rows(a) >= 3);
        double s = 1.0 / (2.0 * Math.sin(LinAlgHelpers.angleFromR(R)));
        a[0] = s * (R[2][1] - R[1][2]);
        a[1] = s * (R[0][2] - R[2][0]);
        a[2] = s * (R[1][0] - R[0][1]);
    }

    public static void quaternionFromR(double[][] R, double[] q) {
        assert (LinAlgHelpers.cols(R) >= 3);
        assert (LinAlgHelpers.rows(R) >= 3);
        assert (LinAlgHelpers.rows(q) >= 4);
        double d0 = R[0][0];
        double d1 = R[1][1];
        double d2 = R[2][2];
        double rr = d0 + d1 + d2;
        if (rr > 0.0) {
            double s = 0.5 / Math.sqrt(1.0 + rr);
            q[1] = (R[2][1] - R[1][2]) * s;
            q[2] = (R[0][2] - R[2][0]) * s;
            q[3] = (R[1][0] - R[0][1]) * s;
            q[0] = 0.25 / s;
        } else if (d0 > d1 && d0 > d2) {
            double s2 = Math.sqrt(1.0 + d0 - d1 - d2);
            double s = 0.5 / s2;
            q[1] = 0.5 * s2;
            q[2] = (R[0][1] + R[1][0]) * s;
            q[3] = (R[2][0] + R[0][2]) * s;
            q[0] = (R[2][1] - R[1][2]) * s;
        } else if (d1 > d2) {
            double s2 = Math.sqrt(1.0 - d0 + d1 - d2);
            double s = 0.5 / s2;
            q[1] = (R[0][1] + R[1][0]) * s;
            q[2] = 0.5 * s2;
            q[3] = (R[1][2] + R[2][1]) * s;
            q[0] = (R[0][2] - R[2][0]) * s;
        } else {
            double s2 = Math.sqrt(1.0 - d0 - d1 + d2);
            double s = 0.5 / s2;
            q[1] = (R[2][0] + R[0][2]) * s;
            q[2] = (R[1][2] + R[2][1]) * s;
            q[3] = 0.5 * s2;
            q[0] = (R[1][0] - R[0][1]) * s;
        }
    }

    public static void quaternionToR(double[] q, double[][] R) {
        assert (LinAlgHelpers.rows(q) >= 4);
        assert (LinAlgHelpers.cols(R) >= 3);
        assert (LinAlgHelpers.rows(R) >= 3);
        double w = q[0];
        double x = q[1];
        double y = q[2];
        double z = q[3];
        R[0][0] = w * w + x * x - y * y - z * z;
        R[0][1] = 2.0 * (x * y - w * z);
        R[0][2] = 2.0 * (x * z + w * y);
        R[1][0] = 2.0 * (y * x + w * z);
        R[1][1] = w * w - x * x + y * y - z * z;
        R[1][2] = 2.0 * (y * z - w * x);
        R[2][0] = 2.0 * (z * x - w * y);
        R[2][1] = 2.0 * (z * y + w * x);
        R[2][2] = w * w - x * x - y * y + z * z;
    }

    public static void quaternionFromAngleAxis(double[] axis, double angle, double[] q) {
        assert (LinAlgHelpers.rows(axis) >= 3);
        assert (LinAlgHelpers.rows(q) >= 4);
        double s = Math.sin(0.5 * angle);
        q[0] = Math.cos(0.5 * angle);
        q[1] = s * axis[0];
        q[2] = s * axis[1];
        q[3] = s * axis[2];
    }

    public static void quaternionMultiply(double[] p, double[] q, double[] pq) {
        assert (LinAlgHelpers.rows(p) >= 4);
        assert (LinAlgHelpers.rows(q) >= 4);
        assert (LinAlgHelpers.rows(pq) >= 4);
        double pw = p[0];
        double px = p[1];
        double py = p[2];
        double pz = p[3];
        double qw = q[0];
        double qx = q[1];
        double qy = q[2];
        double qz = q[3];
        pq[0] = pw * qw - px * qx - py * qy - pz * qz;
        pq[1] = pw * qx + px * qw + py * qz - pz * qy;
        pq[2] = pw * qy + py * qw + pz * qx - px * qz;
        pq[3] = pw * qz + pz * qw + px * qy - py * qx;
    }

    public static void quaternionPower(double[] q, double a, double[] qa) {
        assert (LinAlgHelpers.rows(q) >= 4);
        assert (LinAlgHelpers.rows(qa) >= 4);
        double theta2 = Math.acos(q[0]);
        double s = Math.sin(a * theta2) / Math.sin(theta2);
        if (Double.isNaN(s)) {
            qa[0] = 1.0;
            qa[1] = 0.0;
            qa[2] = 0.0;
            qa[3] = 0.0;
        } else {
            qa[0] = Math.cos(a * theta2);
            qa[1] = s * q[1];
            qa[2] = s * q[2];
            qa[3] = s * q[3];
        }
    }

    public static void quaternionInvert(double[] p, double[] q) {
        assert (LinAlgHelpers.rows(p) >= 4);
        assert (LinAlgHelpers.rows(q) >= 4);
        q[0] = p[0];
        q[1] = -p[1];
        q[2] = -p[2];
        q[3] = -p[3];
    }

    public static void quaternionApply(double[] q, double[] p, double[] qp) {
        assert (LinAlgHelpers.rows(q) >= 4);
        assert (LinAlgHelpers.rows(p) >= 3);
        assert (LinAlgHelpers.rows(qp) >= 3);
        double w = q[0];
        double x = q[1];
        double y = q[2];
        double z = q[3];
        double q0 = -x * p[0] - y * p[1] - z * p[2];
        double q1 = w * p[0] + y * p[2] - z * p[1];
        double q2 = w * p[1] + z * p[0] - x * p[2];
        double q3 = w * p[2] + x * p[1] - y * p[0];
        qp[0] = -q0 * x + q1 * w - q2 * z + q3 * y;
        qp[1] = -q0 * y + q2 * w - q3 * x + q1 * z;
        qp[2] = -q0 * z + q3 * w - q1 * y + q2 * x;
    }

    public static final double det3x3(double[] a) {
        assert (a.length >= 9) : "Not enough coordinates.";
        return a[0] * a[4] * a[8] + a[3] * a[7] * a[2] + a[6] * a[1] * a[5] - a[2] * a[4] * a[6] - a[5] * a[7] * a[0] - a[8] * a[1] * a[3];
    }

    public static final double det3x3(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        return m00 * m11 * m22 + m10 * m21 * m02 + m20 * m01 * m12 - m02 * m11 * m20 - m12 * m21 * m00 - m22 * m01 * m10;
    }

    public static final void invert3x3(double[] m) throws IllegalArgumentException {
        assert (m.length >= 9) : "Not enough coordinates.";
        double det = LinAlgHelpers.det3x3(m);
        if (det == 0.0) {
            throw new IllegalArgumentException("Matrix not invertible.");
        }
        double i00 = (m[4] * m[8] - m[5] * m[7]) / det;
        double i01 = (m[2] * m[7] - m[1] * m[8]) / det;
        double i02 = (m[1] * m[5] - m[2] * m[4]) / det;
        double i10 = (m[5] * m[6] - m[3] * m[8]) / det;
        double i11 = (m[0] * m[8] - m[2] * m[6]) / det;
        double i12 = (m[2] * m[3] - m[0] * m[5]) / det;
        double i20 = (m[3] * m[7] - m[4] * m[6]) / det;
        double i21 = (m[1] * m[6] - m[0] * m[7]) / det;
        double i22 = (m[0] * m[4] - m[1] * m[3]) / det;
        m[0] = i00;
        m[1] = i01;
        m[2] = i02;
        m[3] = i10;
        m[4] = i11;
        m[5] = i12;
        m[6] = i20;
        m[7] = i21;
        m[8] = i22;
    }

    public static final double[] invert3x3(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) throws IllegalArgumentException {
        double det = LinAlgHelpers.det3x3(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        if (det == 0.0) {
            throw new IllegalArgumentException("Matrix not invertible.");
        }
        return new double[]{(m11 * m22 - m12 * m21) / det, (m02 * m21 - m01 * m22) / det, (m01 * m12 - m02 * m11) / det, (m12 * m20 - m10 * m22) / det, (m00 * m22 - m02 * m20) / det, (m02 * m10 - m00 * m12) / det, (m10 * m21 - m11 * m20) / det, (m01 * m20 - m00 * m21) / det, (m00 * m11 - m01 * m10) / det};
    }

    public static void invertSymmetric3x3(double[][] m, double[][] inverse) {
        double a00 = m[2][2] * m[1][1] - m[1][2] * m[1][2];
        double a01 = m[0][2] * m[1][2] - m[2][2] * m[0][1];
        double a02 = m[0][1] * m[1][2] - m[0][2] * m[1][1];
        double a11 = m[2][2] * m[0][0] - m[0][2] * m[0][2];
        double a12 = m[0][1] * m[0][2] - m[0][0] * m[1][2];
        double a22 = m[0][0] * m[1][1] - m[0][1] * m[0][1];
        double Dinv = 1.0 / (m[0][0] * a00 + m[1][0] * a01 + m[0][2] * a02);
        inverse[0][0] = a00 * Dinv;
        double d = a01 * Dinv;
        inverse[0][1] = d;
        inverse[1][0] = d;
        double d2 = a02 * Dinv;
        inverse[0][2] = d2;
        inverse[2][0] = d2;
        inverse[1][1] = a11 * Dinv;
        double d3 = a12 * Dinv;
        inverse[1][2] = d3;
        inverse[2][1] = d3;
        inverse[2][2] = a22 * Dinv;
    }

    public static void invertSymmetric2x2(double[][] m, double[][] inverse) {
        double Dinv = 1.0 / (m[0][0] * m[1][1] - m[1][0] * m[1][0]);
        inverse[0][0] = m[1][1] * Dinv;
        double d = -m[1][0] * Dinv;
        inverse[0][1] = d;
        inverse[1][0] = d;
        inverse[1][1] = m[0][0] * Dinv;
    }

    public static String toString(double[][] A) {
        return LinAlgHelpers.toString(A, "%6.3f ");
    }

    public static String toString(double[][] A, String format) {
        int rows = LinAlgHelpers.rows(A);
        int cols = LinAlgHelpers.cols(A);
        String result = "";
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                result = result + String.format(format, A[i][j]);
            }
            result = result + "\n";
        }
        return result;
    }

    public static String toString(double[] a) {
        return LinAlgHelpers.toString(a, "%6.3f ");
    }

    public static String toString(double[] a, String format) {
        int rows = LinAlgHelpers.rows(a);
        String result = "";
        for (int i = 0; i < rows; ++i) {
            result = result + String.format(format, a[i]);
        }
        result = result + "\n";
        return result;
    }
}

