/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.fft;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.MultiThreaded;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.algorithm.fft.FourierTransform;
import net.imglib2.algorithm.fft.InverseFourierTransform;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.iterator.LocalizingZeroMinIntervalIterator;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

@Deprecated
public class FourierConvolution<T extends RealType<T>, S extends RealType<S>>
implements MultiThreaded,
OutputAlgorithm<Img<T>>,
Benchmark {
    final int numDimensions;
    Img<T> convolved;
    RandomAccessibleInterval<T> image;
    RandomAccessibleInterval<S> kernel;
    Img<ComplexFloatType> kernelFFT;
    Img<ComplexFloatType> imgFFT;
    FourierTransform<T, ComplexFloatType> fftImage;
    final ImgFactory<ComplexFloatType> fftImgFactory;
    final ImgFactory<T> imgFactory;
    final ImgFactory<S> kernelImgFactory;
    boolean keepImgFFT = true;
    final int[] kernelDim;
    String errorMessage = "";
    int numThreads;
    long processingTime;

    public static <T extends RealType<T>, S extends RealType<S>> Img<T> convolve(Img<T> img, Img<S> kernel) throws IncompatibleTypeException {
        FourierConvolution<T, S> convolution = new FourierConvolution<T, S>(img, kernel);
        convolution.process();
        return convolution.getResult();
    }

    public static <T extends RealType<T>, S extends RealType<S>> Img<T> convolve(RandomAccessibleInterval<T> input, RandomAccessibleInterval<S> kernel, ImgFactory<T> imgFactory, ImgFactory<S> kernelImgFactory, ImgFactory<ComplexFloatType> fftImgFactory) {
        FourierConvolution<T, S> convolution = new FourierConvolution<T, S>(input, kernel, imgFactory, kernelImgFactory, fftImgFactory);
        convolution.process();
        return convolution.getResult();
    }

    public FourierConvolution(RandomAccessibleInterval<T> image, RandomAccessibleInterval<S> kernel, ImgFactory<T> imgFactory, ImgFactory<S> kernelImgFactory, ImgFactory<ComplexFloatType> fftImgFactory) {
        this.numDimensions = image.numDimensions();
        this.image = image;
        this.kernel = kernel;
        this.fftImgFactory = fftImgFactory;
        this.imgFactory = imgFactory;
        this.kernelImgFactory = kernelImgFactory;
        this.kernelDim = new int[this.numDimensions];
        for (int d = 0; d < this.numDimensions; ++d) {
            this.kernelDim[d] = (int)kernel.dimension(d);
        }
        this.kernelFFT = null;
        this.imgFFT = null;
        this.setNumThreads();
    }

    public FourierConvolution(Img<T> image, Img<S> kernel, ImgFactory<ComplexFloatType> fftImgFactory) {
        this(image, kernel, image.factory(), kernel.factory(), fftImgFactory);
    }

    public FourierConvolution(Img<T> image, Img<S> kernel) throws IncompatibleTypeException {
        this(image, kernel, image.factory(), kernel.factory(), image.factory().imgFactory(new ComplexFloatType()));
    }

    public ImgFactory<ComplexFloatType> fftImgFactory() {
        return this.fftImgFactory;
    }

    public ImgFactory<T> imgFactory() {
        return this.imgFactory;
    }

    public boolean replaceInput(RandomAccessibleInterval<T> img) {
        this.image = img;
        this.imgFFT = null;
        return true;
    }

    public void setKeepImgFFT(boolean keepImgFFT) {
        this.keepImgFFT = keepImgFFT;
    }

    public boolean getKeepImgFFT() {
        return this.keepImgFFT;
    }

    public boolean replaceKernel(RandomAccessibleInterval<S> knl) {
        this.kernel = knl;
        this.kernelFFT = null;
        return true;
    }

    public static final Img<FloatType> createGaussianKernel(ImgFactory<FloatType> factory, double sigma, int numDimensions) {
        double[] sigmas = new double[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            sigmas[d] = sigma;
        }
        return FourierConvolution.createGaussianKernel(factory, sigmas);
    }

    public static final Img<FloatType> createGaussianKernel(ImgFactory<FloatType> factory, double[] sigmas) {
        int numDimensions = sigmas.length;
        int[] imageSize = new int[numDimensions];
        double[][] kernel = new double[numDimensions][];
        for (int d = 0; d < numDimensions; ++d) {
            kernel[d] = Util.createGaussianKernel1DDouble(sigmas[d], true);
            imageSize[d] = kernel[d].length;
        }
        Img<FloatType> kernelImg = factory.create(imageSize, new FloatType());
        RealCursor cursor = kernelImg.localizingCursor();
        int[] position = new int[numDimensions];
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(position);
            double value = 1.0;
            for (int d = 0; d < numDimensions; ++d) {
                value *= kernel[d][position[d]];
            }
            ((FloatType)cursor.get()).set((float)value);
        }
        return kernelImg;
    }

    @Override
    public boolean process() {
        int d;
        long startTime = System.currentTimeMillis();
        if (this.imgFFT == null) {
            this.fftImage = new FourierTransform<T, ComplexFloatType>(this.image, this.fftImgFactory, new ComplexFloatType());
            this.fftImage.setNumThreads(this.getNumThreads());
            this.fftImage.setPreProcessing(FourierTransform.PreProcessing.EXTEND_MIRROR);
            this.fftImage.setRearrangement(FourierTransform.Rearrangement.UNCHANGED);
            int[] imageExtension = (int[])this.kernelDim.clone();
            d = 0;
            while (d < this.numDimensions) {
                int n = d++;
                imageExtension[n] = imageExtension[n] - 1;
            }
            this.fftImage.setImageExtension(imageExtension);
            if (!this.fftImage.checkInput() || !this.fftImage.process()) {
                this.errorMessage = "FFT of image failed: " + this.fftImage.getErrorMessage();
                return false;
            }
            this.imgFFT = this.fftImage.getResult();
        }
        if (this.kernelFFT == null) {
            int[] kernelTemplateDim = new int[this.numDimensions];
            for (d = 0; d < this.numDimensions; ++d) {
                kernelTemplateDim[d] = (int)this.imgFFT.dimension(d);
            }
            kernelTemplateDim[0] = ((int)this.imgFFT.dimension(0) - 1) * 2;
            RealType kernelType = (RealType)Util.getTypeFromInterval(this.kernel);
            Img<S> kernelTemplate = this.kernelImgFactory.create(kernelTemplateDim, kernelType.createVariable());
            RandomAccess kernelCursor = this.kernel.randomAccess();
            RandomAccess kernelTemplateCursor = kernelTemplate.randomAccess();
            LocalizingZeroMinIntervalIterator cursorDim = new LocalizingZeroMinIntervalIterator(this.kernel);
            int[] position = new int[this.numDimensions];
            int[] position2 = new int[this.numDimensions];
            while (cursorDim.hasNext()) {
                cursorDim.fwd();
                cursorDim.localize(position);
                for (int d2 = 0; d2 < this.numDimensions; ++d2) {
                    position2[d2] = position[d2] + (int)this.kernel.min(d2);
                    position[d2] = (position[d2] - this.kernelDim[d2] / 2 + kernelTemplateDim[d2]) % kernelTemplateDim[d2];
                }
                kernelCursor.setPosition(position2);
                kernelTemplateCursor.setPosition(position);
                ((RealType)kernelTemplateCursor.get()).set((Type)kernelCursor.get());
            }
            FourierTransform<S, ComplexFloatType> fftKernel = new FourierTransform<S, ComplexFloatType>(kernelTemplate, this.fftImgFactory, new ComplexFloatType());
            fftKernel.setNumThreads(this.getNumThreads());
            fftKernel.setPreProcessing(FourierTransform.PreProcessing.NONE);
            fftKernel.setRearrangement(this.fftImage.getRearrangement());
            if (!fftKernel.checkInput() || !fftKernel.process()) {
                this.errorMessage = "FFT of kernel failed: " + fftKernel.getErrorMessage();
                return false;
            }
            this.kernelFFT = fftKernel.getResult();
        }
        Img<ComplexFloatType> copy = this.keepImgFFT ? this.imgFFT.copy() : this.imgFFT;
        this.multiply(copy, this.kernelFFT);
        InverseFourierTransform<FourierTransform<T, ComplexFloatType>, ComplexFloatType> invFFT = new InverseFourierTransform<FourierTransform<T, ComplexFloatType>, ComplexFloatType>((RandomAccessibleInterval<ComplexFloatType>)copy, this.imgFactory, this.fftImage);
        invFFT.setNumThreads(this.getNumThreads());
        if (!invFFT.checkInput() || !invFFT.process()) {
            this.errorMessage = "InverseFFT of image failed: " + invFFT.getErrorMessage();
            return false;
        }
        if (!this.keepImgFFT) {
            this.imgFFT = null;
        }
        this.convolved = invFFT.getResult();
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    protected void multiply(RandomAccessibleInterval<ComplexFloatType> a, RandomAccessibleInterval<ComplexFloatType> b) {
        RealCursor cursorA = Views.iterable(a).cursor();
        RealCursor cursorB = Views.iterable(b).cursor();
        while (cursorA.hasNext()) {
            cursorA.fwd();
            cursorB.fwd();
            ((ComplexFloatType)cursorA.get()).mul((ComplexFloatType)cursorB.get());
        }
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public Img<T> getResult() {
        return this.convolved;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "Input image is null";
            return false;
        }
        if (this.kernel == null) {
            this.errorMessage = "Kernel image is null";
            return false;
        }
        for (int d = 0; d < this.numDimensions; ++d) {
            if (this.kernel.dimension(d) % 2L == 1L) continue;
            this.errorMessage = "Kernel image has NO odd dimensionality in dim " + d + " (" + this.kernel.dimension(d) + ")";
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

