/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.kdtree;

import java.util.ArrayList;
import net.imglib2.KDTree;
import net.imglib2.KDTreeNode;
import net.imglib2.algorithm.kdtree.HyperPlane;
import net.imglib2.algorithm.kdtree.KDTreeNodeIterable;

public class SplitHyperPlaneKDTree<T> {
    private final KDTree<T> tree;
    private final int n;
    private final double[] normal;
    private double m;
    private final double[] xmin;
    private final double[] xmax;
    private final ArrayList<KDTreeNode<T>> aboveNodes;
    private final ArrayList<KDTreeNode<T>> aboveSubtrees;
    private final ArrayList<KDTreeNode<T>> belowNodes;
    private final ArrayList<KDTreeNode<T>> belowSubtrees;

    public SplitHyperPlaneKDTree(KDTree<T> tree) {
        this.n = tree.numDimensions();
        this.xmin = new double[this.n];
        this.xmax = new double[this.n];
        this.normal = new double[this.n];
        this.tree = tree;
        this.aboveNodes = new ArrayList();
        this.aboveSubtrees = new ArrayList();
        this.belowNodes = new ArrayList();
        this.belowSubtrees = new ArrayList();
    }

    public int numDimensions() {
        return this.n;
    }

    public void split(HyperPlane plane) {
        this.initNewSearch();
        System.arraycopy(plane.getNormal(), 0, this.normal, 0, this.n);
        this.m = plane.getDistance();
        this.split(this.tree.getRoot());
    }

    public void split(double[] plane) {
        this.initNewSearch();
        System.arraycopy(plane, 0, this.normal, 0, this.n);
        this.m = plane[this.n];
        this.split(this.tree.getRoot());
    }

    private void initNewSearch() {
        this.aboveNodes.clear();
        this.aboveSubtrees.clear();
        this.belowNodes.clear();
        this.belowSubtrees.clear();
        this.tree.realMin(this.xmin);
        this.tree.realMax(this.xmax);
    }

    public Iterable<KDTreeNode<T>> getAboveNodes() {
        return new KDTreeNodeIterable<T>(this.aboveNodes, this.aboveSubtrees);
    }

    public Iterable<KDTreeNode<T>> getBelowNodes() {
        return new KDTreeNodeIterable<T>(this.belowNodes, this.belowSubtrees);
    }

    private static <T> void addAll(KDTreeNode<T> node, ArrayList<KDTreeNode<T>> list) {
        list.add(node);
    }

    private boolean allAbove() {
        double dot = 0.0;
        for (int d = 0; d < this.n; ++d) {
            dot += this.normal[d] * (this.normal[d] >= 0.0 ? this.xmin[d] : this.xmax[d]);
        }
        return dot >= this.m;
    }

    private boolean allBelow() {
        double dot = 0.0;
        for (int d = 0; d < this.n; ++d) {
            dot += this.normal[d] * (this.normal[d] < 0.0 ? this.xmin[d] : this.xmax[d]);
        }
        return dot < this.m;
    }

    private void splitSubtree(KDTreeNode<T> current, boolean p, boolean q) {
        if (p && q && this.allAbove()) {
            SplitHyperPlaneKDTree.addAll(current, this.aboveSubtrees);
        } else if (!p && !q && this.allBelow()) {
            SplitHyperPlaneKDTree.addAll(current, this.belowSubtrees);
        } else {
            this.split(current);
        }
    }

    private void split(KDTreeNode<T> current) {
        boolean p;
        int sd = current.getSplitDimension();
        double sc = current.getSplitCoordinate();
        double dot = 0.0;
        for (int d = 0; d < this.n; ++d) {
            dot += current.getDoublePosition(d) * this.normal[d];
        }
        boolean bl = p = dot >= this.m;
        if (p) {
            this.aboveNodes.add(current);
        } else {
            this.belowNodes.add(current);
        }
        if (current.left != null) {
            double max = this.xmax[sd];
            this.xmax[sd] = sc;
            this.splitSubtree(current.left, p, this.normal[sd] < 0.0);
            this.xmax[sd] = max;
        }
        if (current.right != null) {
            double min = this.xmin[sd];
            this.xmin[sd] = sc;
            this.splitSubtree(current.right, p, this.normal[sd] >= 0.0);
            this.xmin[sd] = min;
        }
    }
}

