/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.localization;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.MultiThreaded;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.algorithm.localization.FitFunction;
import net.imglib2.algorithm.localization.FunctionFitter;
import net.imglib2.algorithm.localization.LocalizationUtils;
import net.imglib2.algorithm.localization.Observation;
import net.imglib2.algorithm.localization.StartPointEstimator;
import net.imglib2.type.numeric.RealType;

public class PeakFitter<T extends RealType<T>>
implements MultiThreaded,
OutputAlgorithm<Map<Localizable, double[]>>,
Benchmark {
    private static final String BASE_ERROR_MESSAGE = "PeakFitter: ";
    private final RandomAccessibleInterval<T> image;
    private final Collection<Localizable> peaks;
    private final FunctionFitter fitter;
    private final FitFunction peakFunction;
    private final StartPointEstimator estimator;
    private ConcurrentHashMap<Localizable, double[]> results;
    private int numThreads;
    private final StringBuffer errorHolder = new StringBuffer();
    private long processingTime;

    public PeakFitter(RandomAccessibleInterval<T> image, Collection<Localizable> peaks, FunctionFitter fitter, FitFunction peakFunction, StartPointEstimator estimator) {
        this.image = image;
        this.fitter = fitter;
        this.peakFunction = peakFunction;
        this.estimator = estimator;
        this.peaks = peaks;
        this.setNumThreads();
    }

    public String toString() {
        return "PeakFitter configured to:\n - fit a " + this.peakFunction.toString() + "\n - on " + this.peaks.size() + " peaks\n - in image " + this.image + "\n - using " + this.estimator.toString() + "\n - and " + this.fitter.toString() + "\n - allocating " + this.numThreads + " threads.";
    }

    @Override
    public boolean checkInput() {
        if (null == this.image) {
            this.errorHolder.append("PeakFitter: Image is null.");
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorHolder.toString();
    }

    @Override
    public boolean process() {
        long start = System.currentTimeMillis();
        this.results = new ConcurrentHashMap(this.peaks.size());
        final long[] padSize = this.estimator.getDomainSpan();
        ExecutorService workers = Executors.newFixedThreadPool(this.numThreads);
        for (final Localizable peak : this.peaks) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    Observation data = LocalizationUtils.gatherObservationData(PeakFitter.this.image, peak, padSize);
                    double[] params = PeakFitter.this.estimator.initializeFit(peak, data);
                    try {
                        double[][] X = data.X;
                        double[] I = data.I;
                        PeakFitter.this.fitter.fit(X, I, params, PeakFitter.this.peakFunction);
                    }
                    catch (Exception e) {
                        PeakFitter.this.errorHolder.append("PeakFitter: Problem fitting around " + peak + ": " + e.getMessage() + ".\n");
                    }
                    PeakFitter.this.results.put(peak, params);
                }
            };
            workers.execute(task);
        }
        workers.shutdown();
        boolean ok = true;
        try {
            ok = workers.awaitTermination(1L, TimeUnit.HOURS);
            if (!ok) {
                System.err.println("Timeout reached while processing.");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return ok;
    }

    @Override
    public Map<Localizable, double[]> getResult() {
        return this.results;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }
}

