/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.Iterator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractLocalizable;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealPositionable;
import net.imglib2.algorithm.neighborhood.DiamondNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.Neighborhood;

public class DiamondNeighborhood<T>
extends AbstractLocalizable
implements Neighborhood<T> {
    private final RandomAccess<T> sourceRandomAccess;
    private final long radius;
    private final int maxDim;
    private final FinalInterval structuringElementBoundingBox;

    public static <T> DiamondNeighborhoodFactory<T> factory() {
        return new DiamondNeighborhoodFactory<T>(){

            @Override
            public Neighborhood<T> create(long[] position, long radius, RandomAccess<T> sourceRandomAccess) {
                return new DiamondNeighborhood(position, radius, sourceRandomAccess);
            }
        };
    }

    DiamondNeighborhood(long[] position, long radius, RandomAccess<T> sourceRandomAccess) {
        super(position);
        this.sourceRandomAccess = sourceRandomAccess;
        this.radius = radius;
        this.maxDim = this.n - 1;
        long[] min = new long[this.n];
        long[] max = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            min[d] = -radius;
            max[d] = radius;
        }
        this.structuringElementBoundingBox = new FinalInterval(min, max);
    }

    @Override
    public Interval getStructuringElementBoundingBox() {
        return this.structuringElementBoundingBox;
    }

    @Override
    public long size() {
        if (this.n < 1) {
            return 1L;
        }
        if (this.n < 2) {
            return 2L * this.radius + 1L;
        }
        if (this.n < 3) {
            return this.radius * this.radius + (this.radius + 1L) * (this.radius + 1L);
        }
        return DiamondNeighborhood.diamondSize(this.radius, this.n);
    }

    private static final long diamondSize(long rad, int dim) {
        if (dim == 2) {
            return rad * rad + (rad + 1L) * (rad + 1L);
        }
        long size = 0L;
        int r = 0;
        while ((long)r < rad) {
            size += 2L * DiamondNeighborhood.diamondSize(r, dim - 1);
            ++r;
        }
        return size += DiamondNeighborhood.diamondSize(rad, dim - 1);
    }

    @Override
    public T firstElement() {
        return this.cursor().next();
    }

    @Override
    public Object iterationOrder() {
        return this;
    }

    @Override
    public double realMin(int d) {
        return this.position[d] - this.radius;
    }

    @Override
    public void realMin(double[] min) {
        for (int d = 0; d < min.length; ++d) {
            min[d] = this.position[d] - this.radius;
        }
    }

    @Override
    public void realMin(RealPositionable min) {
        for (int d = 0; d < min.numDimensions(); ++d) {
            min.setPosition(this.position[d] - this.radius, d);
        }
    }

    @Override
    public double realMax(int d) {
        return this.position[d] + this.radius;
    }

    @Override
    public void realMax(double[] max) {
        for (int d = 0; d < max.length; ++d) {
            max[d] = this.position[d] + this.radius;
        }
    }

    @Override
    public void realMax(RealPositionable max) {
        for (int d = 0; d < max.numDimensions(); ++d) {
            max.setPosition(this.position[d] + this.radius, d);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.cursor();
    }

    @Override
    public long min(int d) {
        return this.position[d] - this.radius;
    }

    @Override
    public void min(long[] min) {
        for (int d = 0; d < min.length; ++d) {
            min[d] = this.position[d] - this.radius;
        }
    }

    @Override
    public void min(Positionable min) {
        for (int d = 0; d < min.numDimensions(); ++d) {
            min.setPosition(this.position[d] - this.radius, d);
        }
    }

    @Override
    public long max(int d) {
        return this.position[d] + this.radius;
    }

    @Override
    public void max(long[] max) {
        for (int d = 0; d < max.length; ++d) {
            max[d] = this.position[d] + this.radius;
        }
    }

    @Override
    public void max(Positionable max) {
        for (int d = 0; d < max.numDimensions(); ++d) {
            max.setPosition(this.position[d] + this.radius, d);
        }
    }

    @Override
    public void dimensions(long[] dimensions) {
        for (int d = 0; d < dimensions.length; ++d) {
            dimensions[d] = 2L * this.radius + 1L;
        }
    }

    @Override
    public long dimension(int d) {
        return 2L * this.radius + 1L;
    }

    @Override
    public LocalCursor cursor() {
        return new LocalCursor(this.sourceRandomAccess.copyRandomAccess());
    }

    @Override
    public LocalCursor localizingCursor() {
        return this.cursor();
    }

    public class LocalCursor
    extends AbstractEuclideanSpace
    implements Cursor<T> {
        protected final RandomAccess<T> source;
        protected final long[] ri;
        protected final long[] s;

        public LocalCursor(RandomAccess<T> source) {
            super(source.numDimensions());
            this.source = source;
            this.ri = new long[this.n];
            this.s = new long[this.n];
            this.reset();
        }

        protected LocalCursor(LocalCursor c) {
            super(c.numDimensions());
            this.source = c.source.copyRandomAccess();
            this.ri = (long[])c.ri.clone();
            this.s = (long[])c.s.clone();
        }

        @Override
        public T get() {
            return this.source.get();
        }

        @Override
        public void fwd() {
            this.s[0] = this.s[0] - 1L;
            if (this.s[0] >= 0L) {
                this.source.fwd(0);
            } else {
                int d = 1;
                while (d < this.n) {
                    int n = d++;
                    this.s[n] = this.s[n] - 1L;
                    if (this.s[n] < 0L) continue;
                    this.source.fwd(d);
                    break;
                }
                while (d > 0) {
                    long rad;
                    int e = d - 1;
                    long pd = Math.abs(this.s[d] - this.ri[d]);
                    this.ri[e] = rad = this.ri[d] - pd;
                    this.s[e] = 2L * rad;
                    this.source.setPosition(DiamondNeighborhood.this.position[e] - rad, e);
                    --d;
                }
            }
        }

        @Override
        public void jumpFwd(long steps) {
            for (long i = 0L; i < steps; ++i) {
                this.fwd();
            }
        }

        @Override
        public T next() {
            this.fwd();
            return this.get();
        }

        @Override
        public void remove() {
        }

        @Override
        public void reset() {
            for (int d = 0; d < DiamondNeighborhood.this.maxDim; ++d) {
                this.s[d] = 0L;
                this.ri[d] = 0L;
                this.source.setPosition(DiamondNeighborhood.this.position[d], d);
            }
            this.source.setPosition(DiamondNeighborhood.this.position[DiamondNeighborhood.this.maxDim] - DiamondNeighborhood.this.radius - 1L, DiamondNeighborhood.this.maxDim);
            this.ri[((DiamondNeighborhood)DiamondNeighborhood.this).maxDim] = DiamondNeighborhood.this.radius;
            this.s[((DiamondNeighborhood)DiamondNeighborhood.this).maxDim] = 1L + 2L * DiamondNeighborhood.this.radius;
        }

        @Override
        public boolean hasNext() {
            return this.s[DiamondNeighborhood.this.maxDim] > 0L;
        }

        @Override
        public float getFloatPosition(int d) {
            return this.source.getFloatPosition(d);
        }

        @Override
        public double getDoublePosition(int d) {
            return this.source.getDoublePosition(d);
        }

        @Override
        public int getIntPosition(int d) {
            return this.source.getIntPosition(d);
        }

        @Override
        public long getLongPosition(int d) {
            return this.source.getLongPosition(d);
        }

        @Override
        public void localize(long[] position) {
            this.source.localize(position);
        }

        @Override
        public void localize(float[] position) {
            this.source.localize(position);
        }

        @Override
        public void localize(double[] position) {
            this.source.localize(position);
        }

        @Override
        public void localize(int[] position) {
            this.source.localize(position);
        }

        @Override
        public LocalCursor copy() {
            return new LocalCursor(this);
        }

        @Override
        public LocalCursor copyCursor() {
            return this.copy();
        }
    }
}

