/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.img;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.imglib2.Dimensions;
import net.imglib2.cache.Cache;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.IoSync;
import net.imglib2.cache.LoaderRemoverCache;
import net.imglib2.cache.img.AccessIo;
import net.imglib2.cache.img.CellLoader;
import net.imglib2.cache.img.DirtyDiskCellCache;
import net.imglib2.cache.img.DiskCachedCellImg;
import net.imglib2.cache.img.DiskCachedCellImgOptions;
import net.imglib2.cache.img.DiskCellCache;
import net.imglib2.cache.img.EmptyCellCacheLoader;
import net.imglib2.cache.img.LoadedCellCacheLoader;
import net.imglib2.cache.ref.GuardedStrongRefLoaderRemoverCache;
import net.imglib2.cache.ref.SoftRefLoaderRemoverCache;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.util.Fraction;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public class DiskCachedCellImgFactory<T extends NativeType<T>>
extends NativeImgFactory<T> {
    private DiskCachedCellImgOptions factoryOptions;

    public DiskCachedCellImgFactory(T type) {
        this(type, DiskCachedCellImgOptions.options());
    }

    public DiskCachedCellImgFactory(T type, DiskCachedCellImgOptions optional) {
        super(type);
        this.factoryOptions = optional;
    }

    @Override
    public DiskCachedCellImg<T, ?> create(long ... dimensions) {
        return this.create(dimensions, null, null, (NativeType)this.type(), null);
    }

    @Override
    public DiskCachedCellImg<T, ?> create(Dimensions dimensions) {
        return this.create(Intervals.dimensionsAsLongArray(dimensions));
    }

    @Override
    public DiskCachedCellImg<T, ?> create(int[] dimensions) {
        return this.create(Util.int2long(dimensions));
    }

    @Override
    public DiskCachedCellImg<T, ?> create(long[] dimensions, DiskCachedCellImgOptions additionalOptions) {
        return this.create(dimensions, null, null, (NativeType)this.type(), additionalOptions);
    }

    public DiskCachedCellImg<T, ?> create(Dimensions dimensions, DiskCachedCellImgOptions additionalOptions) {
        return this.create(Intervals.dimensionsAsLongArray(dimensions), (T)additionalOptions);
    }

    @Override
    public DiskCachedCellImg<T, ?> create(long[] dimensions, CellLoader<T> loader) {
        return this.create(dimensions, null, loader, (NativeType)this.type(), null);
    }

    public DiskCachedCellImg<T, ?> create(Dimensions dimensions, CellLoader<T> loader) {
        return this.create(Intervals.dimensionsAsLongArray(dimensions), null, loader, (NativeType)this.type(), null);
    }

    public DiskCachedCellImg<T, ?> create(long[] dimensions, CellLoader<T> loader, DiskCachedCellImgOptions additionalOptions) {
        return this.create(dimensions, null, loader, (NativeType)this.type(), additionalOptions);
    }

    public DiskCachedCellImg<T, ?> create(Dimensions dimensions, CellLoader<T> loader, DiskCachedCellImgOptions additionalOptions) {
        return this.create(Intervals.dimensionsAsLongArray(dimensions), null, loader, (NativeType)this.type(), additionalOptions);
    }

    public <A extends DataAccess> DiskCachedCellImg<T, A> createWithCacheLoader(long[] dimensions, CacheLoader<Long, Cell<A>> backingLoader) {
        return this.create(dimensions, backingLoader, null, (NativeType)this.type(), null);
    }

    public <A extends DataAccess> DiskCachedCellImg<T, A> createWithCacheLoader(Dimensions dimensions, CacheLoader<Long, Cell<A>> backingLoader) {
        return this.create(Intervals.dimensionsAsLongArray(dimensions), backingLoader, null, (NativeType)this.type(), null);
    }

    public <A extends DataAccess> DiskCachedCellImg<T, A> createWithCacheLoader(long[] dimensions, CacheLoader<Long, Cell<A>> backingLoader, DiskCachedCellImgOptions additionalOptions) {
        return this.create(dimensions, backingLoader, null, (NativeType)this.type(), additionalOptions);
    }

    public <A extends DataAccess> DiskCachedCellImg<T, A> createWithCacheLoader(Dimensions dimensions, CacheLoader<Long, Cell<A>> backingLoader, DiskCachedCellImgOptions additionalOptions) {
        return this.create(Intervals.dimensionsAsLongArray(dimensions), backingLoader, null, (NativeType)this.type(), additionalOptions);
    }

    private <A extends DataAccess> DiskCachedCellImg<T, A> create(long[] dimensions, CacheLoader<Long, ? extends Cell<? extends A>> cacheLoader, CellLoader<T> cellLoader, T type, DiskCachedCellImgOptions additionalOptions) {
        Dimensions.verify(dimensions);
        DiskCachedCellImg<T, ?> img = this.create(dimensions, cacheLoader, cellLoader, type, type.getNativeTypeFactory(), additionalOptions);
        return img;
    }

    private <A extends ArrayDataAccess<A>> DiskCachedCellImg<T, ? extends A> create(long[] dimensions, CacheLoader<Long, ? extends Cell<?>> cacheLoader, CellLoader<T> cellLoader, T type, NativeTypeFactory<T, A> typeFactory, DiskCachedCellImgOptions additionalOptions) {
        LoaderRemoverCache listenableCache;
        DiskCachedCellImgOptions.Values options = this.factoryOptions.append((DiskCachedCellImgOptions)additionalOptions).values;
        Fraction entitiesPerPixel = type.getEntitiesPerPixel();
        CellGrid grid = this.createCellGrid(dimensions, entitiesPerPixel, options);
        CacheLoader backingLoader = cacheLoader;
        if (backingLoader == null) {
            if (cellLoader != null) {
                CellLoader actualCellLoader = options.initializeCellsAsDirty() ? cell -> {
                    cellLoader.load(cell);
                    cell.setDirty();
                } : cellLoader;
                backingLoader = LoadedCellCacheLoader.get(grid, actualCellLoader, type, options.accessFlags());
            } else {
                backingLoader = EmptyCellCacheLoader.get(grid, type, options.accessFlags());
            }
        }
        Path blockcache = this.createBlockCachePath(options);
        DiskCellCache diskcache = options.dirtyAccesses() ? new DirtyDiskCellCache(blockcache, grid, backingLoader, AccessIo.get(type, options.accessFlags()), entitiesPerPixel) : new DiskCellCache(blockcache, grid, backingLoader, AccessIo.get(type, options.accessFlags()), entitiesPerPixel);
        IoSync iosync = new IoSync(diskcache, options.numIoThreads(), options.maxIoQueueSize());
        switch (options.cacheType()) {
            case BOUNDED: {
                listenableCache = new GuardedStrongRefLoaderRemoverCache(options.maxCacheSize());
                break;
            }
            default: {
                listenableCache = new SoftRefLoaderRemoverCache();
            }
        }
        Cache cache = listenableCache.withRemover(iosync).withLoader(iosync);
        Object accessType = ArrayDataAccessFactory.get(typeFactory, options.accessFlags());
        DiskCachedCellImg img = new DiskCachedCellImg(this, grid, entitiesPerPixel, cache, iosync, accessType);
        img.setLinkedType(typeFactory.createLinkedType(img));
        return img;
    }

    @Override
    public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        if (NativeType.class.isInstance(type)) {
            return new DiskCachedCellImgFactory<NativeType>((NativeType)type, this.factoryOptions);
        }
        throw new IncompatibleTypeException(this, type.getClass().getCanonicalName() + " does not implement NativeType.");
    }

    private CellGrid createCellGrid(long[] dimensions, Fraction entitiesPerPixel, DiskCachedCellImgOptions.Values options) {
        Dimensions.verify(dimensions);
        int n = dimensions.length;
        int[] cellDimensions = CellImgFactory.getCellDimensions(options.cellDimensions(), n, entitiesPerPixel);
        return new CellGrid(dimensions, cellDimensions);
    }

    private Path createBlockCachePath(DiskCachedCellImgOptions.Values options) {
        try {
            Path cache = options.cacheDirectory();
            Path dir = options.tempDirectory();
            String prefix = options.tempDirectoryPrefix();
            boolean deleteOnExit = options.deleteCacheDirectoryOnExit();
            if (cache != null) {
                if (!Files.isDirectory(cache, new LinkOption[0])) {
                    Files.createDirectories(cache, new FileAttribute[0]);
                    if (deleteOnExit) {
                        DiskCellCache.addDeleteHook(cache);
                    }
                }
                return cache;
            }
            if (dir != null) {
                return DiskCellCache.createTempDirectory(dir, prefix, deleteOnExit);
            }
            return DiskCellCache.createTempDirectory(prefix, deleteOnExit);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public DiskCachedCellImgFactory() {
        this(DiskCachedCellImgOptions.options());
    }

    @Deprecated
    public DiskCachedCellImgFactory(DiskCachedCellImgOptions optional) {
        this.factoryOptions = optional;
    }

    @Override
    @Deprecated
    public DiskCachedCellImg<T, ?> create(long[] dim, T type) {
        this.cache(type);
        return this.create(dim, null, null, type, null);
    }

    @Deprecated
    public DiskCachedCellImg<T, ?> create(long[] dim, T type, DiskCachedCellImgOptions additionalOptions) {
        this.cache(type);
        return this.create(dim, null, null, type, additionalOptions);
    }

    @Deprecated
    public DiskCachedCellImg<T, ?> create(long[] dim, T type, CellLoader<T> loader) {
        this.cache(type);
        return this.create(dim, null, loader, type, null);
    }

    @Deprecated
    public DiskCachedCellImg<T, ?> create(long[] dim, T type, CellLoader<T> loader, DiskCachedCellImgOptions additionalOptions) {
        this.cache(type);
        return this.create(dim, null, loader, type, additionalOptions);
    }

    @Deprecated
    public <A extends DataAccess> DiskCachedCellImg<T, A> createWithCacheLoader(long[] dim, T type, CacheLoader<Long, Cell<A>> backingLoader) {
        this.cache(type);
        return this.create(dim, backingLoader, null, type, null);
    }

    @Deprecated
    public <A extends DataAccess> DiskCachedCellImg<T, A> createWithCacheLoader(long[] dim, T type, CacheLoader<Long, Cell<A>> backingLoader, DiskCachedCellImgOptions additionalOptions) {
        this.cache(type);
        return this.create(dim, backingLoader, null, type, additionalOptions);
    }
}

