/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.img;

import java.util.Iterator;
import net.imglib2.AbstractCursor;
import net.imglib2.AbstractInterval;
import net.imglib2.AbstractLocalizable;
import net.imglib2.AbstractLocalizingCursor;
import net.imglib2.Cursor;
import net.imglib2.Dirty;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.util.IntervalIndexer;

public class SingleCellArrayImg<T extends NativeType<T>, A extends ArrayDataAccess<A>>
extends AbstractInterval
implements NativeImg<T, A> {
    final int[] steps;
    final int[] dimensions;
    private long size;
    private A data;
    private Dirty dirty;
    private T linkedType;

    @Override
    public void setLinkedType(T type) {
        this.linkedType = type;
    }

    @Override
    public T createLinkedType() {
        try {
            return this.linkedType.duplicateTypeOnSameNativeImg();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public A update(Object updater) {
        return this.data;
    }

    public SingleCellArrayImg(int n) {
        super(n);
        this.steps = new int[n];
        this.dimensions = new int[n];
    }

    public SingleCellArrayImg(int[] cellDims, long[] cellMin, A cellData, Dirty dirtyFlag) {
        this(cellDims.length);
        this.reset(cellDims, cellMin, cellData, dirtyFlag);
    }

    public Object getStorageArray() {
        return this.data.getCurrentStorageArray();
    }

    public void setDirty() {
        this.dirty.setDirty();
    }

    SingleCellArrayImg(int[] cellDims, long[] cellMin, A cellData, Dirty dirtyFlag, T type) {
        this(cellDims, cellMin, cellData, dirtyFlag);
        NativeTypeFactory<T, ?> info = type.getNativeTypeFactory();
        this.setLinkedType(info.createLinkedType(this));
    }

    void reset(int[] cellDims, long[] cellMin, A cellData, Dirty dirtyFlag) {
        for (int d = 0; d < this.n; ++d) {
            this.min[d] = cellMin[d];
            this.max[d] = this.min[d] + (long)cellDims[d] - 1L;
            this.dimensions[d] = cellDims[d];
        }
        IntervalIndexer.createAllocationSteps(cellDims, this.steps);
        this.size = this.steps[this.n - 1] * cellDims[this.n - 1];
        this.data = cellData;
        this.dirty = dirtyFlag;
    }

    @Override
    public RandomAccess<T> randomAccess() {
        return new CellArrayRandomAccess();
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    @Override
    public T getType() {
        return this.linkedType;
    }

    @Override
    public Cursor<T> cursor() {
        return new CellArrayCursor();
    }

    @Override
    public Cursor<T> localizingCursor() {
        return new CellArrayLocalizingCursor();
    }

    @Override
    public ImgFactory<T> factory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Img<T> copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public T firstElement() {
        return (T)((NativeType)this.cursor().next());
    }

    @Override
    public Object iterationOrder() {
        return new FlatIterationOrder(this);
    }

    @Override
    public Iterator<T> iterator() {
        return this.cursor();
    }

    class CellArrayLocalizingCursor
    extends AbstractLocalizingCursor<T> {
        final T type;
        final int lastIndex;

        CellArrayLocalizingCursor() {
            super(SingleCellArrayImg.this.n);
            this.type = SingleCellArrayImg.this.createLinkedType();
            this.lastIndex = (int)SingleCellArrayImg.this.size() - 1;
            this.reset();
        }

        CellArrayLocalizingCursor(CellArrayLocalizingCursor other) {
            super(other.n);
            this.type = SingleCellArrayImg.this.createLinkedType();
            this.lastIndex = other.lastIndex;
            System.arraycopy(other.position, 0, this.position, 0, this.n);
            this.type.updateIndex(other.type.getIndex());
            this.type.updateContainer(this);
        }

        @Override
        public T get() {
            return this.type;
        }

        @Override
        public T getType() {
            return this.type;
        }

        @Override
        public void fwd() {
            this.type.incIndex();
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + 1L;
                if (this.position[n] <= SingleCellArrayImg.this.max[d]) break;
                this.position[d] = SingleCellArrayImg.this.min[d];
            }
        }

        @Override
        public void jumpFwd(long steps) {
            this.type.incIndex((int)steps);
            IntervalIndexer.indexToPositionWithOffset(this.type.getIndex(), SingleCellArrayImg.this.dimensions, SingleCellArrayImg.this.min, this.position);
        }

        @Override
        public T next() {
            this.fwd();
            return this.get();
        }

        @Override
        public boolean hasNext() {
            return this.type.getIndex() < this.lastIndex;
        }

        @Override
        public void reset() {
            this.type.updateIndex(-1);
            this.type.updateContainer(this);
            System.arraycopy(SingleCellArrayImg.this.min, 0, this.position, 0, this.n);
            this.position[0] = this.position[0] - 1L;
        }

        @Override
        public CellArrayLocalizingCursor copy() {
            return new CellArrayLocalizingCursor(this);
        }
    }

    class CellArrayCursor
    extends AbstractCursor<T> {
        final T type;
        final int lastIndex;

        CellArrayCursor() {
            super(SingleCellArrayImg.this.n);
            this.type = SingleCellArrayImg.this.createLinkedType();
            this.lastIndex = (int)SingleCellArrayImg.this.size() - 1;
            this.reset();
        }

        CellArrayCursor(CellArrayCursor other) {
            super(SingleCellArrayImg.this.n);
            this.type = SingleCellArrayImg.this.createLinkedType();
            this.lastIndex = other.lastIndex;
            this.type.updateIndex(other.type.getIndex());
            this.type.updateContainer(this);
        }

        @Override
        public T get() {
            return this.type;
        }

        @Override
        public T getType() {
            return this.type;
        }

        @Override
        public boolean hasNext() {
            return this.type.getIndex() < this.lastIndex;
        }

        @Override
        public void jumpFwd(long steps) {
            this.type.incIndex((int)steps);
        }

        @Override
        public T next() {
            this.fwd();
            return this.get();
        }

        @Override
        public void fwd() {
            this.type.incIndex();
        }

        @Override
        public void reset() {
            this.type.updateIndex(-1);
            this.type.updateContainer(this);
        }

        @Override
        public void localize(long[] position) {
            IntervalIndexer.indexToPositionWithOffset(this.type.getIndex(), SingleCellArrayImg.this.dimensions, SingleCellArrayImg.this.min, position);
        }

        @Override
        public long getLongPosition(int d) {
            return IntervalIndexer.indexToPositionWithOffset(this.type.getIndex(), SingleCellArrayImg.this.dimensions, SingleCellArrayImg.this.steps, SingleCellArrayImg.this.min, d);
        }

        @Override
        public CellArrayCursor copy() {
            return new CellArrayCursor(this);
        }
    }

    class CellArrayRandomAccess
    extends AbstractLocalizable
    implements RandomAccess<T> {
        final T type;

        CellArrayRandomAccess(CellArrayRandomAccess randomAccess) {
            super(SingleCellArrayImg.this.n);
            this.type = SingleCellArrayImg.this.createLinkedType();
            this.type.updateContainer(this);
            this.type.updateIndex(randomAccess.type.getIndex());
            System.arraycopy(randomAccess.position, 0, this.position, 0, this.n);
        }

        CellArrayRandomAccess() {
            super(SingleCellArrayImg.this.n);
            this.type = SingleCellArrayImg.this.createLinkedType();
            System.arraycopy(SingleCellArrayImg.this.min, 0, this.position, 0, this.n);
            this.type.updateContainer(this);
            this.type.updateIndex(0);
        }

        @Override
        public T get() {
            return this.type;
        }

        @Override
        public T getType() {
            return this.type;
        }

        @Override
        public void fwd(int d) {
            this.type.incIndex(SingleCellArrayImg.this.steps[d]);
            int n = d;
            this.position[n] = this.position[n] + 1L;
        }

        @Override
        public void bck(int d) {
            this.type.decIndex(SingleCellArrayImg.this.steps[d]);
            int n = d;
            this.position[n] = this.position[n] - 1L;
        }

        @Override
        public void move(int distance, int d) {
            this.type.incIndex(SingleCellArrayImg.this.steps[d] * distance);
            int n = d;
            this.position[n] = this.position[n] + (long)distance;
        }

        @Override
        public void move(long distance, int d) {
            this.type.incIndex(SingleCellArrayImg.this.steps[d] * (int)distance);
            int n = d;
            this.position[n] = this.position[n] + distance;
        }

        @Override
        public void move(Localizable localizable) {
            int index = 0;
            for (int d = 0; d < this.n; ++d) {
                int distance = localizable.getIntPosition(d);
                int n = d;
                this.position[n] = this.position[n] + (long)distance;
                index += distance * SingleCellArrayImg.this.steps[d];
            }
            this.type.incIndex(index);
        }

        @Override
        public void move(int[] distance) {
            int index = 0;
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (long)distance[d];
                index += distance[d] * SingleCellArrayImg.this.steps[d];
            }
            this.type.incIndex(index);
        }

        @Override
        public void move(long[] distance) {
            int index = 0;
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + distance[d];
                index += (int)distance[d] * SingleCellArrayImg.this.steps[d];
            }
            this.type.incIndex(index);
        }

        @Override
        public void setPosition(Localizable localizable) {
            localizable.localize(this.position);
            int index = 0;
            for (int d = 0; d < this.n; ++d) {
                index += (int)(this.position[d] - SingleCellArrayImg.this.min[d]) * SingleCellArrayImg.this.steps[d];
            }
            this.type.updateIndex(index);
        }

        @Override
        public void setPosition(int[] pos) {
            int index = 0;
            for (int d = 0; d < this.n; ++d) {
                this.position[d] = pos[d];
                index += (int)((long)pos[d] - SingleCellArrayImg.this.min[d]) * SingleCellArrayImg.this.steps[d];
            }
            this.type.updateIndex(index);
        }

        @Override
        public void setPosition(long[] pos) {
            int index = 0;
            for (int d = 0; d < this.n; ++d) {
                this.position[d] = pos[d];
                index += (int)(pos[d] - SingleCellArrayImg.this.min[d]) * SingleCellArrayImg.this.steps[d];
            }
            this.type.updateIndex(index);
        }

        @Override
        public void setPosition(int pos, int d) {
            this.type.incIndex((int)((long)pos - this.position[d]) * SingleCellArrayImg.this.steps[d]);
            this.position[d] = pos;
        }

        @Override
        public void setPosition(long pos, int d) {
            this.type.incIndex((int)(pos - this.position[d]) * SingleCellArrayImg.this.steps[d]);
            this.position[d] = pos;
        }

        @Override
        public CellArrayRandomAccess copy() {
            return new CellArrayRandomAccess(this);
        }
    }
}

