/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import java.util.function.Supplier;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.converter.Converters;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealViews;
import net.imglib2.realtransform.Scale;
import net.imglib2.realtransform.Scale2D;
import net.imglib2.realtransform.Scale3D;
import net.imglib2.realtransform.ScaleAndTranslation;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Localizables;
import net.imglib2.view.Views;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.RealComposite;

public class PositionFieldTransform
implements RealTransform {
    protected final RealRandomAccess<? extends RealLocalizable> access;
    protected final int numTargetDimensions;

    public PositionFieldTransform(RealRandomAccess<? extends RealLocalizable> positionAccesses) {
        this.access = positionAccesses;
        this.numTargetDimensions = ((RealLocalizable)this.access.get()).numDimensions();
    }

    public PositionFieldTransform(RealRandomAccessible<? extends RealLocalizable> positions) {
        this.access = positions.realRandomAccess();
        this.numTargetDimensions = ((RealLocalizable)this.access.get()).numDimensions();
    }

    public <T extends RealType<T>> PositionFieldTransform(RandomAccessibleInterval<T> positions) {
        this(PositionFieldTransform.convertToComposite(positions));
    }

    public <T extends RealType<T>> PositionFieldTransform(RandomAccessibleInterval<T> positions, AffineGet pixelToPhysical) {
        this(RealViews.affine(PositionFieldTransform.convertToComposite(positions), pixelToPhysical));
    }

    public <T extends RealType<T>> PositionFieldTransform(RandomAccessibleInterval<T> positions, double ... spacing) {
        this(RealViews.affine(PositionFieldTransform.convertToComposite(positions), spacing.length == 2 ? new Scale2D(spacing) : (spacing.length == 3 ? new Scale3D(spacing) : new Scale(spacing))));
    }

    public <T extends RealType<T>> PositionFieldTransform(RandomAccessibleInterval<T> positions, double[] spacing, double[] offset) {
        this(RealViews.affine(PositionFieldTransform.convertToComposite(positions), new ScaleAndTranslation(spacing, offset)));
    }

    @Override
    public int numSourceDimensions() {
        return this.access.numDimensions();
    }

    @Override
    public int numTargetDimensions() {
        return this.numTargetDimensions;
    }

    @Override
    public void apply(double[] source, double[] target) {
        this.access.setPosition(source);
        ((RealLocalizable)this.access.get()).localize(target);
    }

    @Override
    public void apply(float[] source, float[] target) {
        this.access.setPosition(source);
        ((RealLocalizable)this.access.get()).localize(target);
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        this.access.setPosition(source);
        ((RealLocalizable)this.access.get()).localize(target);
    }

    @Override
    public RealTransform copy() {
        return new PositionFieldTransform((RealRandomAccess<? extends RealLocalizable>)this.access.copy());
    }

    private static <T extends RealType<T>> RealRandomAccessible<? extends RealLocalizable> convertToComposite(RandomAccessibleInterval<T> position) {
        CompositeIntervalView<T, RealComposite<T>> collapsedFirst = Views.collapseReal(Views.moveAxis(position, 0, position.numDimensions() - 1));
        return Views.interpolate(Views.extendBorder(collapsedFirst), new NLinearInterpolatorFactory());
    }

    public static RandomAccessibleInterval<DoubleType> createPositionField(RealTransform transform, Interval interval, double[] spacing) {
        return PositionFieldTransform.createPositionField(transform, interval, new Scale(spacing), () -> DoubleType.createVector(transform.numTargetDimensions()));
    }

    public static RandomAccessibleInterval<DoubleType> createPositionField(RealTransform transform, Interval interval, double[] spacing, double[] offset) {
        return PositionFieldTransform.createPositionField(transform, interval, spacing, offset, () -> DoubleType.createVector(transform.numTargetDimensions()));
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<T> createPositionField(RealTransform transform, Interval interval, double[] spacing, double[] offset, Supplier<RealComposite<T>> supplier) {
        return PositionFieldTransform.createPositionField(transform, interval, new ScaleAndTranslation(spacing, offset), supplier);
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<T> createPositionField(RealTransform transform, Interval interval, RealTransform gridTransform, Supplier<RealComposite<T>> supplier) {
        RandomAccessibleInterval<Localizable> pixelCoordinates = Localizables.randomAccessibleInterval(interval);
        RandomAccessibleInterval<RealComposite<T>> positions = Converters.convert2(pixelCoordinates, () -> {
            RealTransform gridCopy = gridTransform.copy();
            RealTransform copy = transform.copy();
            return (x, y) -> {
                gridCopy.apply((RealLocalizable)x, (RealPositionable)y);
                copy.apply((RealLocalizable)y, (RealPositionable)y);
            };
        }, supplier);
        long[] pfieldDims = new long[interval.numDimensions() + 1];
        pfieldDims[0] = interval.numDimensions();
        for (int i = 0; i < interval.numDimensions(); ++i) {
            pfieldDims[i + 1] = interval.dimension(i);
        }
        return Views.interval(Views.interleave(positions), new FinalInterval(pfieldDims));
    }
}

