/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.roi.AbstractIterableRegionOfInterest;

@Deprecated
public class PolygonRegionOfInterest
extends AbstractIterableRegionOfInterest {
    protected ArrayList<RealPoint> points = new ArrayList();
    ArrayList<Stripe> stripes;

    public PolygonRegionOfInterest() {
        super(2);
    }

    public int getVertexCount() {
        return this.points.size();
    }

    public RealLocalizable getVertex(int index) {
        return this.points.get(index);
    }

    public void addVertex(int index, RealLocalizable p) {
        this.points.add(index, new RealPoint(p));
        this.invalidateCachedState();
        this.stripes = null;
    }

    public void removeVertex(int index) {
        this.points.remove(index);
        this.invalidateCachedState();
        this.stripes = null;
    }

    public void setVertexPosition(int index, double[] position) {
        this.points.get(index).setPosition(position);
        this.invalidateCachedState();
        this.stripes = null;
    }

    public void setVertexPosition(int index, float[] position) {
        this.points.get(index).setPosition(position);
        this.invalidateCachedState();
        this.stripes = null;
    }

    public void setVertexPosition(int index, RealLocalizable localizable) {
        this.points.get(index).setPosition(localizable);
        this.invalidateCachedState();
        this.stripes = null;
    }

    private boolean lt(double a, double b) {
        return (float)a < (float)b;
    }

    private boolean gt(double a, double b) {
        return (float)a > (float)b;
    }

    private boolean le(double a, double b) {
        return (float)a <= (float)b;
    }

    private boolean ge(double a, double b) {
        return (float)a >= (float)b;
    }

    private boolean eq(double a, double b) {
        return (float)a == (float)b;
    }

    protected void validate() {
        if (this.stripes == null) {
            int i;
            TreeSet<Double> y = new TreeSet<Double>();
            for (RealPoint p : this.points) {
                y.add(p.getDoublePosition(1));
            }
            Double[] dy = new Double[y.size()];
            y.toArray(dy);
            this.stripes = new ArrayList();
            for (i = 0; i < dy.length - 1; ++i) {
                this.stripes.add(new Stripe(dy[i], dy[i + 1]));
            }
            for (i = 0; i < this.points.size(); ++i) {
                RealLocalizable p0 = this.getEdgeStart(i);
                RealLocalizable p1 = this.getEdgeEnd(i);
                double x0 = p0.getDoublePosition(0);
                double y0 = p0.getDoublePosition(1);
                double x1 = p1.getDoublePosition(0);
                double y1 = p1.getDoublePosition(1);
                if (y0 > y1) {
                    double temp = x0;
                    temp = x0;
                    x0 = x1;
                    x1 = temp;
                    temp = y0;
                    y0 = y1;
                    y1 = temp;
                }
                int index = this.findStripeIndex(y0);
                if (y0 == y1) continue;
                do {
                    Stripe stripe = this.stripes.get(index);
                    double xBottom = x1;
                    if (y1 != stripe.yMax) {
                        xBottom = x0 + (stripe.yMax - y0) * (x1 - x0) / (y1 - y0);
                    }
                    if (stripe.xTop.size() == 0) {
                        stripe.xTop.add(x0);
                        stripe.xBottom.add(xBottom);
                    } else {
                        int j = 0;
                        double stripe_xTop = Double.MIN_VALUE;
                        for (j = 0; j < stripe.xTop.size() && (this.lt(stripe_xTop = stripe.xTop.get(j).doubleValue(), x0) || !this.gt(stripe_xTop, x0) && !this.lt(xBottom, stripe.xBottom.get(j))); ++j) {
                        }
                        if (j == stripe.xTop.size()) {
                            if (j > 0 && this.ge(xBottom, stripe.xBottom.get(j - 1))) {
                                stripe.xTop.add(x0);
                                stripe.xBottom.add(xBottom);
                            } else {
                                xBottom = this.splitStripe(index, j - 1, x0, xBottom);
                            }
                        } else if (x0 == stripe_xTop) {
                            if (j < stripe.xTop.size() - 1 && this.gt(xBottom, stripe.xBottom.get(j + 1))) {
                                xBottom = this.splitStripe(index, j + 1, x0, xBottom);
                            } else if (j > 0 && this.lt(xBottom, stripe.xBottom.get(j - 1))) {
                                xBottom = this.splitStripe(index, j - 1, x0, xBottom);
                            } else {
                                if (this.gt(xBottom, stripe.xBottom.get(j))) {
                                    ++j;
                                }
                                stripe.xTop.add(j, x0);
                                stripe.xBottom.add(j, xBottom);
                            }
                        } else if (this.gt(xBottom, stripe.xBottom.get(j))) {
                            xBottom = this.splitStripe(index, j, x0, xBottom);
                        } else if (j > 0 && this.lt(xBottom, stripe.xBottom.get(j - 1))) {
                            xBottom = this.splitStripe(index, j - 1, x0, xBottom);
                        } else {
                            stripe.xTop.add(j, x0);
                            stripe.xBottom.add(j, xBottom);
                        }
                    }
                    y0 = stripe.yMax;
                    x0 = xBottom;
                } while (++index < this.stripes.size() && this.gt(y1, this.stripes.get((int)index).yMin));
            }
        }
    }

    private double splitStripe(int stripeIndex, int xIndex, double xTop, double xBottom) {
        double yCross;
        Stripe stripe = this.stripes.get(stripeIndex);
        double stripe_xTop = stripe.xTop.get(xIndex);
        double stripe_xBottom = stripe.xBottom.get(xIndex);
        double yTop = stripe.yMin;
        double yBottom = stripe.yMax;
        double dTop = Math.abs(xTop - stripe_xTop);
        double dBottom = Math.abs(xBottom - stripe_xBottom);
        stripe.yMax = yCross = (yBottom * dTop / dBottom + yTop) / (1.0 + dTop / dBottom);
        Stripe newStripe = new Stripe(yCross, yBottom);
        this.stripes.add(stripeIndex + 1, newStripe);
        for (int i = 0; i < stripe.xTop.size(); ++i) {
            double xT = stripe.xTop.get(i);
            double xB = stripe.xBottom.get(i);
            double xM = xT + (yCross - yTop) * (xB - xT) / (yBottom - yTop);
            stripe.xBottom.set(i, xM);
            newStripe.xTop.add(xM);
            newStripe.xBottom.add(xB);
        }
        xBottom = stripe.xBottom.get(xIndex);
        if (xTop > stripe.xTop.get(xIndex)) {
            ++xIndex;
        }
        stripe.xTop.add(xIndex, xTop);
        stripe.xBottom.add(xIndex, xBottom);
        return xBottom;
    }

    protected int findStripeIndex(double y) {
        if (this.stripes.size() == 0 || this.stripes.get((int)0).yMin > y) {
            return -1;
        }
        int minimum = 0;
        int maximum = this.stripes.size() - 1;
        while (minimum < maximum) {
            int test_index = (minimum + maximum) / 2;
            double yMin = this.stripes.get((int)test_index).yMin;
            if (y == yMin) {
                return test_index;
            }
            if (y > yMin) {
                minimum = test_index + 1;
                continue;
            }
            maximum = test_index;
        }
        if (this.stripes.get((int)minimum).yMin <= y) {
            return minimum;
        }
        return minimum - 1;
    }

    @Override
    protected void getRealExtrema(double[] minima, double[] maxima) {
        Arrays.fill(minima, Double.MAX_VALUE);
        Arrays.fill(maxima, -1.7976931348623157E308);
        for (int i = 0; i < this.points.size(); ++i) {
            RealPoint p = this.points.get(i);
            for (int j = 0; j < 2; ++j) {
                double v = p.getDoublePosition(j);
                if (v < minima[j]) {
                    minima[j] = v;
                }
                if (!(v > maxima[j])) continue;
                maxima[j] = v;
            }
        }
    }

    @Override
    protected void getExtrema(long[] minima, long[] maxima) {
        for (int i = 0; i < 2; ++i) {
            minima[i] = (long)this.realMin(i);
            maxima[i] = (long)this.realMax(i);
        }
    }

    private static long ceil(double x) {
        return (long)Math.ceil((float)x);
    }

    private static long floor(double x) {
        return (long)Math.floor((float)x);
    }

    @Override
    protected boolean nextRaster(long[] position, long[] end) {
        this.validate();
        if (this.stripes.size() == 0) {
            return false;
        }
        long x = position[0];
        long y = position[1];
        Stripe stripe = null;
        int index = 0;
        while (true) {
            if (stripe == null || stripe.yMax < (double)y) {
                index = this.findStripeIndex(y);
                if (index == -1) {
                    stripe = this.stripes.get(0);
                    index = 0;
                    x = Long.MIN_VALUE;
                    y = PolygonRegionOfInterest.ceil(stripe.yMin);
                    continue;
                }
                stripe = this.stripes.get(index);
            }
            if (stripe.yMax <= (double)y) {
                if (this.stripes.size() == index + 1) {
                    if (stripe.yMax == (double)y) {
                        int i;
                        for (i = 0; i < stripe.xBottom.size() && (double)x > stripe.xBottom.get(i + 1); i += 2) {
                        }
                        while (i < stripe.xBottom.size()) {
                            long xRight;
                            long xLeft = PolygonRegionOfInterest.ceil(stripe.xBottom.get(i));
                            if (xLeft < (xRight = PolygonRegionOfInterest.floor(stripe.xBottom.get(i + 1)) + 1L)) {
                                position[0] = xLeft;
                                end[0] = xRight;
                                position[1] = end[1] = y;
                                return true;
                            }
                            i += 2;
                        }
                    }
                    return false;
                }
                stripe = this.stripes.get(++index);
                y = PolygonRegionOfInterest.ceil(stripe.yMin);
                x = Long.MIN_VALUE;
                continue;
            }
            if (stripe.yMin == (double)y && index > 0 && this.stripes.get((int)(index - 1)).yMax == (double)y) {
                int iNext;
                int iPrev;
                ArrayList<Double> prevX = this.stripes.get((int)(index - 1)).xBottom;
                ArrayList<Double> nextX = stripe.xTop;
                for (iPrev = 0; iPrev < prevX.size() && (prevX.get(iPrev) < (double)x || PolygonRegionOfInterest.ceil(prevX.get(iPrev)) == PolygonRegionOfInterest.floor(prevX.get(iPrev + 1)) + 1L); iPrev += 2) {
                }
                for (iNext = 0; iNext < nextX.size() && (nextX.get(iNext) < (double)x || PolygonRegionOfInterest.ceil(nextX.get(iNext)) == PolygonRegionOfInterest.floor(nextX.get(iNext + 1)) + 1L); iNext += 2) {
                }
                if (iPrev == prevX.size() && iNext == nextX.size()) {
                    ++y;
                    x = Long.MIN_VALUE;
                    continue;
                }
                long xLeft = Long.MAX_VALUE;
                long xRight = Long.MIN_VALUE;
                if (iPrev < prevX.size() && iNext == nextX.size()) {
                    xLeft = PolygonRegionOfInterest.ceil(prevX.get(iPrev));
                    xRight = PolygonRegionOfInterest.floor(prevX.get(iPrev + 1)) + 1L;
                } else if (iPrev == prevX.size() && iNext < nextX.size()) {
                    xLeft = PolygonRegionOfInterest.ceil(nextX.get(iNext));
                    xRight = PolygonRegionOfInterest.floor(nextX.get(iNext + 1)) + 1L;
                } else {
                    long xTrailingLeft;
                    ArrayList<Double> trailing;
                    ArrayList<Double> leading;
                    int iTrailing;
                    int iLeading;
                    long xLeftPrev = PolygonRegionOfInterest.ceil(prevX.get(iPrev));
                    long xRightPrev = PolygonRegionOfInterest.floor(prevX.get(iPrev + 1)) + 1L;
                    long xLeftNext = PolygonRegionOfInterest.ceil(nextX.get(iNext));
                    long xRightNext = PolygonRegionOfInterest.floor(nextX.get(iNext + 1)) + 1L;
                    if (xLeftNext < xLeftPrev) {
                        xLeft = xLeftNext;
                        xRight = xRightNext;
                        iLeading = iNext;
                        iTrailing = iPrev;
                        leading = nextX;
                        trailing = prevX;
                    } else {
                        xLeft = xLeftPrev;
                        xRight = xRightPrev;
                        iLeading = iPrev;
                        iTrailing = iNext;
                        leading = prevX;
                        trailing = nextX;
                    }
                    while (iTrailing < trailing.size() && (xTrailingLeft = PolygonRegionOfInterest.ceil(trailing.get(iTrailing))) <= xRight) {
                        xRight = Math.max(xRight, PolygonRegionOfInterest.floor(trailing.get(iTrailing + 1)) + 1L);
                        int temp = iLeading;
                        iLeading = iTrailing;
                        iTrailing = temp + 2;
                        ArrayList<Double> temp2 = leading;
                        leading = trailing;
                        trailing = temp2;
                    }
                }
                position[0] = xLeft;
                end[0] = xRight;
                position[1] = end[1] = y;
                return true;
            }
            boolean inside = false;
            long xInterpolatedLast = Long.MIN_VALUE;
            for (int xIndex = 0; xIndex < stripe.xTop.size(); ++xIndex) {
                double xTop = stripe.xTop.get(xIndex);
                double xBottom = stripe.xBottom.get(xIndex);
                double xInterpolated = xTop + (xBottom - xTop) * ((double)y - stripe.yMin) / (stripe.yMax - stripe.yMin);
                if (!inside) {
                    xInterpolatedLast = PolygonRegionOfInterest.ceil(xInterpolated);
                    inside = true;
                    continue;
                }
                if ((double)x < (xInterpolated = (double)(PolygonRegionOfInterest.floor(xInterpolated) + 1L)) && xInterpolated > (double)xInterpolatedLast) {
                    position[0] = xInterpolatedLast;
                    position[1] = y;
                    end[0] = (long)xInterpolated;
                    end[1] = position[1];
                    return true;
                }
                inside = false;
            }
            ++y;
            x = Long.MIN_VALUE;
        }
    }

    @Override
    public boolean contains(double[] position) {
        this.validate();
        int index = this.findStripeIndex(position[1]);
        if (index == -1) {
            return false;
        }
        Stripe stripe = this.stripes.get(index);
        double y0 = stripe.yMin;
        double y1 = stripe.yMax;
        if (y1 < position[1]) {
            return false;
        }
        boolean is_inside = false;
        for (int i = 0; i < stripe.xTop.size(); ++i) {
            double x1;
            double x0 = stripe.xTop.get(i);
            double x = x0 + (position[1] - y0) * ((x1 = stripe.xBottom.get(i).doubleValue()) - x0) / (y1 - y0);
            if (x == position[0]) {
                return true;
            }
            if (x > position[0]) break;
            is_inside = !is_inside;
        }
        return is_inside;
    }

    public RealLocalizable getEdgeStart(int start) {
        if (start < 0) {
            start = start % this.points.size() + this.points.size();
        } else if (start >= this.points.size()) {
            start %= this.points.size();
        }
        return this.points.get(start);
    }

    public RealLocalizable getEdgeEnd(int start) {
        return this.getEdgeStart(start + 1);
    }

    public boolean isHorizontal(int index) {
        return this.getEdgeStart(index).getDoublePosition(1) == this.getEdgeEnd(index).getDoublePosition(1);
    }

    public double interpolateEdgeXAtY(int start, double y) {
        RealLocalizable p_start = this.getEdgeStart(start);
        RealLocalizable p_end = this.getEdgeEnd(start);
        double x_start = p_start.getDoublePosition(0);
        double y_start = p_start.getDoublePosition(1);
        double x_end = p_end.getDoublePosition(0);
        double y_end = p_end.getDoublePosition(1);
        return x_start + (y - y_start) * (x_end - x_start) / (y_end - y_start);
    }

    protected boolean getEdges(double[] position, double[] x_intercepts) {
        if (x_intercepts == null) {
            x_intercepts = new double[]{-1.7976931348623157E308, Double.MAX_VALUE};
        }
        int count_to_left = 0;
        for (int i = 0; i < this.getVertexCount(); ++i) {
            double y_start = this.getEdgeStart(i).getDoublePosition(1);
            double y_end = this.getEdgeEnd(i).getDoublePosition(1);
            double x_start = this.getEdgeStart(i).getDoublePosition(0);
            double x_end = this.getEdgeEnd(i).getDoublePosition(0);
            if (y_start == y_end) {
                if (y_start != position[1] || !(x_start <= position[0]) || !(x_end >= position[0])) continue;
                x_intercepts[0] = x_start;
                x_intercepts[1] = x_end;
                return true;
            }
            if (Math.signum(y_start - position[1]) * Math.signum(y_end - position[1]) > 0.0) continue;
            double x_intercept = this.interpolateEdgeXAtY(i, position[1]);
            if (x_intercept <= position[0]) {
                ++count_to_left;
                if (!(x_intercept > x_intercepts[0])) continue;
                x_intercepts[0] = x_intercept;
                continue;
            }
            if (!(x_intercept < x_intercepts[1])) continue;
            x_intercepts[1] = x_intercept;
        }
        return count_to_left % 2 == 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int c = 40;
        for (RealPoint p : this.points) {
            sb.append((char)c);
            sb.append(p.toString());
            c = 44;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void move(double displacement, int d) {
        for (RealPoint p : this.points) {
            double currPos = p.getDoublePosition(d);
            p.setPosition(currPos + displacement, d);
        }
        this.invalidateCachedState();
        this.stripes = null;
    }

    protected static class Stripe {
        public final double yMin;
        public double yMax;
        public final ArrayList<Double> xTop = new ArrayList();
        public final ArrayList<Double> xBottom = new ArrayList();

        public Stripe(double yMin, double yMax) {
            this.yMin = yMin;
            this.yMax = yMax;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(String.format("\ny: %.2f<->%.2f", this.yMin, this.yMax));
            for (int i = 0; i < this.xTop.size(); ++i) {
                sb.append(String.format("\n\t%d: %.2f<->%.2f", i, this.xTop.get(i), this.xBottom.get(i)));
            }
            return sb.toString();
        }
    }
}

