/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.test;

import java.util.Random;
import java.util.function.Consumer;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.integer.AbstractIntegerBitType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.integer.UnsignedVariableBitLengthType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;

public class RandomImgs {
    private final Random random;

    public static RandomImgs seed(int seed) {
        return new RandomImgs(seed);
    }

    private RandomImgs(int seed) {
        this.random = new Random(seed);
    }

    public <T extends NativeType<T>> RandomAccessibleInterval<T> nextImage(T type, Interval interval) {
        long[] sizes = Intervals.dimensionsAsLongArray(interval);
        long[] min = Intervals.minAsLongArray(interval);
        return Views.translate(this.nextImage(type, sizes), min);
    }

    public <T extends NativeType<T>> Img<T> nextImage(T type, long ... dims) {
        NativeImg result = new ArrayImgFactory<T>(type).create(dims);
        return this.randomize(result);
    }

    public <I extends RandomAccessibleInterval<T>, T> I randomize(I image) {
        Object type = image.getType();
        Views.iterable(image).forEach(this.randomSetter(type));
        return image;
    }

    private <T> Consumer<T> randomSetter(T type) {
        if (type instanceof UnsignedByteType || type instanceof ByteType || type instanceof ShortType || type instanceof UnsignedShortType || type instanceof IntType) {
            return b -> ((IntegerType)b).setInteger(this.random.nextInt());
        }
        if (type instanceof UnsignedLongType || type instanceof UnsignedIntType || type instanceof AbstractIntegerBitType || type instanceof UnsignedVariableBitLengthType || type instanceof LongType) {
            return b -> ((IntegerType)b).setInteger(this.random.nextLong());
        }
        if (type instanceof ARGBType) {
            return b -> ((ARGBType)b).set(this.random.nextInt());
        }
        if (type instanceof FloatType) {
            return b -> ((FloatType)b).setReal(this.random.nextFloat());
        }
        if (type instanceof DoubleType) {
            return b -> ((DoubleType)b).setReal(this.random.nextDouble());
        }
        throw new UnsupportedOperationException("Randomization of type: " + type.getClass() + " is not supported.");
    }
}

