/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.ui.AbstractInterruptibleProjector;
import net.imglib2.ui.util.StopWatch;

public class SimpleInterruptibleProjector<A, B>
extends AbstractInterruptibleProjector<A, B> {
    protected final RandomAccessible<A> source;
    protected final int numThreads;
    protected final ExecutorService executorService;
    protected long lastFrameRenderNanoTime;
    protected AtomicBoolean interrupted = new AtomicBoolean();

    public SimpleInterruptibleProjector(RandomAccessible<A> source, Converter<? super A, B> converter, RandomAccessibleInterval<B> target, int numThreads) {
        this(source, converter, target, numThreads, null);
    }

    public SimpleInterruptibleProjector(RandomAccessible<A> source, Converter<? super A, B> converter, RandomAccessibleInterval<B> target, int numThreads, ExecutorService executorService) {
        super(source.numDimensions(), converter, target);
        this.source = source;
        this.numThreads = numThreads;
        this.executorService = executorService;
        this.lastFrameRenderNanoTime = -1L;
    }

    @Override
    public boolean map() {
        this.interrupted.set(false);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.min[0] = this.target.min(0);
        this.min[1] = this.target.min(1);
        this.max[0] = this.target.max(0);
        this.max[1] = this.target.max(1);
        final long cr = -this.target.dimension(0);
        final int width = (int)this.target.dimension(0);
        int height = (int)this.target.dimension(1);
        boolean createExecutor = this.executorService == null;
        ExecutorService ex = createExecutor ? Executors.newFixedThreadPool(this.numThreads) : this.executorService;
        int numTasks = this.numThreads > 1 ? Math.min(this.numThreads * 10, height) : 1;
        double taskHeight = (double)height / (double)numTasks;
        ArrayList<1> tasks = new ArrayList<1>(numTasks);
        for (int taskNum = 0; taskNum < numTasks; ++taskNum) {
            final long myMinY = this.min[1] + (long)((int)((double)taskNum * taskHeight));
            final long myHeight = (long)(taskNum == numTasks - 1 ? height : (int)((double)(taskNum + 1) * taskHeight)) - myMinY - this.min[1];
            Callable<Void> r = new Callable<Void>(){

                @Override
                public Void call() {
                    if (SimpleInterruptibleProjector.this.interrupted.get()) {
                        return null;
                    }
                    RandomAccess sourceRandomAccess = SimpleInterruptibleProjector.this.source.randomAccess(SimpleInterruptibleProjector.this);
                    RandomAccess targetRandomAccess = SimpleInterruptibleProjector.this.target.randomAccess(SimpleInterruptibleProjector.this.target);
                    sourceRandomAccess.setPosition(SimpleInterruptibleProjector.this.min);
                    sourceRandomAccess.setPosition(myMinY, 1);
                    targetRandomAccess.setPosition(SimpleInterruptibleProjector.this.min[0], 0);
                    targetRandomAccess.setPosition(myMinY, 1);
                    int y = 0;
                    while ((long)y < myHeight) {
                        if (SimpleInterruptibleProjector.this.interrupted.get()) {
                            return null;
                        }
                        for (int x = 0; x < width; ++x) {
                            SimpleInterruptibleProjector.this.converter.convert(sourceRandomAccess.get(), targetRandomAccess.get());
                            sourceRandomAccess.fwd(0);
                            targetRandomAccess.fwd(0);
                        }
                        sourceRandomAccess.move(cr, 0);
                        targetRandomAccess.move(cr, 0);
                        sourceRandomAccess.fwd(1);
                        targetRandomAccess.fwd(1);
                        ++y;
                    }
                    return null;
                }
            };
            tasks.add(r);
        }
        try {
            ex.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (createExecutor) {
            ex.shutdown();
        }
        this.lastFrameRenderNanoTime = stopWatch.nanoTime();
        return !this.interrupted.get();
    }

    @Override
    public void cancel() {
        this.interrupted.set(true);
    }

    @Override
    public long getLastFrameRenderNanoTime() {
        return this.lastFrameRenderNanoTime;
    }
}

