/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui.viewer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineSet;
import net.imglib2.ui.AffineTransformType;
import net.imglib2.ui.InteractiveDisplayCanvas;
import net.imglib2.ui.PainterThread;
import net.imglib2.ui.Renderer;
import net.imglib2.ui.RendererFactory;
import net.imglib2.ui.TransformListener;
import net.imglib2.ui.overlay.BufferedImageOverlayRenderer;
import net.imglib2.ui.util.GuiUtil;

public class InteractiveRealViewer<A extends AffineSet & AffineGet, C extends JComponent>
implements TransformListener<A>,
PainterThread.Paintable {
    protected final AffineTransformType<A> transformType;
    protected final A viewerTransform;
    protected final C display;
    protected final PainterThread painterThread;
    protected final Renderer<A> imageRenderer;
    protected final JFrame frame;

    public InteractiveRealViewer(AffineTransformType<A> transformType, C interactiveDisplayCanvas, RendererFactory<A> rendererFactory) {
        this.transformType = transformType;
        this.painterThread = new PainterThread(this);
        this.viewerTransform = (AffineSet)transformType.createTransform();
        this.display = interactiveDisplayCanvas;
        ((InteractiveDisplayCanvas)this.display).addTransformListener(this);
        BufferedImageOverlayRenderer target = new BufferedImageOverlayRenderer();
        this.imageRenderer = rendererFactory.create(target, this.painterThread);
        ((InteractiveDisplayCanvas)this.display).addOverlayRenderer(target);
        GraphicsConfiguration gc = GuiUtil.getSuitableGraphicsConfiguration(GuiUtil.RGB_COLOR_MODEL);
        this.frame = new JFrame("ImgLib2", gc);
        this.frame.getRootPane().setDoubleBuffered(true);
        Container content = this.frame.getContentPane();
        content.add((Component)this.display, "Center");
        this.frame.pack();
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                InteractiveRealViewer.this.painterThread.interrupt();
            }
        });
        this.frame.setVisible(true);
        target.setCanvasSize(((JComponent)this.display).getWidth(), ((JComponent)this.display).getHeight());
        this.painterThread.start();
    }

    @Override
    public void paint() {
        this.imageRenderer.paint(this.viewerTransform);
        ((Component)this.display).repaint();
    }

    @Override
    public void transformChanged(A transform) {
        this.transformType.set(this.viewerTransform, transform);
        this.requestRepaint();
    }

    public C getDisplayCanvas() {
        return this.display;
    }

    public void requestRepaint() {
        this.imageRenderer.requestRepaint();
    }

    public JFrame getFrame() {
        return this.frame;
    }
}

