/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.deepicy.tensor;

import icy.sequence.Sequence;
import ij.measure.ResultsTable;
import java.util.HashMap;

public class ImgLib2hapeUtils {
    public static long[] fromSequence(Sequence sequence, int[] tensorDimOrder) {
        long[] dimensionSizes = new long[tensorDimOrder.length];
        for (int i = 0; i < dimensionSizes.length; ++i) {
            int dim = tensorDimOrder[i];
            if (dim == 0) {
                dimensionSizes[i] = sequence.getSizeX();
                continue;
            }
            if (dim == 1) {
                dimensionSizes[i] = sequence.getSizeY();
                continue;
            }
            if (dim == 2) {
                dimensionSizes[i] = sequence.getSizeC();
                continue;
            }
            if (dim == 3) {
                dimensionSizes[i] = sequence.getSizeZ();
                continue;
            }
            if (dim != 4) continue;
            dimensionSizes[i] = sequence.getSizeT();
        }
        return dimensionSizes;
    }

    public static long[] fromArray(int[] shapeArr) {
        long[] dimensionSizes = new long[shapeArr.length];
        for (int i = 0; i < dimensionSizes.length; ++i) {
            dimensionSizes[i] = shapeArr[i];
        }
        return dimensionSizes;
    }

    public static long[] fromResultsTable(ResultsTable table, int[] tensorDimOrder) {
        HashMap<Long, Long> dimsMap = new HashMap<Long, Long>();
        dimsMap.put(2L, (long)table.getLastColumn() + 1L);
        dimsMap.put(3L, Long.valueOf(table.getColumnAsDoubles(0).length));
        dimsMap.put(4L, 1L);
        long[] dimensionSizes = new long[tensorDimOrder.length];
        for (int i = 0; i < dimensionSizes.length; ++i) {
            dimensionSizes[i] = (Long)dimsMap.get(tensorDimOrder[i]);
        }
        return dimensionSizes;
    }
}

