/*
 * Decompiled with CFR 0.152.
 */
package icy.action;

import icy.action.IcyAbstractAction;
import icy.canvas.IcyCanvas;
import icy.gui.viewer.Viewer;
import icy.image.lut.LUT;
import icy.main.Icy;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.util.ClassUtil;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import plugins.kernel.canvas.VtkCanvas;

public class ViewerActions {
    public static IcyAbstractAction duplicateAction = new IcyAbstractAction("Duplicate view", new IcyIcon(ResourceUtil.ICON_PICTURE_COPY), "Duplicate view (no data duplication)", 113){
        private static final long serialVersionUID = -8660425976560135450L;

        @Override
        public boolean doAction(ActionEvent e) {
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Sequence sequence;
                    Viewer viewer = Icy.getMainInterface().getActiveViewer();
                    IcyCanvas canvas = viewer != null ? viewer.getCanvas() : null;
                    Sequence sequence2 = sequence = viewer != null ? viewer.getSequence() : null;
                    if (sequence != null && canvas != null) {
                        Viewer v = new Viewer(sequence);
                        LUT oldLut = viewer.getLut();
                        LUT newLut = v.getLut();
                        if (canvas instanceof VtkCanvas) {
                            newLut.setColorMaps(oldLut, false);
                            newLut.setScalers(oldLut);
                        } else {
                            newLut.copyFrom(oldLut);
                        }
                    }
                }
            });
            return true;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveViewer() != null;
        }
    };

    public static List<IcyAbstractAction> getAllActions() {
        ArrayList<IcyAbstractAction> result = new ArrayList<IcyAbstractAction>();
        Field[] fieldArray = ViewerActions.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Class<?> type = field.getType();
            try {
                if (ClassUtil.isSubClass(type, IcyAbstractAction[].class)) {
                    result.addAll(Arrays.asList((IcyAbstractAction[])field.get(null)));
                } else if (ClassUtil.isSubClass(type, IcyAbstractAction.class)) {
                    result.add((IcyAbstractAction)field.get(null));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return result;
    }
}

