/*
 * Decompiled with CFR 0.152.
 */
package icy.canvas;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvasEvent;
import icy.gui.main.MainFrame;
import icy.gui.viewer.Viewer;
import icy.main.Icy;
import icy.sequence.DimensionId;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public abstract class IcyCanvas2D
extends IcyCanvas {
    private static final long serialVersionUID = 743937493919099495L;
    protected Point2D.Double mouseImagePos;
    protected final AffineTransform transform;
    protected AffineTransform inverseTransform;
    protected boolean transformChanged;

    public IcyCanvas2D(Viewer viewer) {
        super(viewer);
        this.posX = -1;
        this.posY = -1;
        this.posZ = 0;
        this.posT = 0;
        this.mouseImagePos = new Point2D.Double();
        this.transform = new AffineTransform();
        this.inverseTransform = new AffineTransform();
        this.transformChanged = false;
        this.lut.setAlphaToOpaque();
    }

    @Override
    public void setPositionZ(int z) {
        if (z != -1) {
            super.setPositionZ(z);
        }
    }

    @Override
    public void setPositionT(int t) {
        if (t != -1) {
            super.setPositionT(t);
        }
    }

    @Override
    public double getMouseImagePosX() {
        if (this.mouseImagePos == null) {
            return 0.0;
        }
        return this.mouseImagePos.x;
    }

    @Override
    public double getMouseImagePosY() {
        if (this.mouseImagePos == null) {
            return 0.0;
        }
        return this.mouseImagePos.y;
    }

    public Point2D.Double getMouseImagePos() {
        return (Point2D.Double)this.mouseImagePos.clone();
    }

    public void setMouseImagePos(double x, double y) {
        if (this.mouseImagePos.x != x || this.mouseImagePos.y != y) {
            this.mouseImagePos.x = x;
            this.mouseImagePos.y = y;
            this.mousePos = this.imageToCanvas(this.mouseImagePos);
            this.mouseImagePositionChanged(DimensionId.NULL);
        }
    }

    public void setMouseImagePos(Point2D.Double point) {
        this.setMouseImagePos(point.x, point.y);
    }

    @Override
    public boolean setMousePos(int x, int y) {
        boolean result = super.setMousePos(x, y);
        if (result) {
            if (this.mouseImagePos == null) {
                this.mouseImagePos = new Point2D.Double();
            }
            Point2D.Double newPos = this.canvasToImage(this.mousePos);
            double newX = ((Point2D)newPos).getX();
            double newY = ((Point2D)newPos).getY();
            boolean changed = false;
            if (!Double.isNaN(newX) && newX != this.mouseImagePos.x) {
                this.mouseImagePos.x = newX;
                changed = true;
            }
            if (!Double.isNaN(newY) && newY != this.mouseImagePos.y) {
                this.mouseImagePos.y = newY;
                changed = true;
            }
            if (changed) {
                this.mouseImagePositionChanged(DimensionId.NULL);
            }
        }
        return result;
    }

    @Deprecated
    public void setMouseCanvasPos(int x, int y) {
        this.setMousePos(x, y);
    }

    @Deprecated
    public void setMouseCanvasPos(Point point) {
        this.setMousePos(point);
    }

    @Override
    protected void setMouseImagePosXInternal(double value) {
        this.mouseImagePos.x = value;
        this.mousePos = this.imageToCanvas(this.mouseImagePos);
        super.setMouseImagePosXInternal(value);
    }

    @Override
    protected void setMouseImagePosYInternal(double value) {
        this.mouseImagePos.y = value;
        this.mousePos = this.imageToCanvas(this.mouseImagePos);
        super.setMouseImagePosYInternal(value);
    }

    protected Point2D.Double canvasToImageDelta(int x, int y, double scaleX, double scaleY, double rot) {
        double cos = Math.cos(-rot);
        double sin = Math.sin(-rot);
        double resX = (double)x * cos - (double)y * sin;
        double resY = (double)x * sin + (double)y * cos;
        return new Point2D.Double(resX / scaleX, resY / scaleY);
    }

    public Point2D.Double canvasToImageDelta(int x, int y) {
        return this.canvasToImageDelta(x, y, this.getScaleX(), this.getScaleY(), this.getRotationZ());
    }

    public Point2D.Double canvasToImageDelta(Point point) {
        return this.canvasToImageDelta(point.x, point.y);
    }

    public Point2D.Double canvasToImageLogDelta(int x, int y, double logFactor) {
        double sx = this.getScaleX() / Math.pow(10.0, Math.log10(this.getScaleX()) / logFactor);
        double sy = this.getScaleY() / Math.pow(10.0, Math.log10(this.getScaleY()) / logFactor);
        return this.canvasToImageDelta(x, y, sx, sy, this.getRotationZ());
    }

    public Point2D.Double canvasToImageLogDelta(int x, int y) {
        return this.canvasToImageLogDelta(x, y, 5.0);
    }

    protected Point2D.Double canvasToImage(int x, int y, int offsetX, int offsetY, double scaleX, double scaleY, double rot) {
        double canvasCenterX = this.getCanvasSizeX() / 2;
        double canvasCenterY = this.getCanvasSizeY() / 2;
        double dx = (double)x - canvasCenterX;
        double dy = (double)y - canvasCenterY;
        double cos = Math.cos(-rot);
        double sin = Math.sin(-rot);
        double resX = dx * cos - dy * sin;
        double resY = dx * sin + dy * cos;
        resX += canvasCenterX;
        resY += canvasCenterY;
        resX = (resX - (double)offsetX) / scaleX;
        resY = (resY - (double)offsetY) / scaleY;
        return new Point2D.Double(resX, resY);
    }

    public Point2D.Double canvasToImage(int x, int y) {
        Point2D.Double result = new Point2D.Double(0.0, 0.0);
        this.getInverseTransform().transform(new Point2D.Double(x, y), result);
        return result;
    }

    public Point2D.Double canvasToImage(Point point) {
        return this.canvasToImage(point.x, point.y);
    }

    public Rectangle2D.Double canvasToImage(int x, int y, int w, int h) {
        Point2D.Double pt1 = this.canvasToImage(x, y);
        Point2D.Double pt2 = this.canvasToImage(x + w, y);
        Point2D.Double pt3 = this.canvasToImage(x + w, y + h);
        Point2D.Double pt4 = this.canvasToImage(x, y + h);
        double minX = Math.min(pt1.x, Math.min(pt2.x, Math.min(pt3.x, pt4.x)));
        double maxX = Math.max(pt1.x, Math.max(pt2.x, Math.max(pt3.x, pt4.x)));
        double minY = Math.min(pt1.y, Math.min(pt2.y, Math.min(pt3.y, pt4.y)));
        double maxY = Math.max(pt1.y, Math.max(pt2.y, Math.max(pt3.y, pt4.y)));
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public Rectangle2D.Double canvasToImage(Rectangle rect) {
        return this.canvasToImage(rect.x, rect.y, rect.width, rect.height);
    }

    protected Point imageToCanvasDelta(double x, double y, double scaleX, double scaleY, double rot) {
        double dx = x * scaleX;
        double dy = y * scaleY;
        double cos = Math.cos(rot);
        double sin = Math.sin(rot);
        double resX = dx * cos - dy * sin;
        double resY = dx * sin + dy * cos;
        return new Point((int)Math.round(resX), (int)Math.round(resY));
    }

    public Point imageToCanvasDelta(double x, double y) {
        return this.imageToCanvasDelta(x, y, this.getScaleX(), this.getScaleY(), this.getRotationZ());
    }

    public Point imageToCanvasDelta(Point2D.Double point) {
        return this.imageToCanvasDelta(point.x, point.y);
    }

    protected Point imageToCanvas(double x, double y, int offsetX, int offsetY, double scaleX, double scaleY, double rot) {
        double canvasCenterX = this.getCanvasSizeX() / 2;
        double canvasCenterY = this.getCanvasSizeY() / 2;
        double dx = x * scaleX + (double)offsetX - canvasCenterX;
        double dy = y * scaleY + (double)offsetY - canvasCenterY;
        double cos = Math.cos(rot);
        double sin = Math.sin(rot);
        double resX = dx * cos - dy * sin;
        double resY = dx * sin + dy * cos;
        return new Point((int)Math.round(resX += canvasCenterX), (int)Math.round(resY += canvasCenterY));
    }

    public Point imageToCanvas(double x, double y) {
        Point result = new Point();
        this.getTransform().transform(new Point2D.Double(x, y), result);
        return result;
    }

    public Point imageToCanvas(Point2D.Double point) {
        return this.imageToCanvas(point.x, point.y);
    }

    public Rectangle imageToCanvas(double x, double y, double w, double h) {
        Point pt1 = this.imageToCanvas(x, y);
        Point pt2 = this.imageToCanvas(x + w, y);
        Point pt3 = this.imageToCanvas(x + w, y + h);
        Point pt4 = this.imageToCanvas(x, y + h);
        int minX = Math.min(pt1.x, Math.min(pt2.x, Math.min(pt3.x, pt4.x)));
        int maxX = Math.max(pt1.x, Math.max(pt2.x, Math.max(pt3.x, pt4.x)));
        int minY = Math.min(pt1.y, Math.min(pt2.y, Math.min(pt3.y, pt4.y)));
        int maxY = Math.max(pt1.y, Math.max(pt2.y, Math.max(pt3.y, pt4.y)));
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    public Rectangle imageToCanvas(Rectangle2D.Double rect) {
        return this.imageToCanvas(rect.x, rect.y, rect.width, rect.height);
    }

    public Dimension getCanvasSize() {
        return new Dimension(this.getCanvasSizeX(), this.getCanvasSizeY());
    }

    public Dimension getImageSize() {
        return new Dimension(this.getImageSizeX(), this.getImageSizeY());
    }

    public Dimension getImageCanvasSize() {
        double imageSizeX = this.getImageSizeX();
        double imageSizeY = this.getImageSizeY();
        double scaleX = this.getScaleX();
        double scaleY = this.getScaleY();
        double rot = this.getRotationZ();
        Point pt1 = this.imageToCanvas(0.0, 0.0, 0, 0, scaleX, scaleY, rot);
        Point pt2 = this.imageToCanvas(imageSizeX, 0.0, 0, 0, scaleX, scaleY, rot);
        Point pt3 = this.imageToCanvas(0.0, imageSizeY, 0, 0, scaleX, scaleY, rot);
        Point pt4 = this.imageToCanvas(imageSizeX, imageSizeY, 0, 0, scaleX, scaleY, rot);
        int minX = Math.min(pt1.x, Math.min(pt2.x, Math.min(pt3.x, pt4.x)));
        int maxX = Math.max(pt1.x, Math.max(pt2.x, Math.max(pt3.x, pt4.x)));
        int minY = Math.min(pt1.y, Math.min(pt2.y, Math.min(pt3.y, pt4.y)));
        int maxY = Math.max(pt1.y, Math.max(pt2.y, Math.max(pt3.y, pt4.y)));
        return new Dimension(maxX - minX, maxY - minY);
    }

    public Rectangle getCanvasVisibleRect() {
        Component comp = this.getViewComponent();
        if (comp instanceof JComponent) {
            return ((JComponent)comp).getVisibleRect();
        }
        return this.getVisibleRect();
    }

    public Rectangle2D getImageVisibleRect() {
        return this.canvasToImage(this.getCanvasVisibleRect());
    }

    public void centerOn(Rectangle region) {
    }

    public void centerOnImage(double x, double y) {
        Point pt = this.imageToCanvas(x, y);
        int canvasCenterX = this.getCanvasSizeX() / 2;
        int canvasCenterY = this.getCanvasSizeY() / 2;
        Point2D.Double newTrans = this.canvasToImageDelta(canvasCenterX - pt.x, canvasCenterY - pt.y, 1.0, 1.0, this.getRotationZ());
        this.setOffsetX(this.getOffsetX() + (int)Math.round(newTrans.x));
        this.setOffsetY(this.getOffsetY() + (int)Math.round(newTrans.y));
    }

    public void centerOnImage(Point2D.Double pt) {
        this.centerOnImage(pt.x, pt.y);
    }

    public void centerImage() {
        this.centerOnImage(this.getImageSizeX() / 2, this.getImageSizeY() / 2);
    }

    protected Point2D.Double getFitImageToCanvasScale() {
        double imageSizeX = this.getImageSizeX();
        double imageSizeY = this.getImageSizeY();
        if (imageSizeX > 0.0 && imageSizeY > 0.0) {
            double rot = this.getRotationZ();
            Point pt1 = this.imageToCanvas(0.0, 0.0, 0, 0, 1.0, 1.0, rot);
            Point pt2 = this.imageToCanvas(imageSizeX, 0.0, 0, 0, 1.0, 1.0, rot);
            Point pt3 = this.imageToCanvas(0.0, imageSizeY, 0, 0, 1.0, 1.0, rot);
            Point pt4 = this.imageToCanvas(imageSizeX, imageSizeY, 0, 0, 1.0, 1.0, rot);
            int minX = Math.min(pt1.x, Math.min(pt2.x, Math.min(pt3.x, pt4.x)));
            int maxX = Math.max(pt1.x, Math.max(pt2.x, Math.max(pt3.x, pt4.x)));
            int minY = Math.min(pt1.y, Math.min(pt2.y, Math.min(pt3.y, pt4.y)));
            int maxY = Math.max(pt1.y, Math.max(pt2.y, Math.max(pt3.y, pt4.y)));
            double sx = (double)this.getCanvasSizeX() / (double)(maxX - minX);
            double sy = (double)this.getCanvasSizeY() / (double)(maxY - minY);
            return new Point2D.Double(sx, sy);
        }
        return null;
    }

    public void fitImageToCanvas() {
        Point2D.Double s = this.getFitImageToCanvasScale();
        if (s != null) {
            double scale = Math.min(s.x, s.y);
            this.setScaleX(scale);
            this.setScaleY(scale);
        }
    }

    public void fitCanvasToImage() {
        MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
        Dimension imageCanvasSize = this.getImageCanvasSize();
        if (imageCanvasSize.width > 0 && imageCanvasSize.height > 0 && mainFrame != null) {
            Dimension maxDim = mainFrame.getDesktopSize();
            Dimension adjImgCnvSize = this.canvasToViewer(imageCanvasSize);
            this.viewer.setSize(Math.min(adjImgCnvSize.width, maxDim.width), Math.min(adjImgCnvSize.height, maxDim.height));
        }
    }

    public Dimension canvasToViewer(Dimension dim) {
        Dimension canvasViewSize = this.getCanvasSize();
        Dimension viewerSize = this.viewer.getSize();
        Dimension result = new Dimension(dim);
        result.width -= canvasViewSize.width;
        result.width += viewerSize.width;
        result.height -= canvasViewSize.height;
        result.height += viewerSize.height;
        return result;
    }

    public Dimension viewerToCanvas(Dimension dim) {
        Dimension canvasViewSize = this.getCanvasSize();
        Dimension viewerSize = this.viewer.getSize();
        Dimension result = new Dimension(dim);
        result.width -= viewerSize.width;
        result.width += canvasViewSize.width;
        result.height -= viewerSize.height;
        result.height += canvasViewSize.height;
        return result;
    }

    protected void updateTransform() {
        int canvasCenterX = this.getCanvasSizeX() / 2;
        int canvasCenterY = this.getCanvasSizeY() / 2;
        this.transform.setToTranslation(canvasCenterX, canvasCenterY);
        this.transform.rotate(this.getRotationZ());
        this.transform.translate(-canvasCenterX, -canvasCenterY);
        this.transform.translate(this.getOffsetX(), this.getOffsetY());
        this.transform.scale(this.getScaleX(), this.getScaleY());
        this.transformChanged = true;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public AffineTransform getInverseTransform() {
        if (this.transformChanged) {
            try {
                this.inverseTransform = this.transform.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                this.inverseTransform = new AffineTransform();
            }
            this.transformChanged = false;
        }
        return this.inverseTransform;
    }

    @Override
    public void changed(IcyCanvasEvent event) {
        super.changed(event);
        switch (event.getType()) {
            case OFFSET_CHANGED: 
            case SCALE_CHANGED: 
            case ROTATION_CHANGED: {
                this.updateTransform();
            }
        }
    }
}

