/*
 * Decompiled with CFR 0.152.
 */
package icy.canvas;

import icy.main.Icy;
import icy.painter.Overlay;
import icy.painter.OverlayEvent;
import icy.painter.OverlayListener;
import icy.painter.OverlayWrapper;
import icy.painter.Painter;
import icy.painter.WeakOverlayListener;
import icy.roi.ROI;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class Layer
implements OverlayListener,
Comparable<Layer> {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_PRIORITY = "priority";
    public static final String PROPERTY_READONLY = "readOnly";
    public static final String PROPERTY_CANBEREMOVED = "canBeRemoved";
    public static final String PROPERTY_RECEIVEKEYEVENTONHIDDEN = "receiveKeyEventOnHidden";
    public static final String PROPERTY_RECEIVEMOUSEEVENTONHIDDEN = "receiveMouseEventOnHidden";
    @Deprecated
    public static final String PROPERTY_ALPHA = "alpha";
    public static final String PROPERTY_OPACITY = "opacity";
    public static final String PROPERTY_VISIBLE = "visible";
    public static final String DEFAULT_NAME = "layer";
    private final Overlay overlay;
    private WeakReference<ROI> roi;
    private boolean visible;
    private float alpha;
    protected final List<LayerListener> listeners;

    public static boolean isPaintProperty(String propertyName) {
        if (propertyName == null) {
            return false;
        }
        return propertyName.equals(PROPERTY_OPACITY) || propertyName.equals(PROPERTY_PRIORITY) || propertyName.equals(PROPERTY_VISIBLE);
    }

    static Overlay createOverlayWrapper(Painter painter, String name) {
        if (painter instanceof Overlay) {
            return (Overlay)painter;
        }
        OverlayWrapper result = new OverlayWrapper(painter, name);
        if (name == null) {
            result.setName(DEFAULT_NAME);
        }
        result.setPriority(Overlay.OverlayPriority.SHAPE_NORMAL);
        return result;
    }

    public Layer(Overlay overlay) {
        this.overlay = overlay;
        overlay.addOverlayListener(new WeakOverlayListener(this));
        this.visible = true;
        this.alpha = 1.0f;
        this.roi = null;
        this.listeners = new ArrayList<LayerListener>();
    }

    @Deprecated
    public Layer(Painter painter, String name) {
        this(Layer.createOverlayWrapper(painter, name));
    }

    @Deprecated
    public Layer(Painter painter) {
        this(painter, null);
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    @Deprecated
    public Painter getPainter() {
        Overlay result = this.getOverlay();
        if (result instanceof OverlayWrapper) {
            return ((OverlayWrapper)result).getPainter();
        }
        return result;
    }

    public Overlay.OverlayPriority getPriority() {
        return this.overlay.getPriority();
    }

    public void setPriority(Overlay.OverlayPriority priority) {
        this.overlay.setPriority(priority);
    }

    public String getName() {
        return this.overlay.getName();
    }

    public void setName(String name) {
        this.overlay.setName(name);
    }

    public boolean isReadOnly() {
        return this.overlay.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.overlay.setReadOnly(readOnly);
    }

    @Deprecated
    public boolean isFixed() {
        return !this.getCanBeRemoved();
    }

    @Deprecated
    public void setFixed(boolean value) {
        this.setCanBeRemoved(value);
    }

    public boolean getCanBeRemoved() {
        return this.overlay.getCanBeRemoved();
    }

    public void setCanBeRemoved(boolean value) {
        this.overlay.setCanBeRemoved(value);
    }

    public boolean getReceiveKeyEventOnHidden() {
        return this.overlay.getReceiveKeyEventOnHidden();
    }

    public void setReceiveKeyEventOnHidden(boolean value) {
        this.overlay.setReceiveKeyEventOnHidden(value);
    }

    public boolean getReceiveMouseEventOnHidden() {
        return this.overlay.getReceiveMouseEventOnHidden();
    }

    public void setReceiveMouseEventOnHidden(boolean value) {
        this.overlay.setReceiveMouseEventOnHidden(value);
    }

    public ROI getAttachedROI() {
        if (this.roi == null) {
            this.roi = new WeakReference<ROI>(Icy.getMainInterface().getROI(this.overlay));
        }
        return (ROI)this.roi.get();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            this.changed(PROPERTY_VISIBLE);
        }
    }

    public float getOpacity() {
        return this.alpha;
    }

    public void setOpacity(float value) {
        if (this.alpha != value) {
            this.alpha = value;
            this.changed(PROPERTY_OPACITY);
        }
    }

    @Deprecated
    public float getAlpha() {
        return this.getOpacity();
    }

    @Deprecated
    public void setAlpha(float value) {
        this.setOpacity(value);
    }

    protected void changed(String propertyName) {
        this.fireChangedEvent(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangedEvent(String propertyName) {
        ArrayList<LayerListener> list;
        List<LayerListener> list2 = this.listeners;
        synchronized (list2) {
            list = new ArrayList<LayerListener>(this.listeners);
        }
        for (LayerListener listener : list) {
            listener.layerChanged(this, propertyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(LayerListener listener) {
        List<LayerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(LayerListener listener) {
        List<LayerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void overlayChanged(OverlayEvent event) {
        if (event.getType() == OverlayEvent.OverlayEventType.PROPERTY_CHANGED) {
            this.changed(event.getPropertyName());
        }
    }

    @Override
    public int compareTo(Layer layer) {
        return this.getOverlay().compareTo(layer.getOverlay());
    }

    public static interface LayerListener {
        public void layerChanged(Layer var1, String var2);
    }
}

