/*
 * Decompiled with CFR 0.152.
 */
package icy.file;

import icy.file.FileFormat;
import loci.formats.gui.ExtensionFileFilter;

public enum ImageFileFormat {
    TIFF{

        @Override
        public String[] getExtensions() {
            return new String[]{"tif", "tiff"};
        }

        @Override
        public String getDescription() {
            return "TIFF images";
        }

        @Override
        public boolean canRead() {
            return true;
        }

        @Override
        public boolean canWrite() {
            return true;
        }

        @Override
        public FileFormat toFileFormat() {
            return FileFormat.TIFF;
        }
    }
    ,
    PNG{

        @Override
        public String[] getExtensions() {
            return new String[]{"png"};
        }

        @Override
        public String getDescription() {
            return "PNG images";
        }

        @Override
        public boolean canRead() {
            return true;
        }

        @Override
        public boolean canWrite() {
            return true;
        }

        @Override
        public FileFormat toFileFormat() {
            return FileFormat.PNG;
        }
    }
    ,
    LSM{

        @Override
        public String[] getExtensions() {
            return new String[]{"lsm"};
        }

        @Override
        public String getDescription() {
            return "LSM images";
        }

        @Override
        public boolean canRead() {
            return true;
        }

        @Override
        public boolean canWrite() {
            return false;
        }

        @Override
        public FileFormat toFileFormat() {
            return FileFormat.LSM;
        }
    }
    ,
    JPG{

        @Override
        public String[] getExtensions() {
            return new String[]{"jpg", "jpeg"};
        }

        @Override
        public String getDescription() {
            return "JPG images";
        }

        @Override
        public boolean canRead() {
            return true;
        }

        @Override
        public boolean canWrite() {
            return true;
        }

        @Override
        public FileFormat toFileFormat() {
            return FileFormat.JPG;
        }
    }
    ,
    AVI{

        @Override
        public String[] getExtensions() {
            return new String[]{"avi"};
        }

        @Override
        public String getDescription() {
            return "AVI sequences";
        }

        @Override
        public boolean canRead() {
            return true;
        }

        @Override
        public boolean canWrite() {
            return true;
        }

        @Override
        public FileFormat toFileFormat() {
            return FileFormat.AVI;
        }
    };


    private ImageFileFormat() {
    }

    public abstract boolean canRead();

    public abstract boolean canWrite();

    public String getDescription() {
        return "unknow";
    }

    public String[] getExtensions() {
        return new String[]{""};
    }

    public abstract FileFormat toFileFormat();

    public ExtensionFileFilter getExtensionFileFilter() {
        return new ExtensionFileFilter(this.getExtensions(), this.getDescription());
    }

    public boolean matches(String ext) {
        if (ext == null) {
            return false;
        }
        String extLC = ext.toLowerCase();
        String[] stringArray = this.getExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (e.equals(extLC)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ImageFileFormat getFormat(String ext, ImageFileFormat defaultValue) {
        ImageFileFormat[] imageFileFormatArray = ImageFileFormat.values();
        int n = imageFileFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFileFormat iff = imageFileFormatArray[n2];
            if (iff.matches(ext)) {
                return iff;
            }
            ++n2;
        }
        return defaultValue;
    }

    public static ImageFileFormat getReadFormat(String ext, ImageFileFormat defaultValue) {
        ImageFileFormat[] imageFileFormatArray = ImageFileFormat.values();
        int n = imageFileFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFileFormat iff = imageFileFormatArray[n2];
            if (iff.canRead() && iff.matches(ext)) {
                return iff;
            }
            ++n2;
        }
        return defaultValue;
    }

    public static ImageFileFormat getWriteFormat(String ext, ImageFileFormat defaultValue) {
        ImageFileFormat[] imageFileFormatArray = ImageFileFormat.values();
        int n = imageFileFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFileFormat iff = imageFileFormatArray[n2];
            if (iff.canWrite() && iff.matches(ext)) {
                return iff;
            }
            ++n2;
        }
        return defaultValue;
    }

    public static ImageFileFormat getFormat(FileFormat format) {
        switch (format) {
            case AVI: {
                return AVI;
            }
            case JPG: {
                return JPG;
            }
            case LSM: {
                return LSM;
            }
            case PNG: {
                return PNG;
            }
        }
        return TIFF;
    }

    /* synthetic */ ImageFileFormat(String string, int n, ImageFileFormat imageFileFormat) {
        this();
    }
}

