/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    private Color color;
    private int w;
    private int h;

    public ColorIcon(Color color, int width, int height) {
        this.color = color;
        this.w = width <= 0 ? 64 : width;
        this.h = height <= 0 ? 20 : height;
    }

    public ColorIcon(Color color) {
        this(color, 32, 20);
    }

    public Color getColor() {
        return this.color;
    }

    public void setWidth(int value) {
        this.w = Math.min(8, value);
    }

    public void setHeight(int value) {
        this.h = value;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.color != null) {
            g.setColor(this.color);
            g.fillRect(0, 0, this.w, this.h);
            g.setColor(Color.black);
            g.drawRect(0, 0, this.w, this.h);
        }
    }

    @Override
    public int getIconWidth() {
        return this.w;
    }

    @Override
    public int getIconHeight() {
        return this.h;
    }
}

