/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import icy.gui.component.IcyTextField;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class NumberTextField
extends IcyTextField {
    private static final long serialVersionUID = 3043750422009529874L;
    protected double value = 0.0;
    protected boolean integer;
    protected List<ValueChangeListener> listeners;

    public NumberTextField(boolean integer) {
        this.integer = integer;
        this.listeners = new ArrayList<ValueChangeListener>();
    }

    public NumberTextField() {
        this(false);
    }

    public boolean isInteger() {
        return this.integer;
    }

    public void setInteger(boolean integer) {
        this.integer = integer;
        this.setNumericValue(this.value);
    }

    public void addValueListener(ValueChangeListener l) {
        this.listeners.add(l);
    }

    public void removeValueListener(ValueChangeListener l) {
        this.listeners.remove(l);
    }

    public double getNumericValue() {
        return this.value;
    }

    public void setNumericValue(double value) {
        if (this.integer) {
            this.setText(Integer.toString((int)value));
        } else {
            this.setText(Double.toString(value));
        }
    }

    protected void valueChanged(boolean validate) {
        this.fireValueChangedEvent(validate);
    }

    @Override
    protected void textChanged(boolean validate) {
        super.textChanged(validate);
        double oldValue = this.value;
        try {
            String text = this.getText();
            double d = this.value = text.isEmpty() ? 0.0 : Double.parseDouble(text);
            if (this.integer) {
                this.value = (int)this.value;
            }
            this.setForeground(Color.BLACK);
        }
        catch (NumberFormatException err) {
            this.setForeground(Color.RED);
        }
        if (validate) {
            this.valueChanged(validate);
        } else if (this.value != oldValue) {
            this.valueChanged(false);
        }
    }

    private void fireValueChangedEvent(boolean validate) {
        for (ValueChangeListener l : this.listeners) {
            l.valueChanged(this.value, validate);
        }
    }

    public static interface ValueChangeListener {
        public void valueChanged(double var1, boolean var3);
    }
}

