/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.ui;

import icy.gui.component.RangeSlider;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.ClassicFillPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.ui.SubstanceSliderUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.RolloverControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class RangeSliderUI
extends SubstanceSliderUI {
    Rectangle upperThumbRect;
    boolean upperThumbSelected;
    transient boolean lowerDragging;
    transient boolean upperDragging;
    ButtonModel sliderModel = new DefaultButtonModel();
    ButtonModel upperThumbModel;
    protected StateTransitionTracker sliderStateTransitionTracker;
    protected StateTransitionTracker upperThumbStateTransitionTracker;
    protected RolloverControlListener sliderRolloverListener;
    protected RolloverControlListener upperThumbRolloverListener;
    protected PropertyChangeListener sliderPropertyChangeListener;
    private boolean paintingLowerThumb;
    private boolean paintingUpperThumb;

    public RangeSliderUI(RangeSlider rangeSlider) {
        super((JSlider)rangeSlider);
        this.sliderModel.setArmed(false);
        this.sliderModel.setSelected(false);
        this.sliderModel.setPressed(false);
        this.sliderModel.setRollover(false);
        this.sliderModel.setEnabled(rangeSlider.isEnabled());
        this.upperThumbModel = new DefaultButtonModel();
        this.upperThumbModel.setArmed(false);
        this.upperThumbModel.setSelected(false);
        this.upperThumbModel.setPressed(false);
        this.upperThumbModel.setRollover(false);
        this.upperThumbModel.setEnabled(rangeSlider.isEnabled());
        this.sliderStateTransitionTracker = new StateTransitionTracker((JComponent)rangeSlider, this.sliderModel);
        this.upperThumbStateTransitionTracker = new StateTransitionTracker((JComponent)rangeSlider, this.upperThumbModel);
        this.paintingLowerThumb = false;
        this.paintingUpperThumb = false;
    }

    public void installUI(JComponent c) {
        this.upperThumbRect = new Rectangle();
        super.installUI(c);
    }

    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        this.sliderRolloverListener = new RolloverControlListener(new TransitionAwareUI(){

            public boolean isInside(MouseEvent me) {
                double y;
                double x = me.getX();
                return RangeSliderUI.this.isInsideLowerThumbInternal(x, y = (double)me.getY()) || RangeSliderUI.this.isInsideUpperThumbInternal(x, y);
            }

            public StateTransitionTracker getTransitionTracker() {
                return RangeSliderUI.this.sliderStateTransitionTracker;
            }
        }, this.sliderModel);
        slider.addMouseListener((MouseListener)this.sliderRolloverListener);
        slider.addMouseMotionListener((MouseMotionListener)this.sliderRolloverListener);
        this.upperThumbRolloverListener = new RolloverControlListener(new TransitionAwareUI(){

            public boolean isInside(MouseEvent me) {
                return RangeSliderUI.this.isInsideUpperThumb(me.getX(), me.getY());
            }

            public StateTransitionTracker getTransitionTracker() {
                return RangeSliderUI.this.upperThumbStateTransitionTracker;
            }
        }, this.upperThumbModel);
        slider.addMouseListener((MouseListener)this.upperThumbRolloverListener);
        slider.addMouseMotionListener((MouseMotionListener)this.upperThumbRolloverListener);
        this.sliderPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    boolean enabled = RangeSliderUI.this.slider.isEnabled();
                    RangeSliderUI.this.sliderModel.setEnabled(enabled);
                    RangeSliderUI.this.upperThumbModel.setEnabled(enabled);
                }
            }
        };
        slider.addPropertyChangeListener(this.sliderPropertyChangeListener);
        this.sliderStateTransitionTracker.registerModelListeners();
        this.sliderStateTransitionTracker.registerFocusListeners();
        this.upperThumbStateTransitionTracker.registerModelListeners();
        this.upperThumbStateTransitionTracker.registerFocusListeners();
    }

    protected void uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener((MouseListener)this.sliderRolloverListener);
        slider.removeMouseMotionListener((MouseMotionListener)this.sliderRolloverListener);
        this.sliderRolloverListener = null;
        slider.removeMouseListener((MouseListener)this.upperThumbRolloverListener);
        slider.removeMouseMotionListener((MouseMotionListener)this.upperThumbRolloverListener);
        this.upperThumbRolloverListener = null;
        slider.removePropertyChangeListener(this.sliderPropertyChangeListener);
        this.sliderPropertyChangeListener = null;
        this.sliderStateTransitionTracker.unregisterModelListeners();
        this.sliderStateTransitionTracker.unregisterFocusListeners();
        this.upperThumbStateTransitionTracker.unregisterModelListeners();
        this.upperThumbStateTransitionTracker.unregisterFocusListeners();
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new RangeTrackListener();
    }

    protected ChangeListener createChangeListener(JSlider slider) {
        return new ChangeHandler();
    }

    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.upperThumbRect.setSize(this.thumbRect.width, this.thumbRect.height);
    }

    protected void calculateThumbLocation() {
        int valuePosition;
        super.calculateThumbLocation();
        if (this.slider.getSnapToTicks()) {
            int upperValue;
            int snappedValue = upperValue = this.slider.getValue() + this.slider.getExtent();
            int majorTickSpacing = this.slider.getMajorTickSpacing();
            int minorTickSpacing = this.slider.getMinorTickSpacing();
            int tickSpacing = 0;
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0) {
                if ((upperValue - this.slider.getMinimum()) % tickSpacing != 0) {
                    float temp = (float)(upperValue - this.slider.getMinimum()) / (float)tickSpacing;
                    int whichTick = Math.round(temp);
                    snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
                }
                if (snappedValue != upperValue) {
                    this.slider.setExtent(snappedValue - this.slider.getValue());
                }
            }
        }
        Rectangle trackRect = this.getPaintTrackRect();
        if (this.slider.getOrientation() == 0) {
            valuePosition = this.xPositionForValue(this.slider.getValue() + this.slider.getExtent());
            double centerY = (double)trackRect.y + (double)trackRect.height / 2.0;
            this.upperThumbRect.y = (int)(centerY - (double)this.upperThumbRect.height / 2.0) + 1;
            this.upperThumbRect.x = valuePosition - this.upperThumbRect.width / 2;
        } else {
            valuePosition = this.yPositionForValue(this.slider.getValue() + this.slider.getExtent());
            double centerX = (double)trackRect.x + (double)trackRect.width / 2.0;
            this.upperThumbRect.x = (int)(centerX - (double)this.upperThumbRect.width / 2.0) + 1;
            this.upperThumbRect.y = valuePosition - this.upperThumbRect.height / 2;
        }
    }

    public boolean isInside(MouseEvent me) {
        return this.isInsideLowerThumb(me.getX(), me.getY());
    }

    public boolean isInsideLowerThumbInternal(double x, double y) {
        Rectangle thumbB = this.thumbRect;
        return thumbB != null && thumbB.contains(x, y);
    }

    public boolean isInsideLowerThumb(double x, double y) {
        if (this.isInsideLowerThumbInternal(x, y)) {
            if (this.isInsideUpperThumbInternal(x, y)) {
                double du;
                double dl = Point2D.distance(this.thumbRect.getCenterX(), this.thumbRect.getCenterY(), x, y);
                return dl < (du = Point2D.distance(this.upperThumbRect.getCenterX(), this.upperThumbRect.getCenterY(), x, y));
            }
            return true;
        }
        return false;
    }

    public boolean isInsideUpperThumbInternal(double x, double y) {
        Rectangle upperThumbR = this.upperThumbRect;
        return upperThumbR != null && upperThumbR.contains(x, y);
    }

    public boolean isInsideUpperThumb(double x, double y) {
        if (this.isInsideUpperThumbInternal(x, y)) {
            if (this.isInsideLowerThumbInternal(x, y)) {
                double dl = Point2D.distance(this.thumbRect.getCenterX(), this.thumbRect.getCenterY(), x, y);
                double du = Point2D.distance(this.upperThumbRect.getCenterX(), this.upperThumbRect.getCenterY(), x, y);
                return du <= dl;
            }
            return true;
        }
        return false;
    }

    public StateTransitionTracker getTransitionTracker() {
        if (this.paintingLowerThumb) {
            return super.getTransitionTracker();
        }
        if (this.paintingUpperThumb) {
            return this.upperThumbStateTransitionTracker;
        }
        return this.sliderStateTransitionTracker;
    }

    private Rectangle getPaintTrackRect() {
        int trackRight;
        int trackLeft = 0;
        int trackTop = 0;
        int trackWidth = this.getTrackWidth();
        if (this.slider.getOrientation() == 0) {
            trackTop = 3 + this.insetCache.top + 2 * this.focusInsets.top;
            int trackBottom = trackTop + trackWidth - 1;
            int trackRight2 = this.trackRect.width;
            return new Rectangle(this.trackRect.x + trackLeft, trackTop, trackRight2 - trackLeft, trackBottom - trackTop);
        }
        if (this.slider.getPaintLabels() || this.slider.getPaintTicks()) {
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                trackLeft = this.trackRect.x + this.insetCache.left + this.focusInsets.left;
                trackRight = trackLeft + trackWidth - 1;
            } else {
                trackRight = this.trackRect.x + this.trackRect.width - this.insetCache.right - this.focusInsets.right;
                trackLeft = trackRight - trackWidth - 1;
            }
        } else if (this.slider.getComponentOrientation().isLeftToRight()) {
            trackLeft = (this.insetCache.left + this.focusInsets.left + this.slider.getWidth() - this.insetCache.right - this.focusInsets.right) / 2 - trackWidth / 2;
            trackRight = trackLeft + trackWidth - 1;
        } else {
            trackRight = (this.insetCache.left + this.focusInsets.left + this.slider.getWidth() - this.insetCache.right - this.focusInsets.right) / 2 + trackWidth / 2;
            trackLeft = trackRight - trackWidth - 1;
        }
        int trackBottom = this.trackRect.height - 1;
        return new Rectangle(trackLeft, this.trackRect.y + trackTop, trackRight - trackLeft, trackBottom - trackTop);
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        ComponentState currState = ComponentState.getState((ButtonModel)this.sliderModel, (JComponent)this.slider);
        float alpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.slider, (ComponentState)currState);
        BackgroundPaintingUtils.updateIfOpaque((Graphics)graphics, (Component)c);
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle clip = graphics.getClipBounds();
        if (!clip.intersects(this.trackRect) && this.slider.getPaintTrack()) {
            this.calculateGeometry();
        }
        graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.slider, (float)alpha, (Graphics)g));
        if (this.slider.getPaintTrack() && clip.intersects(this.trackRect)) {
            this.paintTrack(graphics);
        }
        if (this.slider.getPaintTicks() && clip.intersects(this.tickRect)) {
            this.paintTicks(graphics);
        }
        if (clip.intersects(this.thumbRect)) {
            this.paintLowerThumb(graphics);
        }
        if (clip.intersects(this.upperThumbRect)) {
            this.paintUpperThumb(graphics);
        }
        graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.slider, (float)1.0f, (Graphics)g));
        if (this.slider.getPaintLabels() && clip.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
        graphics.dispose();
    }

    public void paintLowerThumb(Graphics g) {
        this.paintingLowerThumb = true;
        this.paintThumb(g);
        this.paintingLowerThumb = false;
    }

    public void paintUpperThumb(Graphics g) {
        this.paintingUpperThumb = true;
        Graphics2D graphics = (Graphics2D)g.create();
        Rectangle knobBounds = this.upperThumbRect;
        graphics.translate(knobBounds.x, knobBounds.y);
        Icon icon = this.getIcon();
        if (this.slider.getOrientation() == 0) {
            if (icon != null) {
                icon.paintIcon(this.slider, graphics, -1, 0);
            }
        } else if (this.slider.getComponentOrientation().isLeftToRight()) {
            if (icon != null) {
                icon.paintIcon(this.slider, graphics, 0, -1);
            }
        } else if (icon != null) {
            icon.paintIcon(this.slider, graphics, 0, 1);
        }
        graphics.dispose();
        this.paintingUpperThumb = false;
    }

    public void paintTrack(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        boolean drawInverted = this.drawInverted();
        Rectangle paintRect = this.getPaintTrackRect();
        int width = paintRect.width;
        int height = paintRect.height;
        if (this.slider.getOrientation() == 1) {
            int temp = width;
            width = height;
            height = temp;
            AffineTransform at = graphics.getTransform();
            at.translate(paintRect.x, width + paintRect.y);
            at.rotate(-1.5707963267948966);
            graphics.setTransform(at);
        } else {
            graphics.translate(paintRect.x, paintRect.y);
        }
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.sliderStateTransitionTracker.getModelStateInfo();
        SubstanceColorScheme trackSchemeUnselected = SubstanceColorSchemeUtilities.getColorScheme((Component)this.slider, (ComponentState)(this.slider.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED));
        SubstanceColorScheme trackBorderSchemeUnselected = SubstanceColorSchemeUtilities.getColorScheme((Component)this.slider, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)(this.slider.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED));
        this.paintSliderTrack(graphics, drawInverted, trackSchemeUnselected, trackBorderSchemeUnselected, width, height);
        Map activeStates = modelStateInfo.getStateContributionMap();
        for (Map.Entry activeEntry : activeStates.entrySet()) {
            float contribution;
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            if (!activeState.isActive() || (contribution = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution()) == 0.0f) continue;
            graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.slider, (float)contribution, (Graphics)g));
            SubstanceColorScheme activeFillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.slider, (ComponentState)activeState);
            SubstanceColorScheme activeBorderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.slider, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)activeState);
            this.paintSliderTrackSelected(graphics, paintRect, activeFillScheme, activeBorderScheme, width, height);
        }
        graphics.dispose();
    }

    private void paintSliderTrack(Graphics2D graphics, boolean drawInverted, SubstanceColorScheme fillColorScheme, SubstanceColorScheme borderScheme, int width, int height) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        ClassicFillPainter fillPainter = ClassicFillPainter.INSTANCE;
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter((Component)this.slider);
        int componentFontSize = SubstanceSizeUtils.getComponentFontSize((Component)this.slider);
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth((int)componentFontSize) / 2.0);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius((int)componentFontSize) / 2.0f;
        int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth((int)componentFontSize);
        HashMapKey key = SubstanceCoreUtilities.getHashKey((Object[])new Object[]{width, height, Float.valueOf(radius), borderDelta, borderThickness, fillColorScheme.getDisplayName(), borderScheme.getDisplayName()});
        BufferedImage trackImage = (BufferedImage)trackCache.get(key);
        if (trackImage == null) {
            trackImage = SubstanceCoreUtilities.getBlankImage((int)(width + 1), (int)(height + 1));
            Graphics2D cacheGraphics = trackImage.createGraphics();
            GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline((int)(width + 1), (int)(height + 1), (float)radius, null, (int)borderDelta);
            fillPainter.paintContourBackground((Graphics)cacheGraphics, (Component)this.slider, width, height, (Shape)contour, false, fillColorScheme, false);
            GeneralPath contourInner = SubstanceOutlineUtilities.getBaseOutline((int)(width + 1), (int)(height + 1), (float)(radius - (float)borderThickness), null, (int)(borderThickness + borderDelta));
            borderPainter.paintBorder((Graphics)cacheGraphics, (Component)this.slider, width + 1, height + 1, (Shape)contour, (Shape)contourInner, borderScheme);
            trackCache.put(key, (Object)trackImage);
            cacheGraphics.dispose();
        }
        g2d.drawImage((Image)trackImage, 0, 0, null);
        g2d.dispose();
    }

    private void paintSliderTrackSelected(Graphics2D graphics, Rectangle paintRect, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme, int width, int height) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        Insets insets = this.slider.getInsets();
        insets.top /= 2;
        insets.left /= 2;
        insets.bottom /= 2;
        insets.right /= 2;
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter((Component)this.slider);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter((Component)this.slider);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius((int)SubstanceSizeUtils.getComponentFontSize((Component)this.slider)) / 2.0f;
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth((int)SubstanceSizeUtils.getComponentFontSize((Component)this.slider)) / 2.0);
        if (this.slider.isEnabled()) {
            if (this.slider.getOrientation() == 0) {
                int fillMaxX;
                int fillMinX;
                int ltPos = this.thumbRect.x + this.thumbRect.width / 2 - paintRect.x;
                int utPos = this.upperThumbRect.x + this.upperThumbRect.width / 2 - paintRect.x;
                if (ltPos < utPos) {
                    fillMinX = ltPos;
                    fillMaxX = utPos;
                } else {
                    fillMinX = utPos;
                    fillMaxX = ltPos;
                }
                int fillWidth = fillMaxX - fillMinX;
                int fillHeight = height + 1;
                if (fillWidth > 0 && fillHeight > 0) {
                    GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline((int)fillWidth, (int)fillHeight, (float)radius, null, (int)borderDelta);
                    g2d.translate(fillMinX, 0);
                    fillPainter.paintContourBackground((Graphics)g2d, (Component)this.slider, fillWidth, fillHeight, (Shape)contour, false, fillScheme, false);
                    borderPainter.paintBorder((Graphics)g2d, (Component)this.slider, fillWidth, fillHeight, (Shape)contour, null, borderScheme);
                }
            } else {
                int fillMax;
                int fillMin;
                int ltPos = this.thumbRect.y + this.thumbRect.height / 2 - paintRect.y;
                int utPos = this.upperThumbRect.y + this.upperThumbRect.height / 2 - paintRect.y;
                if (ltPos < utPos) {
                    fillMin = ltPos;
                    fillMax = utPos;
                } else {
                    fillMin = utPos;
                    fillMax = ltPos;
                }
                int fillWidth = fillMax - fillMin;
                int fillHeight = height + 1;
                if (fillWidth > 0 && fillHeight > 0) {
                    GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline((int)fillWidth, (int)fillHeight, (float)radius, null, (int)borderDelta);
                    g2d.translate(paintRect.height - fillMax, 0);
                    fillPainter.paintContourBackground((Graphics)g2d, (Component)this.slider, fillWidth, fillHeight, (Shape)contour, false, fillScheme, false);
                    borderPainter.paintBorder((Graphics)g2d, (Component)this.slider, fillWidth, fillHeight, (Shape)contour, null, borderScheme);
                }
            }
        }
        g2d.dispose();
    }

    void setUpperThumbLocation(int x, int y) {
        this.upperThumbRect.setLocation(x, y);
        this.slider.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int blockIncrement = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (blockIncrement <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                blockIncrement = 1;
            }
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int oldValue = ((RangeSlider)this.slider).getUpperValue();
                ((RangeSlider)this.slider).setUpperValue(oldValue + delta);
            } else {
                int oldValue = this.slider.getValue();
                this.slider.setValue(oldValue + delta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int delta = 1 * (direction > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int oldValue = ((RangeSlider)this.slider).getUpperValue();
                ((RangeSlider)this.slider).setUpperValue(oldValue + delta);
            } else {
                int oldValue = this.slider.getValue();
                this.slider.setValue(oldValue + delta);
            }
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent arg0) {
            if (!RangeSliderUI.this.lowerDragging && !RangeSliderUI.this.upperDragging) {
                RangeSliderUI.this.calculateThumbLocation();
                RangeSliderUI.this.slider.repaint();
            }
        }
    }

    public class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        public RangeTrackListener() {
            super((BasicSliderUI)((Object)RangeSliderUI.this));
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!RangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (RangeSliderUI.this.slider.isRequestFocusEnabled()) {
                RangeSliderUI.this.slider.requestFocus();
            }
            boolean lowerPressed = false;
            boolean upperPressed = false;
            if (RangeSliderUI.this.isInsideLowerThumb(this.currentMouseX, this.currentMouseY)) {
                lowerPressed = true;
            } else if (RangeSliderUI.this.isInsideUpperThumb(this.currentMouseX, this.currentMouseY)) {
                upperPressed = true;
            }
            if (lowerPressed) {
                switch (RangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((RangeSliderUI)RangeSliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((RangeSliderUI)RangeSliderUI.this).thumbRect.x;
                    }
                }
                RangeSliderUI.this.upperThumbSelected = false;
                RangeSliderUI.this.lowerDragging = true;
                return;
            }
            RangeSliderUI.this.lowerDragging = false;
            if (upperPressed) {
                switch (RangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - RangeSliderUI.this.upperThumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - RangeSliderUI.this.upperThumbRect.x;
                    }
                }
                RangeSliderUI.this.upperThumbSelected = true;
                RangeSliderUI.this.upperDragging = true;
                return;
            }
            RangeSliderUI.this.upperDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            RangeSliderUI.this.lowerDragging = false;
            RangeSliderUI.this.upperDragging = false;
            RangeSliderUI.this.slider.setValueIsAdjusting(false);
            super.mouseReleased(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!RangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (RangeSliderUI.this.lowerDragging) {
                RangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveLowerThumb();
            } else if (RangeSliderUI.this.upperDragging) {
                RangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveUpperThumb();
            }
        }

        @Override
        public boolean shouldScroll(int direction) {
            return false;
        }

        private void moveLowerThumb() {
            int thumbMiddle = 0;
            switch (RangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((RangeSliderUI)RangeSliderUI.this).thumbRect.height / 2;
                    int thumbTop = this.currentMouseY - this.offset;
                    int trackTop = ((RangeSliderUI)RangeSliderUI.this).trackRect.y;
                    int trackBottom = ((RangeSliderUI)RangeSliderUI.this).trackRect.y + (((RangeSliderUI)RangeSliderUI.this).trackRect.height - 1);
                    int vMax = RangeSliderUI.this.yPositionForValue(RangeSliderUI.this.slider.getValue() + RangeSliderUI.this.slider.getExtent());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackBottom = vMax;
                    } else {
                        trackTop = vMax;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    RangeSliderUI.this.setThumbLocation(((RangeSliderUI)RangeSliderUI.this).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    RangeSliderUI.this.slider.setValue(RangeSliderUI.this.valueForYPosition(thumbMiddle));
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((RangeSliderUI)RangeSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = this.currentMouseX - this.offset;
                    int trackLeft = ((RangeSliderUI)RangeSliderUI.this).trackRect.x;
                    int trackRight = ((RangeSliderUI)RangeSliderUI.this).trackRect.x + (((RangeSliderUI)RangeSliderUI.this).trackRect.width - 1);
                    int hMax = RangeSliderUI.this.xPositionForValue(RangeSliderUI.this.slider.getValue() + RangeSliderUI.this.slider.getExtent());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackLeft = hMax;
                    } else {
                        trackRight = hMax;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    RangeSliderUI.this.setThumbLocation(thumbLeft, ((RangeSliderUI)RangeSliderUI.this).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    RangeSliderUI.this.slider.setValue(RangeSliderUI.this.valueForXPosition(thumbMiddle));
                    break;
                }
                default: {
                    return;
                }
            }
        }

        private void moveUpperThumb() {
            int thumbMiddle = 0;
            switch (RangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((RangeSliderUI)RangeSliderUI.this).thumbRect.height / 2;
                    int thumbTop = this.currentMouseY - this.offset;
                    int trackTop = ((RangeSliderUI)RangeSliderUI.this).trackRect.y;
                    int trackBottom = ((RangeSliderUI)RangeSliderUI.this).trackRect.y + (((RangeSliderUI)RangeSliderUI.this).trackRect.height - 1);
                    int vMin = RangeSliderUI.this.yPositionForValue(RangeSliderUI.this.slider.getValue());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackTop = vMin;
                    } else {
                        trackBottom = vMin;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    RangeSliderUI.this.setUpperThumbLocation(((RangeSliderUI)RangeSliderUI.this).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    RangeSliderUI.this.slider.setExtent(RangeSliderUI.this.valueForYPosition(thumbMiddle) - RangeSliderUI.this.slider.getValue());
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((RangeSliderUI)RangeSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = this.currentMouseX - this.offset;
                    int trackLeft = ((RangeSliderUI)RangeSliderUI.this).trackRect.x;
                    int trackRight = ((RangeSliderUI)RangeSliderUI.this).trackRect.x + (((RangeSliderUI)RangeSliderUI.this).trackRect.width - 1);
                    int hMin = RangeSliderUI.this.xPositionForValue(RangeSliderUI.this.slider.getValue());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackRight = hMin;
                    } else {
                        trackLeft = hMin;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    RangeSliderUI.this.setUpperThumbLocation(thumbLeft, ((RangeSliderUI)RangeSliderUI.this).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    RangeSliderUI.this.slider.setExtent(RangeSliderUI.this.valueForXPosition(thumbMiddle) - RangeSliderUI.this.slider.getValue());
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }
}

