/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.dialog;

import icy.gui.main.MainFrame;
import icy.main.Icy;
import icy.system.thread.ThreadUtil;
import java.awt.Component;
import javax.swing.JOptionPane;

public class MessageDialog {
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;

    public static void showDialog(String message) {
        MessageDialog.showDialog("Information", message, 1);
    }

    public static void showDialog(String message, int messageType) {
        String title;
        switch (messageType) {
            case 1: {
                title = "Information";
                break;
            }
            case 2: {
                title = "Warning";
                break;
            }
            case 0: {
                title = "Error";
                break;
            }
            case 3: {
                title = "Confirmation";
                break;
            }
            default: {
                title = "Message";
            }
        }
        MessageDialog.showDialog(title, message, messageType);
    }

    public static void showDialog(String title, String message) {
        MessageDialog.showDialog(title, message, 1);
    }

    public static void showDialog(final String title, final String message, final int messageType) {
        if (!Icy.getMainInterface().isHeadLess()) {
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame parent = Icy.getMainInterface().getMainFrame();
                    JOptionPane.showMessageDialog((Component)((Object)parent), message, title, messageType);
                }
            });
        } else if (messageType == 0) {
            System.err.println(String.valueOf(title) + ": " + message);
        } else {
            System.out.println(String.valueOf(title) + ": " + message);
        }
    }
}

